/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.io.IOException;
import java.io.PrintStream;
import org.freehep.graphicsio.QuadToCubicPathConstructor;

public class PSPathConstructor
extends QuadToCubicPathConstructor {
    private PrintStream os;
    private boolean intPrecision;
    private String moveto;
    private String lineto;
    private String curveto;
    private String close;

    public PSPathConstructor(PrintStream os, boolean useProlog, boolean intPrecision) {
        this.os = os;
        this.intPrecision = intPrecision;
        if (useProlog) {
            this.moveto = "m";
            this.lineto = "l";
            this.curveto = "c";
            this.close = "h";
        } else {
            this.moveto = "moveto";
            this.lineto = "lineto";
            this.curveto = "curveto";
            this.close = "closepath";
        }
    }

    public void move(double x2, double y2) throws IOException {
        this.os.println(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.moveto);
        super.move(x2, y2);
    }

    public void line(double x2, double y2) throws IOException {
        this.os.println(this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.lineto);
        super.line(x2, y2);
    }

    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        this.os.println(this.fixedPrecision(x1) + " " + this.fixedPrecision(y1) + " " + this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(x3) + " " + this.fixedPrecision(y3) + " " + " " + this.curveto);
        super.cubic(x1, y1, x2, y2, x3, y3);
    }

    public void closePath() throws IOException {
        this.os.println(this.close);
        super.closePath();
    }

    protected String fixedPrecision(double d2) {
        if (this.intPrecision) {
            return Integer.toString((int)d2);
        }
        String dbl = Double.toString(d2);
        int index = dbl.lastIndexOf(".");
        index = Math.min(index + 7, dbl.length());
        return dbl.substring(0, index);
    }
}

