/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.freehep.graphicsio.swf.DefineFontInfo;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineFont
extends DefinitionTag {
    private int character;
    private List shapes;
    private DefineFontInfo info;

    public DefineFont(int id) {
        this();
        this.character = id;
        this.shapes = new ArrayList();
    }

    public void add(SWFShape shape) {
        this.shapes.add(shape);
    }

    public DefineFont() {
        super(10, 1);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineFont tag = new DefineFont();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        int offset0 = swf.readUnsignedShort();
        int glyphCount = offset0 / 2;
        int[] offsets = new int[glyphCount];
        offsets[0] = offset0;
        int i2 = 1;
        while (i2 < glyphCount) {
            offsets[i2] = swf.readUnsignedShort();
            ++i2;
        }
        tag.shapes = new ArrayList();
        int i3 = 0;
        while (i3 < glyphCount) {
            tag.shapes.add(new SWFShape(swf));
            ++i3;
        }
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.pushBuffer();
        int[] offsets = new int[this.shapes.size()];
        int i2 = 0;
        while (i2 < this.shapes.size()) {
            offsets[i2] = swf.getBufferLength();
            ((SWFShape)this.shapes.get(i2)).write(swf);
            ++i2;
        }
        swf.popBuffer();
        int i3 = 0;
        while (i3 < this.shapes.size()) {
            swf.writeUnsignedShort(this.shapes.size() * 2 + offsets[i3]);
            ++i3;
        }
        swf.append();
    }

    public int getGlyphCount() {
        return this.shapes.size();
    }

    public void setFontInfo(DefineFontInfo info) {
        this.info = info;
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append(super.toString() + "\n");
        s2.append("  character:  " + this.character + "\n");
        s2.append("  glyphcount: " + this.shapes.size() + "\n");
        int i2 = 0;
        while (i2 < this.shapes.size()) {
            s2.append(this.shapes.get(i2) + "\n");
            ++i2;
        }
        s2.append("  fontInfo: " + this.info + "\n");
        return s2.toString();
    }
}

