/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import org.freehep.graphicsio.swf.DefineFont;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineFontInfo
extends DefinitionTag {
    protected int fontID;
    protected String name;
    protected boolean shiftJIS;
    protected boolean ansi;
    protected boolean italic;
    protected boolean bold;
    protected boolean wideCodes;
    protected int[] codes;

    public DefineFontInfo(int fontID, String name, boolean shiftJIS, boolean ansi, boolean italic, boolean bold, boolean wideCodes, int[] codes) {
        this();
        this.fontID = fontID;
        this.name = name;
        this.shiftJIS = shiftJIS;
        this.ansi = ansi;
        this.italic = italic;
        this.bold = bold;
        this.wideCodes = wideCodes;
        this.codes = codes;
    }

    public DefineFontInfo() {
        super(13, 1);
    }

    protected DefineFontInfo(int code, int version) {
        super(code, version);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineFontInfo tag = new DefineFontInfo();
        tag.fontID = swf.readUnsignedShort();
        DefineFont font = (DefineFont)swf.getDictionary().get(tag.fontID);
        int numGlyphs = font.getGlyphCount();
        font.setFontInfo(tag);
        int nameLength = swf.readUnsignedByte();
        tag.name = swf.getVersion() >= 6 ? swf.readUTF() : new String(swf.readByte(nameLength));
        int reserved = (int)swf.readUBits(3);
        tag.shiftJIS = swf.readBitFlag();
        tag.ansi = swf.readBitFlag();
        tag.italic = swf.readBitFlag();
        tag.bold = swf.readBitFlag();
        tag.wideCodes = swf.readBitFlag();
        tag.codes = tag.wideCodes ? swf.readUnsignedShort(numGlyphs) : swf.readUnsignedByte(numGlyphs);
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.fontID);
        swf.writeUnsignedByte(this.name.length());
        if (swf.getVersion() >= 6) {
            swf.writeUTF(this.name);
        } else {
            swf.writeByte(this.name.getBytes());
        }
        swf.writeUBits(0L, 3);
        swf.writeBitFlag(this.shiftJIS);
        swf.writeBitFlag(this.ansi);
        swf.writeBitFlag(this.italic);
        swf.writeBitFlag(this.bold);
        swf.writeBitFlag(this.wideCodes);
        if (this.wideCodes) {
            swf.writeUnsignedShort(this.codes);
        } else {
            swf.writeUnsignedByte(this.codes);
        }
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append(super.toString() + "\n");
        s2.append("  name:      " + this.name + "\n");
        s2.append("  numGlyphs: " + this.codes.length + "\n");
        s2.append("    ");
        int i2 = 0;
        while (i2 < this.codes.length) {
            s2.append("[" + this.codes[i2] + ",'" + (char)this.codes[i2] + "'] ");
            ++i2;
        }
        s2.append("\n");
        return s2.toString();
    }
}

