/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class LineStyle {
    private int width;
    private int endWidth;
    private Color color;
    private Color endColor;

    public LineStyle(int width, Color color) {
        this.width = width;
        this.color = color;
    }

    public LineStyle(int width, int endWidth, Color color, Color endColor) {
        this(width, color);
        this.endWidth = endWidth;
        this.endColor = endColor;
    }

    public LineStyle(SWFInputStream input, boolean isMorphStyle, boolean hasAlpha) throws IOException {
        if (!isMorphStyle) {
            this.width = input.readUnsignedShort();
            this.color = input.readColor(hasAlpha);
        } else {
            this.width = input.readUnsignedShort();
            this.endWidth = input.readUnsignedShort();
            this.color = input.readColor(true);
            this.endColor = input.readColor(true);
        }
    }

    public void write(SWFOutputStream swf, boolean hasAlpha) throws IOException {
        swf.writeUnsignedShort(this.width);
        if (this.endColor != null) {
            swf.writeUnsignedShort(this.endWidth);
        }
        swf.writeColor(this.color, hasAlpha || this.endColor != null);
        if (this.endColor != null) {
            swf.writeColor(this.endColor, true);
        }
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer("LineStyle " + this.width + ", " + this.color);
        if (this.endColor != null) {
            s2.append("; " + this.endWidth + ", " + this.endColor);
        }
        return s2.toString();
    }
}

