/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BackedPanel
extends JPanel
implements Serializable {
    private Graphics backingGraphics = null;
    protected BufferedImage backingImage = null;
    private Object lock = new Object();
    private Dimension oldDimension = new Dimension();
    private Dimension dim = new Dimension();
    protected Rectangle clip = new Rectangle();
    private static final String NON_NULL_BORDER_ERROR = "BackedPanel does not support borders.";

    public BackedPanel(boolean opaque) {
        super(false);
        this.setOpaque(opaque);
    }

    public Graphics getGraphics() {
        return this.backingGraphics;
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g2) {
        if (g2 != null && this.backingImage != null) {
            this.clip = g2.getClipBounds(this.clip);
            Object object = this.getLock();
            synchronized (object) {
                BufferedImage subimage = this.backingImage.getSubimage(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
                g2.drawImage(subimage, this.clip.x, this.clip.y, this);
            }
        }
    }

    public void paintBorder(Graphics g2) {
    }

    public void paintChildren(Graphics g2) {
    }

    public void printComponent(Graphics g2) {
    }

    public void printBorder(Graphics g2) {
    }

    public void printChildren(Graphics g2) {
    }

    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException(NON_NULL_BORDER_ERROR);
        }
    }

    public void setBounds(int x2, int y2, int w2, int h2) {
        super.setBounds(x2, y2, w2, h2);
        this.makeImage();
    }

    public void reshape(int x2, int y2, int w2, int h2) {
        super.reshape(x2, y2, w2, h2);
        this.makeImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeImage() {
        this.dim = this.getSize(this.dim);
        int w2 = this.dim.width;
        int h2 = this.dim.height;
        if (w2 > 0 && h2 > 0) {
            if (!this.oldDimension.equals(this.dim)) {
                Object object = this.getLock();
                synchronized (object) {
                    this.backingImage = this.isOpaque() ? (BufferedImage)super.createImage(w2, h2) : new BufferedImage(w2, h2, 2);
                    this.backingGraphics = this.backingImage.getGraphics();
                    this.oldDimension.setSize(this.dim);
                }
            }
        } else {
            Object object = this.getLock();
            synchronized (object) {
                this.backingImage = null;
                this.backingGraphics = null;
            }
        }
    }
}

