/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.freehep.swing.graphics.GraphicalSelectionEvent;
import org.freehep.swing.graphics.GraphicalSelectionListener;

public class GraphicalSelectionPanel
extends JPanel
implements MouseListener,
KeyListener,
MouseMotionListener,
Serializable {
    private ActionEvent actionEvent;
    protected LinkedList selectionActions = new LinkedList();
    protected ActionMap actionMap = new ActionMap();
    protected SelectionAction defaultModeAction = new SelectionAction("Default Mode", 13, KeyStroke.getKeyStroke(27, 0));
    protected SelectionAction nextAction = new SelectionAction("Next Mode", 10, KeyStroke.getKeyStroke(78, 0));
    protected SelectionAction previousAction = new SelectionAction("Previous Mode", 11, KeyStroke.getKeyStroke(80, 0));
    protected static final Stroke thinStroke = new BasicStroke(1.0f, 0, 0, 3.0f);
    protected static final Stroke thickStroke = new BasicStroke(3.0f, 0, 0, 5.0f);
    private JPopupMenu popup;
    private boolean processingPopup;
    private EventListenerList listenerList;
    private static final String NON_NULL_BORDER_ERROR = "GraphicalSelectionPanel does not support borders.";
    static /* synthetic */ Class class$org$freehep$swing$graphics$GraphicalSelectionListener;

    public GraphicalSelectionPanel() {
        JMenuItem item;
        TreeSet<KeyStroke> keys = new TreeSet<KeyStroke>();
        keys.add(KeyStroke.getKeyStroke(9, 2));
        this.setFocusTraversalKeys(0, keys);
        this.setFocusTraversalKeys(1, keys);
        this.setOpaque(false);
        this.listenerList = new EventListenerList();
        this.actionEvent = new ActionEvent(this, 0, "KeyAction");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setRequestFocusEnabled(true);
        this.makeSelectionActions();
        this.popup = new JPopupMenu();
        this.processingPopup = false;
        JPopupMenu popup = this.getPopupMenu();
        Iterator i2 = this.selectionActions.iterator();
        while (i2.hasNext()) {
            Action action = (Action)i2.next();
            item = new JMenuItem(action);
            KeyStroke accelerator = (KeyStroke)action.getValue("AcceleratorKey");
            this.addActionEntry(accelerator, action);
            item.setAccelerator(accelerator);
            popup.add(item);
        }
        popup.addSeparator();
        item = new JMenuItem(this.nextAction);
        KeyStroke accelerator = (KeyStroke)this.nextAction.getValue("AcceleratorKey");
        this.addActionEntry(accelerator, (Action)this.nextAction);
        item.setAccelerator(accelerator);
        popup.add(item);
        item = new JMenuItem(this.previousAction);
        accelerator = (KeyStroke)this.previousAction.getValue("AcceleratorKey");
        this.addActionEntry(accelerator, (Action)this.previousAction);
        item.setAccelerator(accelerator);
        popup.add(item);
        item = new JMenuItem(this.defaultModeAction);
        accelerator = (KeyStroke)this.defaultModeAction.getValue("AcceleratorKey");
        this.addActionEntry(accelerator, (Action)this.defaultModeAction);
        item.setAccelerator(accelerator);
        popup.add(item);
    }

    private void makeSelectionActions() {
        AbstractAction action = new SelectionAction("Zoom", 0, KeyStroke.getKeyStroke(10, 0));
        this.selectionActions.add(action);
        this.addActionEntry(10, (Action)action);
        action = new SelectionAction("Zoom (new view)", 1, KeyStroke.getKeyStroke(86, 0));
        this.selectionActions.add(action);
        this.addActionEntry(78, (Action)action);
        action = new SelectionAction("Pick", 2, KeyStroke.getKeyStroke(32, 0));
        this.selectionActions.add(action);
        this.addActionEntry(32, (Action)action);
        action = new SelectionAction("Pick (add)", 3, KeyStroke.getKeyStroke(521, 0));
        this.selectionActions.add(action);
        this.addActionEntry(61, (Action)action);
        this.addActionEntry(521, (Action)action);
        action = new SelectionAction("Un-Pick", 4, KeyStroke.getKeyStroke(45, 0));
        this.selectionActions.add(action);
        this.addActionEntry(523, (Action)action);
        this.addActionEntry(45, (Action)action);
        action = new ClearAction(KeyStroke.getKeyStroke(127, 0));
        this.selectionActions.add(action);
        this.addActionEntry(27, (Action)action);
        this.addActionEntry(8, (Action)action);
        this.addActionEntry(127, (Action)action);
    }

    protected void setSelectionActionsEnabled(boolean enable) {
        Iterator i2 = this.selectionActions.iterator();
        while (i2.hasNext()) {
            Action action = (Action)i2.next();
            action.setEnabled(enable);
        }
    }

    public void resetSelection() {
    }

    protected JPopupMenu getPopupMenu() {
        return this.popup;
    }

    protected void cancelPopupProcessing() {
        this.processingPopup = false;
    }

    public boolean isProcessingPopup(MouseEvent e2) {
        int id = e2.getID();
        boolean flag = this.processingPopup;
        if (id == 501) {
            if (!this.processingPopup && this.testPopupTrigger(e2)) {
                this.getPopupMenu().show(e2.getComponent(), e2.getX(), e2.getY());
                this.processingPopup = true;
                flag = true;
            }
        } else if (id == 502) {
            if (!this.processingPopup && this.testPopupTrigger(e2)) {
                this.getPopupMenu().show(e2.getComponent(), e2.getX(), e2.getY());
                this.processingPopup = true;
                flag = true;
            } else if (this.processingPopup && !this.getPopupMenu().isVisible()) {
                this.processingPopup = false;
                flag = true;
            }
        }
        return flag;
    }

    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException(NON_NULL_BORDER_ERROR);
        }
    }

    public final Border getBorder() {
        return null;
    }

    public void reshape(int x2, int y2, int width, int height) {
        this.resetSelection();
        super.reshape(x2, y2, width, height);
    }

    public void addGraphicalSelectionListener(GraphicalSelectionListener listener) {
        this.listenerList.add(class$org$freehep$swing$graphics$GraphicalSelectionListener == null ? (class$org$freehep$swing$graphics$GraphicalSelectionListener = GraphicalSelectionPanel.class$("org.freehep.swing.graphics.GraphicalSelectionListener")) : class$org$freehep$swing$graphics$GraphicalSelectionListener, listener);
    }

    public void removeGraphicalSelectionListener(GraphicalSelectionListener listener) {
        this.listenerList.remove(class$org$freehep$swing$graphics$GraphicalSelectionListener == null ? (class$org$freehep$swing$graphics$GraphicalSelectionListener = GraphicalSelectionPanel.class$("org.freehep.swing.graphics.GraphicalSelectionListener")) : class$org$freehep$swing$graphics$GraphicalSelectionListener, listener);
    }

    protected void fireGraphicalSelectionMade(GraphicalSelectionEvent gsEvent) {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == (class$org$freehep$swing$graphics$GraphicalSelectionListener == null ? GraphicalSelectionPanel.class$("org.freehep.swing.graphics.GraphicalSelectionListener") : class$org$freehep$swing$graphics$GraphicalSelectionListener)) {
                ((GraphicalSelectionListener)listeners[i2 + 1]).graphicalSelectionMade(gsEvent);
            }
            i2 -= 2;
        }
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
    }

    public void mouseReleased(MouseEvent e2) {
    }

    public void mouseDragged(MouseEvent e2) {
    }

    public void mouseMoved(MouseEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
        Action action;
        int keyCode = e2.getKeyCode();
        int modifiers = 0;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        InputMap inputMap = this.getInputMap();
        Object actionKey = inputMap.get(keyStroke);
        if (actionKey != null && (action = this.actionMap.get(actionKey)) != null) {
            action.actionPerformed(this.actionEvent);
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    protected void makeSelectionEvent(int type) {
    }

    protected boolean testPopupTrigger(MouseEvent e2) {
        int modifiers = e2.getModifiers();
        return (modifiers & 4) != 0;
    }

    protected void addActionEntry(int keyCode, Action action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, 0);
        this.addActionEntry(keyStroke, action);
    }

    protected void addActionEntry(KeyStroke keyStroke, Action action) {
        Object actionMapKey = action.getValue("Name");
        this.actionMap.put(actionMapKey, action);
        InputMap inputMap = this.getInputMap();
        inputMap.put(keyStroke, actionMapKey);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ClearAction
    extends AbstractAction {
        public ClearAction(KeyStroke keyStroke) {
            super("Clear");
            this.putValue("AcceleratorKey", keyStroke);
        }

        public void actionPerformed(ActionEvent e2) {
            GraphicalSelectionPanel.this.cancelPopupProcessing();
            GraphicalSelectionPanel.this.resetSelection();
        }
    }

    class SelectionAction
    extends AbstractAction {
        private int actionCode;

        public SelectionAction(String name, int actionCode) {
            super(name);
            this.actionCode = actionCode;
        }

        public SelectionAction(String name, int actionCode, KeyStroke keyStroke) {
            this(name, actionCode);
            this.putValue("AcceleratorKey", keyStroke);
        }

        public void actionPerformed(ActionEvent e2) {
            GraphicalSelectionPanel.this.cancelPopupProcessing();
            if (this.isEnabled()) {
                GraphicalSelectionPanel.this.makeSelectionEvent(this.actionCode);
            }
        }
    }
}

