/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.freehep.swing.graphics.AbstractRegionSelectionPanel;
import org.freehep.swing.graphics.GraphicalSelectionPanel;
import org.freehep.swing.images.FreeHepImage;

public class YSkewSelectionPanel
extends AbstractRegionSelectionPanel {
    private static final int STARTING_WIDTH = 25;

    public int getNumberOfControlPoints() {
        return 6;
    }

    public Cursor getControlPointCursor(int index) {
        int k2;
        switch (index) {
            case 0: 
            case 3: {
                k2 = 4;
                break;
            }
            case 1: 
            case 2: {
                k2 = 5;
                break;
            }
            case 4: 
            case 5: {
                return FreeHepImage.getCursor("0_MoveCursor", 16, 16);
            }
            default: {
                return FreeHepImage.getCursor("YSkewCursor");
            }
        }
        return AbstractRegionSelectionPanel.compassCursor("Resize", this.xCtrlPts[index] - this.xCtrlPts[k2], this.yCtrlPts[index] - this.yCtrlPts[k2], 4, false);
    }

    public void initializeControlPoints(int x2, int y2) {
        this.activeCtrlPt = 5;
        Arrays.fill(this.yCtrlPts, y2);
        this.xCtrlPts[0] = x2 - 25;
        this.xCtrlPts[1] = x2 - 25;
        this.xCtrlPts[2] = x2 + 25;
        this.xCtrlPts[3] = x2 + 25;
        this.xCtrlPts[4] = x2;
        this.xCtrlPts[5] = x2;
    }

    public void updateActiveControlPoint(int x2, int y2) {
        x2 = this.forceXCoordinateWithinBounds(x2);
        y2 = this.forceYCoordinateWithinBounds(y2);
        switch (this.activeCtrlPt) {
            case 0: {
                int width = x2 - this.xCtrlPts[4];
                this.xCtrlPts[0] = this.xCtrlPts[4] + width;
                this.xCtrlPts[1] = this.xCtrlPts[5] + width;
                this.xCtrlPts[2] = this.xCtrlPts[5] - width;
                this.xCtrlPts[3] = this.xCtrlPts[4] - width;
                break;
            }
            case 1: {
                int width = x2 - this.xCtrlPts[5];
                this.xCtrlPts[0] = this.xCtrlPts[4] + width;
                this.xCtrlPts[1] = this.xCtrlPts[5] + width;
                this.xCtrlPts[2] = this.xCtrlPts[5] - width;
                this.xCtrlPts[3] = this.xCtrlPts[4] - width;
                break;
            }
            case 2: {
                int width = x2 - this.xCtrlPts[5];
                this.xCtrlPts[0] = this.xCtrlPts[4] - width;
                this.xCtrlPts[1] = this.xCtrlPts[5] - width;
                this.xCtrlPts[2] = this.xCtrlPts[5] + width;
                this.xCtrlPts[3] = this.xCtrlPts[4] + width;
                break;
            }
            case 3: {
                int width = x2 - this.xCtrlPts[4];
                this.xCtrlPts[0] = this.xCtrlPts[4] - width;
                this.xCtrlPts[1] = this.xCtrlPts[5] - width;
                this.xCtrlPts[2] = this.xCtrlPts[5] + width;
                this.xCtrlPts[3] = this.xCtrlPts[4] + width;
                break;
            }
            case 4: {
                int width = this.xCtrlPts[4] - this.xCtrlPts[0];
                this.xCtrlPts[this.activeCtrlPt] = x2;
                this.yCtrlPts[this.activeCtrlPt] = y2;
                this.xCtrlPts[0] = x2 - width;
                this.yCtrlPts[0] = y2;
                this.xCtrlPts[3] = x2 + width;
                this.yCtrlPts[3] = y2;
                break;
            }
            case 5: {
                int width = this.xCtrlPts[4] - this.xCtrlPts[0];
                this.xCtrlPts[this.activeCtrlPt] = x2;
                this.yCtrlPts[this.activeCtrlPt] = y2;
                this.xCtrlPts[1] = x2 - width;
                this.yCtrlPts[1] = y2;
                this.xCtrlPts[2] = x2 + width;
                this.yCtrlPts[2] = y2;
                break;
            }
        }
        this.repaintPanel();
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setStroke(GraphicalSelectionPanel.thickStroke);
            g2.setColor(Color.black);
            g2.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g2.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            g2d.setStroke(GraphicalSelectionPanel.thinStroke);
            g2.setColor(Color.white);
            g2.drawPolygon(this.xCtrlPts, this.yCtrlPts, 4);
            if (this.visibleGuides) {
                g2.drawLine(this.xCtrlPts[4], this.yCtrlPts[4], this.xCtrlPts[5], this.yCtrlPts[5]);
            }
            if (this.activeCtrlPt >= 0) {
                g2.setColor(Color.black);
                g2.fillRect(this.xCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize - 1, this.yCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize - 1, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 3, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 3);
                g2.setColor(Color.white);
                g2.fillRect(this.xCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize, this.yCtrlPts[this.activeCtrlPt] - AbstractRegionSelectionPanel.ctrlPtSize, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 1, 2 * AbstractRegionSelectionPanel.ctrlPtSize + 1);
            }
        }
    }

    public AffineTransform makeAffineTransform() {
        int first = 0;
        int xSavedValue = this.xCtrlPts[first];
        int ySavedValue = this.yCtrlPts[first];
        int i2 = 1;
        while (i2 < 4) {
            int xValue = this.xCtrlPts[i2];
            int yValue = this.yCtrlPts[i2];
            if (yValue < ySavedValue) {
                xSavedValue = xValue;
                ySavedValue = yValue;
                first = i2;
            } else if (yValue == ySavedValue && xValue < xSavedValue) {
                xSavedValue = xValue;
                ySavedValue = yValue;
                first = i2;
            }
            ++i2;
        }
        int third = (first + 2) % 4;
        int dx0 = this.xCtrlPts[third] - this.xCtrlPts[first];
        int second = (first + 1) % 4;
        int dy1 = this.yCtrlPts[second] - this.yCtrlPts[first];
        int dy0 = this.yCtrlPts[third] - this.yCtrlPts[first];
        int dx1 = this.xCtrlPts[second] - this.xCtrlPts[first];
        if (dx0 * dy1 - dy0 * dx1 > 0) {
            second = (first + 3) % 4;
        }
        return this.makeTransform(this.xCtrlPts[first], this.yCtrlPts[first], this.xCtrlPts[second], this.yCtrlPts[second], this.xCtrlPts[third], this.yCtrlPts[third]);
    }

    public boolean isValidSelection() {
        return this.visible && this.yCtrlPts[4] != this.yCtrlPts[5] && this.xCtrlPts[0] != this.xCtrlPts[3];
    }
}

