/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commanddispatcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.commanddispatcher.CommandTarget;
import org.freehep.util.commanddispatcher.CommandTargetManager;
import org.freehep.util.commanddispatcher.SimpleCommandTarget;

class MultiTarget
implements SimpleCommandTarget {
    private List l = new ArrayList();
    private MultiGroup group = new MultiGroup();
    private MultiCommandState myState = new MultiCommandState();

    MultiTarget(String command) {
    }

    void add(CommandTarget t2) {
        this.l.add(t2);
        this.group.notifyObservers();
        t2.getGroup().addObserver(this.group);
    }

    void removeGroup(CommandGroup g2) {
        boolean wasChanged = false;
        Iterator i2 = this.l.iterator();
        while (i2.hasNext()) {
            CommandTarget t2 = (CommandTarget)i2.next();
            if (t2.getGroup() != g2) continue;
            i2.remove();
            g2.deleteObserver(this.group);
            wasChanged = true;
        }
        if (wasChanged) {
            this.group.notifyObservers();
        }
    }

    public void enable(CommandState state) {
        this.myState.setEnabled(false);
        int i2 = 0;
        while (i2 < this.l.size()) {
            ((CommandTarget)this.l.get(i2)).enable(this.myState);
            if (this.myState.isEnabled()) {
                state.setEnabled(true);
                return;
            }
            ++i2;
        }
        state.setEnabled(false);
    }

    public CommandGroup getGroup() {
        return this.group;
    }

    public void invoke() {
        int i2 = 0;
        while (i2 < this.l.size()) {
            SimpleCommandTarget target = (SimpleCommandTarget)this.l.get(i2);
            this.myState.setEnabled(false);
            target.enable(this.myState);
            if (this.myState.isEnabled()) {
                target.invoke();
            }
            ++i2;
        }
    }

    private class MultiGroup
    extends Observable
    implements CommandGroup,
    Observer {
        private MultiGroup() {
        }

        public CommandTarget acceptCommand(String command) {
            return MultiTarget.this;
        }

        public void setManager(CommandTargetManager manager) {
        }

        public void update(Observable o2, Object arg) {
            this.notifyObservers(arg);
        }

        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    }

    private class MultiCommandState
    implements CommandState {
        boolean enabled = false;

        private MultiCommandState() {
        }

        boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean state) {
            this.enabled = state;
        }

        public void setText(String text) {
        }

        public void setToolTipText(String text) {
        }
    }
}

