/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConditionalInputStream
extends InputStream {
    private int[] buffer = new int[4096];
    private int index;
    private int len;
    private InputStream in;
    private Properties defines;
    private int nesting;
    private boolean[] ok = new boolean[50];
    private boolean escape;

    public ConditionalInputStream(InputStream input, Properties defines) {
        this.in = input;
        this.defines = defines;
        this.nesting = 0;
        this.escape = false;
        this.index = 0;
        this.len = 0;
    }

    public int read() throws IOException {
        int n2;
        int b2;
        if (this.index < this.len) {
            b2 = this.buffer[this.index];
            ++this.index;
        } else {
            b2 = this.in.read();
        }
        if (b2 < 0) {
            return -1;
        }
        if (b2 == 92) {
            n2 = this.in.read();
            if (n2 == 64) {
                b2 = 32;
                this.escape = true;
            }
            this.buffer[0] = n2;
            this.index = 0;
            this.len = 1;
        }
        if (b2 == 64) {
            if (this.escape) {
                this.escape = false;
            } else {
                this.index = 0;
                StringBuffer s2 = new StringBuffer();
                n2 = this.in.read();
                while (n2 >= 0 && !Character.isWhitespace((char)n2)) {
                    s2.append((char)n2);
                    this.buffer[this.index] = n2;
                    n2 = this.in.read();
                    ++this.index;
                }
                this.buffer[this.index] = n2;
                ++this.index;
                b2 = 32;
                String keyword = s2.toString();
                if (keyword.equals("ifdef") || keyword.equals("ifndef")) {
                    s2 = new StringBuffer();
                    n2 = this.in.read();
                    while (n2 >= 0 && Character.isWhitespace((char)n2)) {
                        this.buffer[this.index] = n2;
                        n2 = this.in.read();
                        ++this.index;
                    }
                    while (n2 >= 0 && !Character.isWhitespace((char)n2)) {
                        s2.append((char)n2);
                        this.buffer[this.index] = n2;
                        n2 = this.in.read();
                        ++this.index;
                    }
                    this.buffer[this.index] = n2;
                    ++this.index;
                    String property = s2.toString();
                    this.ok[this.nesting] = this.defines.getProperty(property) != null ? (this.nesting <= 0 || this.ok[this.nesting - 1]) && keyword.equals("ifdef") : (this.nesting <= 0 || this.ok[this.nesting - 1]) && keyword.equals("ifndef");
                    ++this.nesting;
                    this.replaceBufferWithWhitespace(this.index);
                } else if (keyword.equals("else")) {
                    if (this.nesting <= 0) {
                        throw new RuntimeException("@else without corresponding @ifdef");
                    }
                    this.ok[this.nesting - 1] = (this.nesting <= 1 || this.ok[this.nesting - 2]) && !this.ok[this.nesting - 1];
                    this.replaceBufferWithWhitespace(this.index);
                } else if (keyword.equals("endif")) {
                    if (this.nesting <= 0) {
                        throw new RuntimeException("@endif without corresponding @ifdef");
                    }
                    --this.nesting;
                    this.replaceBufferWithWhitespace(this.index);
                } else {
                    b2 = 64;
                }
                this.len = this.index;
                this.index = 0;
            }
        }
        if (this.nesting > 0 && !this.ok[this.nesting - 1] && !Character.isWhitespace((char)b2)) {
            b2 = 32;
        }
        return b2 & 0xFF;
    }

    private void replaceBufferWithWhitespace(int size) {
        int i2 = 0;
        while (i2 < size) {
            if (!Character.isWhitespace((char)this.buffer[i2])) {
                this.buffer[i2] = 32;
            }
            ++i2;
        }
    }
}

