#ifndef H_FPSCOUNTER
#define H_FPSCOUNTER

#include <stdio.h>

class FPSCounter
{
public:
  FPSCounter() : Frames(0), LastFrames(0), FPS(0), LastTicks(0) {}
  
  void update(int TickCount)
  {
    Frames++;
    if (TickCount-LastTicks>1000) 
    {
      FPS=Frames-LastFrames;
      LastFrames=Frames;
      LastTicks=TickCount;
      sprintf(Str,"FPS: %d",FPS);
    }
  }

  int   getFPS() { return FPS; }
  char* getFPSString() { return Str; }

protected:
  int   Frames;
  int   LastFrames;
  int   LastTicks;
  int   FPS;
  char  Str[20];
};

#endif // H_FPSCOUNTER