/** \file 2D_Types.h
    Abstract types used by the 2D classes.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_2D_TYPES
#define H_2D_TYPES

#pragma comment(lib, "lib2D.lib")

class Sprite;

/** Abstract sprite selection class. */
class SpriteSelector
{
public:
  /** Return the sprite to be used. */
  virtual Sprite* getSprite() = 0;
};


enum ERRS_2D { INVALID_PARAMS=-1010 };


#endif // H_2D_TYPES