/** \file CON_Basic.h
    Basic interfaces.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.  
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_CON_BASIC
#define H_CON_BASIC

// Disable:  'class1' : inherits 'class2::member' via dominance
#pragma warning ( disable : 4250 )

/** Generic system interface class.  Prevents users from deleting abstract interfaces. */
class SystemInterface
{
protected:
  ~SystemInterface();
};

/** An interface is an abstract interface base that allows users to release
    it when it is not used any more.   release() replaces the delete operator */
class Interface : public SystemInterface
{
public:
  /** Release the object and destroy it.  Replaces the delete operator. */
  virtual long release() = 0;

  /** Returns the class name.  Used for diagnostics. */
  virtual const char* name() = 0;
};

class DiagnosticsCallback
{
public:
  virtual long action() = 0;
};

typedef unsigned char  uchar;
typedef unsigned short ushort;
typedef unsigned int   uint;
typedef unsigned long  ulong;

typedef unsigned short TColor;

enum { BitsPerPixel=sizeof(TColor)*8 };

#ifndef DLLExport
#define DLLExport __declspec( dllexport )
#endif

#endif // H_CON_BASIC