/** \file CON_Video.h
    Video stream operations.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.  
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_2D_VIDEO
#define H_2D_VIDEO

#include <CON_Math2D.h>
#include <CON_Drawable.h>
#include <CON_Sound.h>

class VideoReader : public Interface
{
public:
  /** Returns the size of bitmap required to store a video frame. */
  virtual Vector2D getFrameSize() = 0;

  /** Retrieves one frame from the video stream.  
      TimePoint is in seconds from the beginning of the stream. 
      -1 indicates letting the reader determine the current time point,
      assuming stream play is realtime.
      Returns 0 if successful, 1 for end of stream, and negative
      values to indicate errors.
  */
  virtual long getFrame(Drawable* Target, float TimePoint=-1.0f) = 0;

  /** Sets a default render target.
      It has to be with the dimensions specified by getFrameSize()
      It will be released by the reader when it's done. */
  virtual long setRenderTarget(Drawable* Target=NULL) = 0;

  /** Retrieve the audio stream associated with the video,
      returns NULL if there is no audio. */
  virtual SoundStream* getSound() = 0;

  /** Reset the video to the beginning for next frame. */
  virtual long reset() = 0;

  /** Returns the status of the VideoReader.
      Non-Zero values indicate an error has occured. */
  virtual long status() = 0;

};

/** \relates VideoReader
    Creates a new Video (AVI) reader. */
DLLExport VideoReader* newVideoReader(const char* Filename, int PlayAudio=1, int Audio3D=0);


#endif // H_2D_VIDEO