/** \file DS_Containable.h
    Generic containable

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage.
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_DS_CONTAINABLE
#define H_DS_CONTAINABLE

#include <DS_SysDep.h>

/** Generic containable class.
    All data elements which are placed in any container, must
    be subclasses of this class. */
class Containable
{
public:
  /** Destructor */
  virtual ~Containable() {}

  /** Unique hash value used for hash tables. */
  virtual size_t hashValue() const = 0;

  /** Comparison method to check if the object is less than the parameter */
  virtual DS_BOOL   lessThan(const Containable *c) const = 0;

  /** Comparison method to check if the object equals the parameter */
  virtual DS_BOOL   equals(const Containable *c) const = 0;


  virtual DS_BOOL operator==(const Containable& c) const { return equals(&c);    }
  virtual DS_BOOL operator!=(const Containable& c) const { return !(*this == c); }

  virtual DS_BOOL operator< (const Containable& c) const { return lessThan(&c);  }
  virtual DS_BOOL operator<=(const Containable& c) const { return lessThan(&c) || equals(&c); }
  virtual DS_BOOL operator> (const Containable& c) const { return !(*this <= c); }
  virtual DS_BOOL operator>=(const Containable& c) const { return !(*this <  c); }
};

typedef Containable* Data;

// Note: You might not need to derive from this class directly.
//       There are plenty of useful subclasses in the DS_SpecContainable.h file

#endif // H_DS_CONTAINABLE
