// mirrorM.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "mirrorM.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMirrorMApp

BEGIN_MESSAGE_MAP(CMirrorMApp, CWinApp)
	//{{AFX_MSG_MAP(CMirrorMApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMirrorMApp construction

CMirrorMApp::CMirrorMApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMirrorMApp object

CMirrorMApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMirrorMApp initialization

BOOL CMirrorMApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.

	if(Morfit_3D_card_check_hardware_support() == NO)
	{
		AfxMessageBox("This demo requires a 3D accellerator card.");
		return FALSE; 
	}




	// To create the main window, this code creates a new frame window
	// object and then sets it as the application's main window object.

	CMainFrame* pFrame = new CMainFrame;
	m_pMainWnd = pFrame;

	// create and load the frame with its resources

	pFrame->LoadFrame(IDR_MAINFRAME,
		WS_OVERLAPPEDWINDOW | FWS_ADDTOTITLE, NULL,
		NULL);




	// The one and only window has been initialized, so show and update it.
	pFrame->ShowWindow(SW_SHOW);
	pFrame->UpdateWindow();
												
	int rc=Morfit_engine_load_world("worlds\\mirror.wld","", "worlds\\bitmaps",USER_DEFINED_BEHAVIOR);
	if(rc == VR_ERROR)
	{
		AfxMessageBox("Fail to load world!");
		return FALSE; 
	}
	try
	{
		Morfit_3D_card_use(YES);
	}

	catch(...)
	{
		AfxMessageBox("An error occured when try to init 3D accellerator card\nPlease, contact to support@morfit.com.");
		return FALSE; 

	}
	
	Morfit_engine_advance_objects_automatically(NO);
	pFrame->m_Car.initialize();
	
	pFrame->cameraExternal = pFrame->m_ActiveCamera = Morfit_camera_get_first_camera();
	pFrame->cameraInternal = Morfit_camera_get_next_camera(pFrame->cameraExternal);

	pFrame->m_polyMirror = Morfit_polygon_get_handle_using_name("Ground");
	pFrame->m_needRender = TRUE;

 
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMirrorMApp message handlers





/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CMirrorMApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CMirrorMApp message handlers


BOOL CMirrorMApp::OnIdle(LONG lCount) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	
	
	BOOL result = CWinApp::OnIdle(lCount);
	CMainFrame *mFrame = (CMainFrame *)AfxGetMainWnd();
	if(mFrame->m_needRender)
	{

			mFrame->m_Car.move_car();
			mFrame->m_Render();	
			return TRUE;
		}
		return result;
	}
