//
//
//                                                           %__________%
//                                                          %/ . .  .   \%
//           Van Gogh 2D-Display Library                     |  . .  o. |
//                                                           |. _  .   .|
//        Microsoft Windows 95/98/NT Version                 | / \   .  |
//                                                           |_|_|_._._.|
//                                                           |.-.-.-.-..|
//                                                          %\__________/%
//                                                           %          %
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon & Chuck Walbourn
//
// bezier.cpp
//
// This is a simple bezier support module.  See the header file for
// interface details.
//
//

//
//
//                                Includes
//
//

#include "stdafx.h"
#include "bezier.h"

//
//
//                                 Code
//
//

//
// A local function to perform the De CastleJau algorithm.
//
static void bezier_recurse (BezierClosure &func, POINT pt0, POINT pt1, POINT pt2)
{
        if (pt0 == pt1 && pt1 == pt2)
        {
                func (pt0.x, pt0.y);
        }
        // Otherwise, draw curve segs
        else
        {
        // Calculate midpoints
                POINT m1 = midpoint (pt0, pt1);
                POINT m3 = midpoint (pt1, pt2);
                POINT m2 = midpoint (m1, m3);

                bezier_recurse (func, pt0, m1, m2);
                bezier_recurse (func, m2, m3, pt2);
        }
}


//
// The actual API function
//
void bezier (BezierClosure &func, POINT pts[4])
{
        bezier_recurse (func, pts[0], pts[1], pts[3]);
        //bezier_recurse (func, pts[1], pts[2], pts[3]);
}

// eof - bezier.cpp 
