'Declare variables
Dim im
'Create object
Set im = CreateObject("ActiveImage.Images.1")
'Set Image Format (JPEG = 1)
im.SetImageType 1
'Load image from file
'By default 1st image (the image where image index = 0) is active 
im.ReadFromFile "C:\rose.jpg" 
'Determine image width and height
h = im.GetHeight
w = im.GetWidth

' We need to work with image 1 (0 by default)
im.SetImage 1
' Create empty image with the specified size
' In this case image is 2 times smaller (linear dimensions)
im.CreateImage Cint(w/2),CInt(h/2)
' Copy image 0 to 1 (0,1 - indices of images)
' Copy the image to (0,0) point
' Copy the image from (0,0) point
' Destination area is smaller (we force resize)

im.CopyImageResize 1,0,0,0,0,0,CInt(w/2),CInt(h/2),w,h

'Clear current image
im.SetImage 0
im.DestroyImage
'Create new image
im.CreateImage w,h
'Set color and fill the image with the color
im.SetColor 255,0,0
im.DrawFilledRectangle 0,0,w,h
'Copy image 1 to image 0
'Copy image to the point with (CInt(w/4),CInt(h/4)) coordinates from (0,0)
'Copy image with width=CInt(w/2) and height=CInt(h/2)
im.CopyImage 0,1,CInt(w/4),CInt(h/4),0,0,CInt(w/2),CInt(h/2)

'Save Image to C:\center.jpg
im.WriteToFile "C:\center.jpg"

'Delete images
im.DestroyImage
im.SetImage 1
im.DestroyImage

Set im = Nothing
