/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.VariableSubstitutor;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsConstraint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Unpacker
extends Thread {
    private AutomatedInstallData idata;
    private AbstractUIProgressHandler handler;
    private UninstallData udata;
    private String jarLocation;
    private VariableSubstitutor vs;
    private static ArrayList instances = new ArrayList();

    public Unpacker(AutomatedInstallData automatedInstallData, AbstractUIProgressHandler abstractUIProgressHandler) {
        super("IzPack - Unpacker thread");
        this.idata = automatedInstallData;
        this.handler = abstractUIProgressHandler;
        this.vs = new VariableSubstitutor(automatedInstallData.getVariableValueMap());
    }

    public static ArrayList getRunningInstances() {
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        instances.add(this);
        try {
            Object object;
            FileOutputStream fileOutputStream = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
            List list = this.idata.selectedPacks;
            int n = list.size();
            this.handler.startAction("Unpacking", n);
            this.udata = UninstallData.getInstance();
            if (this.idata.kind.equalsIgnoreCase("web") || this.idata.kind.equalsIgnoreCase("web-kunststoff")) {
                InputStream inputStream = this.getClass().getResourceAsStream("/res/WebInstallers.url");
                object = new BufferedReader(new InputStreamReader(inputStream));
                this.jarLocation = ((BufferedReader)object).readLine();
            }
            for (int i = 0; i < n; ++i) {
                int n2;
                Object object2;
                Serializable serializable;
                Object object3;
                int n3;
                int n4 = this.idata.allPacks.indexOf(list.get(i));
                ObjectInputStream objectInputStream = new ObjectInputStream(this.getPackAsStream(n4));
                int n5 = objectInputStream.readInt();
                this.handler.nextStep(((Pack)list.get((int)i)).name, i + 1, n5);
                for (n3 = 0; n3 < n5; ++n3) {
                    PackFile packFile = (PackFile)objectInputStream.readObject();
                    if (OsConstraint.oneMatchesCurrentSystem(packFile.osConstraints)) {
                        String string;
                        int n6;
                        object3 = this.translatePath(packFile.targetPath);
                        serializable = new File((String)object3);
                        object2 = ((File)serializable).getParentFile();
                        if (!((File)object2).exists() && !((File)object2).mkdirs()) {
                            this.handler.emitError("Error creating directories", "Could not create directory\n" + ((File)object2).getPath());
                            this.handler.stopAction();
                            return;
                        }
                        this.udata.addFile((String)object3);
                        this.handler.progress(n3, (String)object3);
                        if (((File)serializable).exists() && packFile.override != 1) {
                            boolean bl = false;
                            if (packFile.override != 0) {
                                if (packFile.override == 1) {
                                    bl = true;
                                } else if (packFile.override == 4) {
                                    bl = ((File)serializable).lastModified() < packFile.mtime;
                                } else {
                                    int n7;
                                    int n8 = -1;
                                    if (packFile.override == 2) {
                                        n8 = 49;
                                    }
                                    if (packFile.override == 3) {
                                        n8 = 47;
                                    }
                                    boolean bl2 = bl = (n7 = this.handler.askQuestion(this.idata.langpack.getString("InstallPanel.overwrite.title") + ((File)serializable).getName(), this.idata.langpack.getString("InstallPanel.overwrite.question") + ((File)serializable).getAbsolutePath(), 37, n8)) == 47;
                                }
                            }
                            if (!bl) {
                                objectInputStream.skip(packFile.length);
                                continue;
                            }
                        }
                        fileOutputStream = new FileOutputStream((File)serializable);
                        byte[] byArray = new byte[5120];
                        for (long j = 0L; j < packFile.length; j += (long)n6) {
                            int n9 = packFile.length - j < (long)byArray.length ? (int)(packFile.length - j) : byArray.length;
                            n6 = objectInputStream.read(byArray, 0, n9);
                            if (n6 == -1) {
                                throw new IOException("Unexpected end of stream");
                            }
                            fileOutputStream.write(byArray, 0, n6);
                        }
                        fileOutputStream.close();
                        if (packFile.mtime >= 0L) {
                            ((File)serializable).setLastModified(packFile.mtime);
                        }
                        if (!(string = ((File)serializable).getName()).startsWith("izpack-keepme") || !string.endsWith(".tmp")) continue;
                        ((File)serializable).delete();
                        continue;
                    }
                    objectInputStream.skip(packFile.length);
                }
                n3 = objectInputStream.readInt();
                for (n2 = 0; n2 < n3; ++n2) {
                    object3 = (ParsableFile)objectInputStream.readObject();
                    ((ParsableFile)object3).path = this.translatePath(((ParsableFile)object3).path);
                    arrayList.add(object3);
                }
                int n10 = objectInputStream.readInt();
                for (n2 = 0; n2 < n10; ++n2) {
                    serializable = (ExecutableFile)objectInputStream.readObject();
                    ((ExecutableFile)serializable).path = this.translatePath(((ExecutableFile)serializable).path);
                    if (null != ((ExecutableFile)serializable).argList && !((ExecutableFile)serializable).argList.isEmpty()) {
                        object2 = null;
                        for (int j = 0; j < ((ExecutableFile)serializable).argList.size(); ++j) {
                            object2 = (String)((ExecutableFile)serializable).argList.get(j);
                            object2 = this.translatePath((String)object2);
                            ((ExecutableFile)serializable).argList.set(j, object2);
                        }
                    }
                    arrayList2.add(serializable);
                    if (((ExecutableFile)serializable).executionStage != 2) continue;
                    this.udata.addExecutable((ExecutableFile)serializable);
                }
                objectInputStream.close();
            }
            ScriptParser scriptParser = new ScriptParser(arrayList, this.vs);
            scriptParser.parseFiles();
            object = new FileExecutor(arrayList2);
            if (((FileExecutor)object).executeFiles(0, this.handler) != 0) {
                this.handler.emitError("File execution failed", "The installation was not completed");
            }
            if (this.idata.info.getWriteUninstaller()) {
                this.putUninstaller();
            }
            this.handler.stopAction();
        }
        catch (Exception exception) {
            this.handler.stopAction();
            this.handler.emitError("An error occured", exception.toString());
            exception.printStackTrace();
        }
        finally {
            instances.remove(instances.indexOf(this));
        }
    }

    private void putUninstaller() throws Exception {
        int n;
        ZipOutputStream zipOutputStream;
        String string = this.translatePath("$INSTALL_PATH") + File.separator + "Uninstaller";
        String string2 = string + File.separator + "uninstaller.jar";
        File file = new File(string);
        file.mkdirs();
        UninstallData uninstallData = UninstallData.getInstance();
        uninstallData.setUninstallerJarFilename(string2);
        uninstallData.setUninstallerPath(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        this.idata.uninstallOutJar = zipOutputStream = new ZipOutputStream(fileOutputStream);
        zipOutputStream.setLevel(9);
        uninstallData.addFile(string2);
        InputStream inputStream = this.getClass().getResourceAsStream("/res/IzPack.uninstaller");
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            n = zipInputStream.read();
            while (n != -1) {
                zipOutputStream.write(n);
                n = zipInputStream.read();
            }
            zipInputStream.closeEntry();
            zipOutputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        inputStream = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        zipOutputStream.putNextEntry(new ZipEntry("langpack.xml"));
        n = inputStream.read();
        while (n != -1) {
            zipOutputStream.write(n);
            n = inputStream.read();
        }
        zipOutputStream.closeEntry();
    }

    private InputStream getPackAsStream(int n) throws Exception {
        InputStream inputStream = null;
        if (this.idata.kind.equalsIgnoreCase("standard") || this.idata.kind.equalsIgnoreCase("standard-kunststoff")) {
            inputStream = this.getClass().getResourceAsStream("/packs/pack" + n);
        } else if (this.idata.kind.equalsIgnoreCase("web") || this.idata.kind.equalsIgnoreCase("web-kunststoff")) {
            URL uRL = new URL("jar:" + this.jarLocation + "!/packs/pack" + n);
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            inputStream = jarURLConnection.getInputStream();
        }
        return inputStream;
    }

    private String translatePath(String string) {
        string = this.vs.substitute(string, null);
        return string.replace('/', File.separatorChar);
    }
}

