/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class VariableSubstitutor {
    protected Map environment;
    protected static final int TYPE_PLAIN = 0;
    protected static final int TYPE_JAVA_PROPERTIES = 1;
    protected static final int TYPE_XML = 2;
    protected static final int TYPE_SHELL = 3;
    protected static Map typeNameToConstantMap = new HashMap();

    public VariableSubstitutor(Map map) {
        this.environment = map;
    }

    public String substitute(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        StringWriter stringWriter = new StringWriter();
        try {
            this.substitute(stringReader, stringWriter, string2);
        }
        catch (IOException iOException) {
            throw new Error("Unexpected I/O exception when reading/writing memory buffer; nested exception is: " + iOException);
        }
        return stringWriter.getBuffer().toString();
    }

    public void substitute(InputStream inputStream, OutputStream outputStream, String string, String string2) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        if (string2 == null) {
            int n = this.getTypeConstant(string);
            switch (n) {
                case 1: {
                    string2 = "ISO-8859-1";
                    break;
                }
                case 2: {
                    string2 = "UTF-8";
                }
            }
        }
        InputStreamReader inputStreamReader = string2 != null ? new InputStreamReader(inputStream, string2) : new InputStreamReader(inputStream);
        OutputStreamWriter outputStreamWriter = string2 != null ? new OutputStreamWriter(outputStream, string2) : new OutputStreamWriter(outputStream);
        this.substitute(inputStreamReader, outputStreamWriter, string);
        outputStreamWriter.flush();
    }

    public void substitute(Reader reader, Writer writer, String string) throws IllegalArgumentException, IOException {
        int n = this.getTypeConstant(string);
        int n2 = n == 3 ? 37 : 36;
        int n3 = reader.read();
        while (true) {
            boolean bl;
            if (n3 != -1 && n3 != n2) {
                writer.write(n3);
                n3 = reader.read();
                continue;
            }
            if (n3 == -1) {
                return;
            }
            boolean bl2 = false;
            n3 = reader.read();
            if (n3 == 123) {
                bl2 = true;
                n3 = reader.read();
            } else if (n3 == -1) {
                writer.write(n2);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (n3 >= 97 && n3 <= 122 || n3 >= 65 && n3 <= 90 || (n3 >= 48 && n3 <= 57 || n3 == 95) && stringBuffer.length() > 0) {
                stringBuffer.append((char)n3);
                n3 = reader.read();
            }
            String string2 = stringBuffer.toString();
            boolean bl3 = bl = (!bl2 || n3 == 125) && string2.length() > 0 && this.environment.containsKey(string2);
            if (bl) {
                writer.write(this.escapeSpecialChars((String)this.environment.get(string2), n));
                if (!bl2) continue;
                n3 = reader.read();
                continue;
            }
            writer.write(n2);
            if (bl2) {
                writer.write(123);
            }
            writer.write(string2);
        }
    }

    protected int getTypeConstant(String string) {
        if (string == null) {
            return 0;
        }
        Integer n = (Integer)typeNameToConstantMap.get(string);
        if (n == null) {
            throw new IllegalArgumentException("Unknown file type " + string);
        }
        return n;
    }

    protected String escapeSpecialChars(String string, int n) {
        switch (n) {
            case 0: 
            case 3: {
                return string;
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n2 = string.length();
                for (int i = 0; i < n2; ++i) {
                    char c = stringBuffer.charAt(i);
                    if (c == '\t' || c == '\n' || c == '\r') {
                        char c2 = c == '\t' ? (char)'t' : (c == '\n' ? (char)'n' : 'r');
                        stringBuffer.replace(i, i + 1, "\\" + c2);
                        ++n2;
                        ++i;
                    }
                    if (c != '\\' && c != '\"' && c != '\'' && c != ' ') continue;
                    stringBuffer.insert(i, '\\');
                    ++n2;
                    ++i;
                }
                return stringBuffer.toString();
            }
            case 2: {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n3 = string.length();
                for (int i = 0; i < n3; ++i) {
                    String string2 = null;
                    char c = stringBuffer.charAt(i);
                    switch (c) {
                        case '<': {
                            string2 = "&lt;";
                            break;
                        }
                        case '>': {
                            string2 = "&gt;";
                            break;
                        }
                        case '&': {
                            string2 = "&amp;";
                            break;
                        }
                        case '\'': {
                            string2 = "&apos;";
                            break;
                        }
                        case '\"': {
                            string2 = "&quot;";
                        }
                    }
                    if (string2 == null) continue;
                    stringBuffer.replace(i, i + 1, string2);
                    n3 = stringBuffer.length();
                    i += string2.length() - 1;
                }
                return stringBuffer.toString();
            }
        }
        throw new Error("Unknown file type constant " + n);
    }

    static {
        typeNameToConstantMap.put("plain", new Integer(0));
        typeNameToConstantMap.put("javaprop", new Integer(1));
        typeNameToConstantMap.put("xml", new Integer(2));
        typeNameToConstantMap.put("shell", new Integer(3));
    }
}

