void __fastcall TDesignForm::FrameToTree(
  LPDIRECT3DRMFRAME Iframe)
{
  CurrNode = Tree->Selected;
  Tree->OnChange = NULL;
  Tree->Items->BeginUpdate();
  FrameToTreeRecursion(Iframe);
  Tree->Items->EndUpdate();
  Tree->OnChange = TreeChange;
}//---------------------------------------------------------
void __fastcall TDesignForm::FrameToTreeRecursion(
  LPDIRECT3DRMFRAME Iframe)
{
  TTreeNode *NewNode;
  if (!Iframe) return;
  //       
  // :
  if (Iframe == D3dView->ICamera) return;

  //     :
  NewNode=Tree->Items->AddChildObject(CurrNode, "", Iframe);
  //    :
  TreeGetImageIndex(this, NewNode);

  DWORD i;
  //-------------------------------------------------------
  //   :
  LPDIRECT3DRMLIGHTARRAY ILightArray = NULL;
  Iframe->GetLights(&ILightArray);
  if (ILightArray)
  for (i = 0; i < ILightArray->GetSize(); i++) {
     LPDIRECT3DRMLIGHT Ilight = NULL;
     ILightArray->GetElement(i, &Ilight);
     if (Ilight)
     TreeGetImageIndex(this,
          Tree->Items->AddChildObject(NewNode, "", Ilight));
     RELEASE(Ilight);
  } RELEASE(ILightArray);
  //-------------------------------------------------------
  //   :
  LPDIRECT3DRMVISUALARRAY IVisualArray = NULL;
  Iframe->GetVisuals(&IVisualArray);
  if (IVisualArray)
  for (i = 0; i < IVisualArray->GetSize(); i++) {
     LPDIRECT3DRMVISUAL Ivisual = NULL;
     IVisualArray->GetElement(i, &Ivisual);
     if (Ivisual)
     TreeGetImageIndex(this,
         Tree->Items->AddChildObject(NewNode, "", Ivisual));
     RELEASE(Ivisual);
  } RELEASE(IVisualArray);
  //-------------------------------------------------------
  //    :
  LPDIRECT3DRMFRAMEARRAY IFrameArray = NULL;
  Iframe->GetChildren(&IFrameArray);
  if (IFrameArray)
  for (i = 0; i < IFrameArray->GetSize(); i++) {
     LPDIRECT3DRMFRAME Itemp_frame = NULL;
     IFrameArray->GetElement(i, &Itemp_frame);
     //     :
     CurrNode = NewNode;
     FrameToTreeRecursion(Itemp_frame);
     //     :
     CurrNode = CurrNode->Parent;
     RELEASE(Itemp_frame);
  } RELEASE(IFrameArray);
}//---------------------------------------------------------
