void __fastcall TDesignForm::TreeChange(TObject*,
  TTreeNode *Node)
{
  //     :
  if (IsLight(Node->Data)) cmdCopy->Enabled = false;
  else cmdCopy->Enabled = true;

  TTreeNode* CurrParent = CurrentFrameNode();
  if (CurrParent)
     ISelFrame = ASFRAME(CurrParent->Data);
  else ISelFrame = NULL;

  if (IsTexture(Node->Data))
     ISelTexture = ASTEXTURE(Node->Data);
  else ISelTexture = NULL;

  if (IsBuilder(Node->Data)) {
     ILastSelBuilder = ISelBuilder;
     ILastSelFace    = ISelFace;
     ISelBuilder     = ASBUILDER(Node->Data);
     ISelFace        = NULL;
  } else {
     ISelBuilder     = NULL;
     ISelFace        = NULL;
  }
  UpdateTools(this);
}//---------------------------------------------------------
void __fastcall TDesignForm::UpdateTools(TObject*) {
  StatBar->SimplePanel = false;
  //     MaterialForm:
       if (ISelFace)    MaterialForm->Manage(ISelFace);
  else if (ISelBuilder) MaterialForm->Manage(ISelBuilder);
  else if (ISelFrame)   MaterialForm->Manage(ISelFrame);
  else                  MaterialForm->Manage(NULL);
  //     WrapForm:
       if (ISelFace)    WrapForm->Manage(ISelFace);
  else if (ISelBuilder) WrapForm->Manage(ISelBuilder);
  else                  WrapForm->Manage(NULL);
  //     TextureForm:
       if (ISelFace)    TextureForm->Manage(ISelFace);
  else if (ISelBuilder) TextureForm->Manage(ISelBuilder);
  else if (ISelTexture) TextureForm->Manage(ISelTexture);
  else if (ISelFrame)   TextureForm->Manage(ISelFrame);
  else                  TextureForm->Manage(NULL);

  //      
  // :
  TTreeNode* N = CurrentFrameNode();
  if (N && N->Data) {
     LPDIRECT3DRMFRAME Iframe  = ASFRAME(N->Data);
     LPDIRECT3DRMFRAME Iparent = NULL;
     Iframe->GetParent(&Iparent);
     D3DVECTOR spos, ppos;
     //   :
     Iframe->GetPosition(D3dView->IScene,  &spos);
     //    :
     Iframe->GetPosition(Iparent, &ppos);
     #define FTSF(x) FloatToStrF(x, ffFixed, 15,2)
     StatBar->Panels->Items[1]->Text  = FTSF(spos.x);
     StatBar->Panels->Items[3]->Text  = FTSF(spos.y);
     StatBar->Panels->Items[5]->Text  = FTSF(spos.z);
     StatBar->Panels->Items[7]->Text  = FTSF(ppos.x);
     StatBar->Panels->Items[9]->Text  = FTSF(ppos.y);
     StatBar->Panels->Items[11]->Text = FTSF(ppos.z);
     RELEASE(Iparent);
     #undef FTSF(x)
  }
  char buf[512]; buf[0] = 0;
  //       
  //    :
  if (Tree->Selected)
     sprintf(buf, "%s - %s",
             RMClassName(Tree->Selected->Data),
             RMName     (Tree->Selected->Data));
  StatBar->Panels->Items[12]->Text = AnsiString(buf);
  //      
  //  :
  D3DRMBOX Box;
  memset(&Box, 0, sizeof(Box));
  buf[0] = 0;
        if (ISelBuilder) ISelBuilder->GetBox(&Box);
  else  if (ISelFrame)   FrameGetBox(ISelFrame, &Box);
  D3DVALUE x, y, z;
  x = Box.min.x; y = Box.min.y; z = Box.min.z;
  sprintf(buf, "%.2f ; %.2f ; %.2f", x, y, z);
  BoxStat->Panels->Items[1]->Text = buf;
  x = Box.max.x; y = Box.max.y; z = Box.max.z;
  sprintf(buf, "%.2f ; %.2f ; %.2f", x, y, z);
  BoxStat->Panels->Items[3]->Text = buf;
  x = Box.max.x - Box.min.x;
  y = Box.max.y - Box.min.y;
  z = Box.max.z - Box.min.z;
  sprintf(buf, "%.2f x %.2f x %.2f", x, y, z);
  BoxStat->Panels->Items[5]->Text = buf;

  StatBar->Invalidate();
  BoxStat->Invalidate();

  D3dView->Update();
  DrawCurrentCS();
  DrawSelections();
}//---------------------------------------------------------
