/*
 * Decompiled with CFR 0.152.
 */
package addressbook;

import addressbook.Contact;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import rogatkin.GranulatedLayout;

public class NewContactFrame
extends JFrame
implements ActionListener {
    Contact contact;

    NewContactFrame() {
        super("New Contact");
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.insertTab("General", null, new GeneralTab(), "Specify general contact information here", 0);
        jTabbedPane.insertTab("Details", null, new DetailsTab(), "Provide more details for friend and/or partner", 1);
        jTabbedPane.insertTab("Certificates", null, new CertificatesTab(), "Add certificates for signing and encryption", 2);
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)this.createButtons(this), "South");
        this.pack();
        ((Component)this).setVisible(true);
    }

    public JPanel createButtons(ActionListener actionListener) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton("OK");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton("<html><i>Apply");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton("Cancel");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("OK".equals(string)) {
            this.dispose();
        } else if ("Cancel".equals(string)) {
            this.dispose();
        } else if ("<html><i>Apply".equals(string)) {
            // empty if block
        }
    }

    class CertificatesTab
    extends JPanel {
        CertificatesTab() {
        }
    }

    abstract class TabbedArrayOfComponents
    extends JTabbedPane {
        TabbedArrayOfComponents(int n) {
            super(n);
        }

        abstract JComponent produce();

        void addElement(String string) {
            if (this.indexOfTab(string) > 0) {
                this.setSelectedIndex(this.indexOfTab(string));
                return;
            }
            this.addTab(string, this.produce());
        }

        void modifyElement(String string, String string2) {
            int n = this.indexOfTab(string);
            if (n >= 0) {
                this.setTitleAt(n, string2);
            }
        }

        void modifyElement(String string) {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                this.setTitleAt(n, string);
            }
        }

        void deleteElement() {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                this.removeTabAt(n);
            }
        }

        void deleteElement(String string) {
            int n = this.indexOfTab(string);
            if (n >= 0) {
                this.removeTabAt(n);
            }
        }

        JComponent getElement(String string) {
            int n = this.indexOfTab(string);
            if (n < 0) {
                return null;
            }
            return (JComponent)this.getComponentAt(n);
        }
    }

    class DetailsTab
    extends JPanel
    implements ActionListener {
        TabbedArrayOfComponents addrs;
        JTextField tf_name;

        DetailsTab() {
            this.setLayout(new GranulatedLayout(4, 10, 20, 4, 8, 8));
            this.add((Component)new JLabel("Addresses"), "0,0,2");
            this.tf_name = new JTextField();
            this.add((Component)this.tf_name, "3,1");
            JButton jButton = new JButton("Add");
            this.add((Component)jButton, "3,2,1");
            jButton.addActionListener(this);
            jButton = new JButton("Modify");
            this.add((Component)jButton, "3,3,1");
            jButton.addActionListener(this);
            jButton = new JButton("Delete");
            this.add((Component)jButton, "3,4,1");
            jButton.addActionListener(this);
            this.addrs = new TabbedArrayOfComponents(this, 3){
                private final /* synthetic */ DetailsTab this$1;
                {
                    this.this$1 = detailsTab;
                }

                JComponent produce() {
                    return new JTextArea();
                }
            };
            this.add((Component)this.addrs, "0,1,3,4");
            this.add((Component)new JLabel("Photo"), "0,5,1");
            this.add((Component)new JLabel("Comment"), "0,9,1");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("Add".equals(string)) {
                this.addrs.addElement(this.tf_name.getText());
                this.tf_name.setText("");
            } else if ("Modify".equals(string)) {
                this.addrs.modifyElement(this.tf_name.getText());
                this.tf_name.setText("");
            } else if ("Delete".equals(string)) {
                this.addrs.deleteElement();
            }
        }

        static /* synthetic */ NewContactFrame access$000(DetailsTab detailsTab) {
            return detailsTab.NewContactFrame.this;
        }
    }

    class GeneralTab
    extends JPanel {
        JTextField tf_name;
        JTable tb_tphones;
        JTable tb_emails;

        GeneralTab() {
            this.setLayout(new GranulatedLayout(2, 10, 20, 4, 8, 8));
            this.add((Component)new JLabel("Name"), "0,0,1");
            this.tf_name = new JTextField();
            this.add((Component)this.tf_name, "0,1,2");
            this.tb_emails = new JTable(new EmailsTableModel());
            this.add((Component)new JScrollPane(this.tb_emails), "0,2,2,4,0,12");
            this.tb_tphones = new JTable(new PnonesTableModel());
            this.add((Component)new JScrollPane(this.tb_tphones), "0,6,2,4,0,12");
        }

        class PnonesTableModel
        extends AbstractTableModel {
            String[][] tel_phones = new String[][]{{"Home", "238-3782"}, {"Work", "238-8782"}, {"Mobile", "288-3782"}, {"Isdn", "258-3782"}, {"New ", "xxx-xxxx"}};

            PnonesTableModel() {
            }

            public String getColumnName(int n) {
                if (n == 1) {
                    return "Phone";
                }
                return "Abrev";
            }

            public int getRowCount() {
                return this.tel_phones.length;
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int n, int n2) {
                return this.tel_phones[n][n2];
            }
        }

        class EmailsTableModel
        extends AbstractTableModel {
            String[][] emails = new String[][]{{"Home", "home@hotmail.com"}, {"Work", "george@intercompany.com"}, {"Hobby", "sprut@georgia.org"}, {"New ", "name@domain.net"}};

            EmailsTableModel() {
            }

            public String getColumnName(int n) {
                if (n == 1) {
                    return "E-Mail";
                }
                return "Abrev";
            }

            public int getRowCount() {
                return this.emails.length;
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int n, int n2) {
                return this.emails[n][n2];
            }
        }
    }
}

