/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.Courier;
import photoorganizer.HtmlProducer;
import photoorganizer.UiUpdater;
import photoorganizer.album.Access;
import photoorganizer.album.AlbumModel;
import photoorganizer.courier.FTPCourier;
import photoorganizer.courier.FileCourier;
import photoorganizer.courier.HTTPCourier;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.renderer.AlbumProperties;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.AlbumThumbnailsPanel;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.SendEmailFrame;
import photoorganizer.renderer.StatusBar;
import rogatkin.BaseController;
import rogatkin.Serializer;

public class AlbumPane
extends JTree
implements ActionListener,
TreeSelectionListener {
    AlbumThumbnailsPanel thumbnails;
    PhotoCollectionPanel collectionpanel;
    private StatusBar statusbar;
    private boolean in_dragging;
    private JLabel draggedLabel;
    private JPanel glassPanel;
    private TreePath srcPath;
    private int srcAlbumId;
    private int dstAlbumId;
    private int parentAlbumId;
    private Controller controller;
    private AlbumSelectionDialog albumselection;
    Access access;

    public AlbumPane(Controller controller) {
        this.controller = controller;
        this.access = new Access(controller);
        this.setModel(new AlbumModel(this.access));
        this.getSelectionModel().setSelectionMode(1);
        this.statusbar = (StatusBar)controller.component(Controller.COMP_STATUSBAR);
        this.glassPanel = (JPanel)this.controller.getMainGlassPane();
        this.draggedLabel = new JLabel((Icon)UIManager.get("Tree.closedIcon"));
        this.draggedLabel.setOpaque(false);
        this.glassPanel.add(this.draggedLabel);
        this.addTreeSelectionListener(this);
        this.addMouseListener(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) > 0) {
                    Point point = ((JViewport)AlbumPane.this.getParent()).getViewPosition();
                    new AlbumRightBtnMenu(AlbumPane.this).show(AlbumPane.this.getParent(), mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!AlbumPane.this.in_dragging) {
                    return;
                }
                AlbumPane.this.setCursor(Cursor.getDefaultCursor());
                AlbumPane.this.glassPanel.setVisible(false);
                TreePath treePath = AlbumPane.this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null && treePath != AlbumPane.this.srcPath && AlbumPane.this.srcPath != null) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    AlbumPane.this.srcAlbumId = AlbumPane.this.access.getAlbumId(AlbumPane.this.srcPath);
                    AlbumPane.this.parentAlbumId = AlbumPane.this.access.getAlbumId(AlbumPane.this.srcPath.getParentPath());
                    AlbumPane.this.dstAlbumId = AlbumPane.this.access.getAlbumId(treePath);
                    Object[] objectArray = new String[]{AlbumPane.this.access.getNameOfAlbum(AlbumPane.this.srcAlbumId), AlbumPane.this.access.getNameOfAlbum(AlbumPane.this.dstAlbumId)};
                    JMenuItem jMenuItem = new JMenuItem("Cancel");
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(AlbumPane.this);
                    jMenuItem = new JMenuItem(MessageFormat.format("Move album {0} under {1}", objectArray));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(AlbumPane.this);
                    jMenuItem = new JMenuItem(MessageFormat.format("Copy album {0} under {1}", objectArray));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(AlbumPane.this);
                    jPopupMenu.show(AlbumPane.this, mouseEvent.getX(), mouseEvent.getY());
                }
                AlbumPane.this.in_dragging = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (!AlbumPane.this.in_dragging) {
                    AlbumPane.this.srcPath = AlbumPane.this.getSelectionPath();
                    AlbumPane.this.glassPanel.setVisible(true);
                }
                AlbumPane.this.draggedLabel.setLocation(SwingUtilities.convertPoint(AlbumPane.this, mouseEvent.getX(), mouseEvent.getY(), AlbumPane.this.glassPanel));
                AlbumPane.this.in_dragging = true;
                AlbumPane.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        this.setEditable(true);
    }

    void setTumbnailsPanel(AlbumThumbnailsPanel albumThumbnailsPanel) {
        this.thumbnails = albumThumbnailsPanel;
    }

    void setCollectionPanel(PhotoCollectionPanel photoCollectionPanel) {
        this.collectionpanel = photoCollectionPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        boolean bl = false;
        boolean bl2 = false;
        if (string.equals("To selection")) {
            this.collectionpanel.add(this.access.getAlbumContents(this.access.getAlbumId(this.getSelectionPath())));
        } else if (string.equals("Delete")) {
            this.access.deleteAlbumFrom(new int[]{this.access.getAlbumId(this.getSelectionPath().getParentPath())}, this.access.getAlbumId(this.getSelectionPath()));
            this.invalidateTree();
        } else if (string.equals("Delete all")) {
            this.access.deleteAlbum(this.access.getAlbumId(this.getSelectionPath()));
            this.invalidateTree();
        } else if (string.equals("Copy/move")) {
            final int n = this.access.getAlbumId(this.getSelectionPath());
            if (n > 0) {
                Serializer serializer = this.controller.getSerializer();
                final boolean bl3 = Serializer.getInt(serializer.getProperty("AlbumOptions", "MoveToAlbum"), 0) == 1;
                final String string2 = (String)serializer.getProperty("AlbumOptions", "AlbumRoot");
                new Thread(new Runnable(){

                    public synchronized void run() {
                        if (bl3) {
                            AlbumPane.this.moveAlbum(n, new File(string2 != null ? string2 : "."));
                        } else {
                            AlbumPane.this.copyAlbum(n, new File(string2 != null ? string2 : "."));
                        }
                        AlbumPane.this.statusbar.clearInfo();
                        AlbumPane.this.statusbar.clearProgress();
                    }
                }, "Album copier").start();
            }
        } else if (string.equals("Rename")) {
            this.startEditingAtPath(this.getSelectionPath());
        } else if (string.equals("This album")) {
            this.publishAlbum(this.access.getAlbumId(this.getSelectionPath()), false);
        } else if (string.equals("All albums")) {
            this.publishAlbum(this.access.getAlbumId(this.getSelectionPath()), true);
        } else if (string.equals("Properties...")) {
            new AlbumProperties(this, this.access.getAlbumId(this.getSelectionPath()), this.access);
        } else if (string.equals("Export to CSV...")) {
            JOptionPane.showMessageDialog(this, "For next release");
        } else if (string.equals("Refresh")) {
            this.invalidateTree();
        } else if ("Move album {0} under {1}".regionMatches(0, string, 0, "Move album {0} under {1}".indexOf(123) - 1)) {
            bl = true;
            bl2 = true;
        } else if ("Copy album {0} under {1}".regionMatches(0, string, 0, "Copy album {0} under {1}".indexOf(123) - 1)) {
            bl = true;
        }
        if (bl) {
            if (this.srcAlbumId > 0 && this.dstAlbumId >= 0) {
                if (this.access.insertAlbumToAlbum(new int[]{this.dstAlbumId}, this.srcAlbumId) < 0) {
                    JOptionPane.showMessageDialog(this.controller.getMainFrame(), "The album can't be moved/copied, because it includes target album(s)", "Error", 0);
                    return;
                }
                ((AlbumModel)this.getModel()).fireTreeStructureChanged(this, new Object[]{this.getModel().getRoot()}, null, null);
            }
            if (bl2) {
                this.access.deleteAlbumFrom(new int[]{this.parentAlbumId}, this.srcAlbumId);
                ((AlbumModel)this.getModel()).fireTreeStructureChanged(this, new Object[]{this.getModel().getRoot()}, null, null);
            }
        }
    }

    public AlbumSelectionDialog getSelectionDialog() {
        if (this.albumselection == null) {
            this.createSelectionDialog();
        }
        return this.albumselection;
    }

    final synchronized void createSelectionDialog() {
        if (this.albumselection == null) {
            this.albumselection = new AlbumSelectionDialog(this.controller);
        }
    }

    void copyAlbum(int n, File file) {
        File[] fileArray = this.access.getAlbumContents(n);
        File file2 = new File(file, this.access.getNameOfAlbum(n));
        file2.mkdir();
        this.statusbar.displayInfo("Copying->" + file2);
        this.statusbar.setProgress(fileArray.length);
        int n2 = 0;
        while (n2 < fileArray.length) {
            try {
                BaseController.copyFile(fileArray[n2], new File(file2, fileArray[n2].getName()));
                this.statusbar.tickProgress();
            }
            catch (IOException iOException) {
                System.err.println("Exception " + iOException + " in copying " + fileArray[n2]);
            }
            ++n2;
        }
        int[] nArray = this.access.getAlbumsId(n);
        int n3 = 0;
        while (n3 < nArray.length) {
            this.copyAlbum(nArray[n3], file2);
            ++n3;
        }
    }

    void moveAlbum(int n, File file) {
        Object object;
        File[] fileArray = this.access.getAlbumContents(n);
        File file2 = new File(file, this.access.getNameOfAlbum(n));
        file2.mkdir();
        this.statusbar.displayInfo("Moving->" + file2);
        this.statusbar.setProgress(fileArray.length);
        int n2 = 0;
        while (n2 < fileArray.length) {
            object = new File(fileArray[n2], "");
            if (fileArray[n2].renameTo(new File(file2, fileArray[n2].getName()))) {
                this.access.renamePictureTo(n, ((File)object).toString(), fileArray[n2].toString());
            } else {
                System.err.println("FIle " + fileArray[n2] + " hasn't been renamed");
            }
            ++n2;
        }
        object = this.access.getAlbumsId(n);
        int n3 = 0;
        while (n3 < ((int[])object).length) {
            this.moveAlbum(object[n3], file2);
            ++n3;
        }
    }

    public void publishAlbum(final int n, final boolean bl) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Courier courier = null;
                    Serializer serializer = AlbumPane.this.controller.getSerializer();
                    switch (Serializer.getInt(serializer.getProperty("WebPublishOptions", "PublishingMode"), 0)) {
                        case 1: {
                            courier = new FTPCourier(AlbumPane.this.controller);
                            break;
                        }
                        case 2: {
                            courier = new HTTPCourier(AlbumPane.this.controller);
                            break;
                        }
                        case 3: {
                            new SendEmailFrame(AlbumPane.this.controller, AlbumPane.this.access.getAlbumContents(n));
                            return;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            courier = new FileCourier(AlbumPane.this.controller);
                        }
                    }
                    new HtmlProducer(AlbumPane.this.controller).produce(courier, n, bl);
                }
                catch (IOException iOException) {
                    AlbumPane.this.statusbar.flashInfo("Exception in Web publishing, see log for details.");
                    System.err.println("Exception in Web publishing " + iOException);
                    iOException.printStackTrace();
                }
            }
        }, "Album publishing").start();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.controller.setWaitCursor(this, true);
        this.thumbnails.updateImages(this.access.getAlbumContents(this.access.getAlbumId(treeSelectionEvent.getPath())));
        this.controller.setWaitCursor(this, false);
    }

    public void addToAlbum(BasicJpeg[] basicJpegArray, TreePath[] treePathArray) {
        Serializer serializer = this.controller.getSerializer();
        boolean bl = Serializer.getInt(serializer.getProperty("AlbumOptions", "MoveToAlbum"), 0) == 1;
        boolean bl2 = Serializer.getInt(serializer.getProperty("AlbumOptions", "AlbumFolders"), 0) == 1;
        String string = (String)serializer.getProperty("AlbumOptions", "AlbumRoot");
        int n = 0;
        while (treePathArray != null && n < treePathArray.length) {
            if (bl2) {
                Object[] objectArray = treePathArray[n].getPath();
                String string2 = string == null ? "." + File.separatorChar : string;
                int n2 = 1;
                while (n2 < objectArray.length) {
                    string2 = string2 + File.separator + objectArray[n2];
                    ++n2;
                }
                new File(string2).mkdirs();
                String string3 = PhotoCollectionPanel.getRenameMask(this, serializer, " " + string2);
                FileNameFormat fileNameFormat = new FileNameFormat(string3, true);
                int n3 = 0;
                while (n3 < basicJpegArray.length) {
                    File file = new File(string2, FileNameFormat.makeValidPathName(fileNameFormat.format(basicJpegArray[n3])));
                    if (bl && n == 0 && !this.access.belongsToAlbum(basicJpegArray[n3])) {
                        if (!basicJpegArray[n3].renameTo(file)) {
                            System.err.println("Problem in moving file " + basicJpegArray[n3].getLocationName() + " to " + file + " album");
                        }
                    } else {
                        try {
                            BaseController.copyFile(new File(basicJpegArray[n3].getLocationName()), file);
                            basicJpegArray[n3] = new BasicJpeg(file);
                        }
                        catch (IOException iOException) {
                            System.err.println("Problem in copying file " + basicJpegArray[n3].getLocationName() + " to " + file + " album");
                        }
                    }
                    ++n3;
                }
            }
            this.access.insertPicturesToAlbum(this.access.getAlbumId(treePathArray[n]), basicJpegArray);
            ++n;
        }
    }

    void deletePicture(String string) {
        this.access.deletePicture(this.access.getAlbumId(this.getSelectionPath()), string);
    }

    void setCommentTo(String string, String string2) {
        this.access.setPictureComment(this.access.getAlbumId(this.getSelectionPath()), string, string2);
    }

    public String getCommentOf(String string) {
        return this.access.getPictureComment(this.access.getAlbumId(this.getSelectionPath()), string);
    }

    public void invalidateTree() {
        ((AlbumModel)this.getModel()).fireTreeStructureChanged(this, new Object[]{this.getModel().getRoot()}, null, null);
    }

    public Access getAccess() {
        return this.access;
    }

    class AlbumRightBtnMenu
    extends JPopupMenu {
        AlbumRightBtnMenu(ActionListener actionListener) {
            AlbumPane.this.controller.getUiUpdater().notify(AlbumPane.this.getSelectionPath() != null, UiUpdater.ALBUM_SELECTED);
            JMenuItem jMenuItem = new JMenuItem("To selection");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            this.addSeparator();
            jMenuItem = new JMenuItem("Copy/move");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            this.addSeparator();
            jMenuItem = new JMenuItem("Delete");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            jMenuItem = new JMenuItem("Delete all");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            jMenuItem = new JMenuItem("Rename");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            this.addSeparator();
            JMenu jMenu = new JMenu("Publish");
            jMenuItem = new JMenuItem("This album");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            jMenuItem = new JMenuItem("All albums");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            this.add(jMenu);
            this.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(UiUpdater.ALBUM_SELECTED));
            this.addSeparator();
            jMenuItem = new JMenuItem("Refresh");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
        }
    }
}

