/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.directory.JDirectoryChooser;
import photoorganizer.formats.FileNameFormat;
import rogatkin.GranulatedLayout;
import rogatkin.Persistentable;
import rogatkin.Serializer;

public class MiscellaneousOptionsTab
extends JPanel
implements ActionListener,
Persistentable {
    public static final String SECNAME = "PhotoCollectionOptions";
    public static final String DATEFORMAT = "DateFormat";
    public static final String TIMEFORMAT = "TimeFormat";
    public static final String TOOLBAR = "ToolBar";
    public static final String STATUSBAR = "StatusBar";
    public static final String MENUBAR = "MenuBar";
    public static final String TABPOS = "TabPosition";
    public static final String FC_FOLDER = "FlashCardDirectory";
    public static final String SHOWWARNDLG = "ShowWarnDlg";
    public static final String COUNTRY = "Country";
    public static final String LANGUAGE = "Language";
    public static final String SPLITVERT = "SplitVertically";
    static final Integer[] TABPOSTABLE = new Integer[]{new Integer(1), new Integer(3), new Integer(2), new Integer(4)};
    static final String formathelp = "<html>\n<pre>\n Symbol   Meaning                 Presentation        Example\n ------   -------                 ------------        -------\n G        era designator          (Text)              AD\n y        year                    (Number)            1996\n M        month in year           (Text &amp; Number)     July &amp; 07\n d        day in month            (Number)            10\n h        hour in am/pm (1~12)    (Number)            12\n H        hour in day (0~23)      (Number)            0\n m        minute in hour          (Number)            30\n s        second in minute        (Number)            55\n S        millisecond             (Number)            978\n E        day in week             (Text)              Tuesday\n D        day in year             (Number)            189\n F        day of week in month    (Number)            2 (2nd Wed in July)\n w        week in year            (Number)            27\n W        week in month           (Number)            2\n a        am/pm marker            (Text)              PM\n k        hour in day (1~24)      (Number)            24\n K        hour in am/pm (0~11)    (Number)            0\n z        time zone               (Text)              Pacific Standard Time  \n '        escape for text         (Delimiter)\n ''       single quote            (Literal)           '\n </pre>";
    Controller controller;
    JTextField tf_date;
    JTextField tf_time;
    JTextField tf_fc_folder;
    JCheckBox cb_menu;
    JCheckBox cb_status;
    JCheckBox cb_tool;
    JCheckBox cb_warn;
    JComboBox mb_positions;
    JComboBox cb_country;
    JComboBox cb_lang;
    JRadioButton rb_split_horz;
    JRadioButton rb_split_vert;
    JDialog help_dialog;

    public MiscellaneousOptionsTab(Controller controller) {
        this.controller = controller;
        this.setLayout(new GranulatedLayout(8, 6, 18, 2, 8, 8));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Show"));
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "0,0,8,4,16,8");
        this.cb_menu = new JCheckBox("Menu");
        this.add((Component)this.cb_menu, "1,1,1,1");
        this.cb_tool = new JCheckBox(TOOLBAR);
        this.add((Component)this.cb_tool, "3,1,1,1");
        this.add((Component)new JLabel("Locales", 4), "4,1");
        this.cb_country = new JComboBox<String>(Resources.COUNTRIES);
        this.add(this.cb_country, "5,1");
        this.cb_lang = new JComboBox<String>(Resources.LANGUAGES);
        this.add(this.cb_lang, "6,1");
        this.cb_status = new JCheckBox(STATUSBAR);
        this.add((Component)this.cb_status, "1,2,2,1");
        this.add((Component)new JLabel("Tab position", 4), "4,2,1,1");
        this.mb_positions = new JComboBox<String>(Resources.POSITIONS);
        this.add(this.mb_positions, "5,2,2,1");
        this.cb_warn = new JCheckBox("Show confirmation dialogs");
        this.add((Component)this.cb_warn, "0,4,3");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rb_split_vert = new JRadioButton("Split vertically");
        this.add((Component)this.rb_split_vert, "3,4,2");
        buttonGroup.add(this.rb_split_vert);
        this.rb_split_horz = new JRadioButton("Split horizontally");
        this.add((Component)this.rb_split_horz, "5,4,2");
        buttonGroup.add(this.rb_split_horz);
        this.add((Component)new JLabel("CF directory"), "0,6,2");
        this.tf_fc_folder = new JTextField();
        this.add((Component)this.tf_fc_folder, "2,6,4");
        JButton jButton = new JButton("Browse");
        this.add((Component)jButton, "6,6,2");
        jButton.addActionListener(this);
        this.add((Component)new JLabel("Date format"), "0,7,2");
        this.tf_date = new JTextField();
        this.add((Component)this.tf_date, "2,7,1,1");
        this.add((Component)new JLabel("Time format"), "3,7,2,1,20");
        this.tf_time = new JTextField();
        this.add((Component)this.tf_time, "5,7,1,1");
        jButton = new JButton("Help");
        this.add((Component)jButton, "6,7,2");
        jButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JDirectoryChooser jDirectoryChooser;
        if (actionEvent.getActionCommand() == "Help") {
            if (this.help_dialog == null) {
                this.help_dialog = new JDialog(new Frame(), "Help");
                this.help_dialog.getContentPane().setLayout(new BorderLayout());
                this.help_dialog.getContentPane().add((Component)new JLabel(formathelp), "Center");
                JPanel jPanel = new JPanel(new FlowLayout(2));
                this.help_dialog.getContentPane().add((Component)jPanel, "South");
                JButton jButton = new JButton("Close");
                jPanel.add(jButton);
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)MiscellaneousOptionsTab.this.help_dialog).setVisible(false);
                    }
                });
                this.help_dialog.pack();
            }
            this.help_dialog.show();
        } else if (actionEvent.getActionCommand() == "Browse" && (jDirectoryChooser = new JDirectoryChooser(new JFrame(), this.tf_fc_folder.getText(), null)).getDirectory() != null) {
            this.tf_fc_folder.setText(jDirectoryChooser.getDirectory());
        }
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        this.tf_date.setText(Serializer.arrayToString(serializer.getProperty(SECNAME, DATEFORMAT)));
        this.tf_time.setText(Serializer.arrayToString(serializer.getProperty(SECNAME, TIMEFORMAT)));
        this.tf_fc_folder.setText(Serializer.arrayToString(serializer.getProperty(SECNAME, FC_FOLDER)));
        this.cb_menu.setSelected(Serializer.getInt(serializer.getProperty(SECNAME, MENUBAR), 1) == 1);
        this.cb_status.setSelected(Serializer.getInt(serializer.getProperty(SECNAME, STATUSBAR), 1) == 1);
        this.cb_tool.setSelected(Serializer.getInt(serializer.getProperty(SECNAME, TOOLBAR), 0) == 1);
        this.cb_warn.setSelected(Serializer.getInt(serializer.getProperty(SECNAME, SHOWWARNDLG), 0) == 1);
        if (Serializer.getInt(serializer.getProperty(SECNAME, SPLITVERT), 1) == 1) {
            this.rb_split_vert.setSelected(true);
        } else {
            this.rb_split_horz.setSelected(true);
        }
        switch (Serializer.getInt(serializer.getProperty(SECNAME, TABPOS), 3)) {
            case 1: {
                this.mb_positions.setSelectedIndex(0);
                break;
            }
            case 3: {
                this.mb_positions.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.mb_positions.setSelectedIndex(2);
                break;
            }
            case 4: {
                this.mb_positions.setSelectedIndex(3);
            }
        }
        String string = (String)serializer.getProperty(SECNAME, COUNTRY);
        if (string == null) {
            string = Locale.getDefault().getCountry();
        }
        this.cb_country.setSelectedItem(string);
        string = (String)serializer.getProperty(SECNAME, LANGUAGE);
        if (string == null) {
            string = Locale.getDefault().getLanguage();
        }
        this.cb_lang.setSelectedItem(string);
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        FileNameFormat.datemask = this.tf_date.getText().trim();
        serializer.setProperty(SECNAME, DATEFORMAT, FileNameFormat.datemask);
        FileNameFormat.timemask = this.tf_time.getText().trim();
        serializer.setProperty(SECNAME, TIMEFORMAT, FileNameFormat.timemask);
        serializer.setProperty(SECNAME, FC_FOLDER, this.tf_fc_folder.getText());
        serializer.setProperty(SECNAME, MENUBAR, this.cb_menu.isSelected() ? Resources.I_YES : Resources.I_NO);
        serializer.setProperty(SECNAME, STATUSBAR, this.cb_status.isSelected() ? Resources.I_YES : Resources.I_NO);
        serializer.setProperty(SECNAME, TOOLBAR, this.cb_tool.isSelected() ? Resources.I_YES : Resources.I_NO);
        serializer.setProperty(SECNAME, SHOWWARNDLG, this.cb_warn.isSelected() ? Resources.I_YES : Resources.I_NO);
        serializer.setProperty(SECNAME, SPLITVERT, this.rb_split_vert.isSelected() ? Resources.I_YES : Resources.I_NO);
        serializer.setProperty(SECNAME, TABPOS, TABPOSTABLE[this.mb_positions.getSelectedIndex()]);
        serializer.setProperty(SECNAME, COUNTRY, this.cb_country.getSelectedItem());
        serializer.setProperty(SECNAME, LANGUAGE, this.cb_lang.getSelectedItem());
    }
}

