/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.Courier;
import photoorganizer.HtmlProducer;
import photoorganizer.Resources;
import photoorganizer.UiUpdater;
import photoorganizer.courier.FTPCourier;
import photoorganizer.courier.FileCourier;
import photoorganizer.courier.HTTPCourier;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.formats.Thumbnail;
import photoorganizer.renderer.AlbumPane;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.CollectionThumbnailsPanel;
import photoorganizer.renderer.PhotoImagePanel;
import photoorganizer.renderer.PropertiesPanel;
import photoorganizer.renderer.SendEmailFrame;
import photoorganizer.renderer.StatusBar;
import rogatkin.Persistentable;
import rogatkin.Serializer;

public class PhotoCollectionPanel
extends JTable
implements ActionListener,
Persistentable {
    static final String SECNAME = "PhotoCollectionPanel";
    static final String COLWIDTH = "ColumnWidthes";
    static final int TOO_MANY_WINDOWS = 20;
    private Controller controller;
    private Point lastmouse;
    private CollectionThumbnailsPanel thumbnailspanel;
    private AlbumPane albumpane;
    private StatusBar statusbar;
    private Class fclass;
    private boolean keeporigmarkers;
    private boolean transformmove;
    private boolean transformaddsel;
    public static final String DEFTNMASK = "tumbnail%00c.jpg";
    public static String LastHtmlName = "??";
    static /* synthetic */ Class class$photoorganizer$formats$Exif;
    static /* synthetic */ Class class$photoorganizer$formats$CIFF;
    static /* synthetic */ Class class$photoorganizer$formats$JFXX;
    static /* synthetic */ Class class$photoorganizer$formats$AbstractImageInfo;

    public PhotoCollectionPanel(Controller controller) {
        this.setSelectionMode(2);
        this.controller = controller;
        this.statusbar = (StatusBar)controller.component(Controller.COMP_STATUSBAR);
        this.thumbnailspanel = (CollectionThumbnailsPanel)controller.component(Controller.COMP_THUMBCOLLCTPANEL);
        this.thumbnailspanel.setCollection(this);
        this.albumpane = (AlbumPane)controller.component(Controller.COMP_ALBUMPANEL);
        this.albumpane.setCollectionPanel(this);
        this.addMouseListener(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                PhotoCollectionPanel.this.lastmouse = new Point(mouseEvent.getX(), mouseEvent.getY());
                if ((n & 4) > 0) {
                    PhotoCollectionPanel.this.getRMouseMenu().show(PhotoCollectionPanel.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.setModel(new CollectionModel());
        this.setMinimumSize(Resources.MIN_PANEL_DIMENSION);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                int n2 = listSelectionEvent.getFirstIndex();
                if (n2 > (n = listSelectionEvent.getLastIndex())) {
                    n = listSelectionEvent.getFirstIndex();
                    n2 = listSelectionEvent.getLastIndex();
                }
                CollectionModel collectionModel = (CollectionModel)PhotoCollectionPanel.this.getModel();
                boolean bl = false;
                int n3 = n2;
                while (n3 <= n) {
                    Thumbnail thumbnail = (Thumbnail)collectionModel.getElementAt(n3);
                    if (thumbnail != null) {
                        boolean bl2 = PhotoCollectionPanel.this.isRowSelected(n3);
                        thumbnail.select(bl2);
                        bl |= bl2;
                    }
                    ++n3;
                }
                if (!bl) {
                    bl = PhotoCollectionPanel.this.getSelectedRowCount() > 0;
                }
                PhotoCollectionPanel.this.controller.getUiUpdater().notify(bl, UiUpdater.SELECTION_SELECTED);
            }
        });
        this.addKeyListener(new KeyAdapter(){});
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int[] nArray = this.getSelectedRows();
        nArray = (int[])nArray.clone();
        if (string.equals("Invert selection")) {
            int n2 = this.rowAtPoint(this.lastmouse);
            if (n2 >= 0) {
                if (this.isRowSelected(n2)) {
                    this.removeRowSelectionInterval(n2, n2);
                } else {
                    this.addRowSelectionInterval(n2, n2);
                }
                this.controller.getUiUpdater().notify(this.getSelectedRowCount() > 0, UiUpdater.SELECTION_SELECTED);
            }
        } else if (string.equals("Select all")) {
            this.selectAll();
        } else if (string.equals("Get CF") || actionEvent.getSource() instanceof JButton && ((JButton)actionEvent.getSource()).getToolTipText().equals("Get CF")) {
            String string2 = (String)this.controller.getSerializer().getProperty("PhotoCollectionOptions", "FlashCardDirectory");
            if (string2 != null && string2.length() > 0) {
                this.add(new File(string2));
            }
        } else if (string.equals("Extract markers")) {
            this.extractMarkers(nArray);
        } else if (string.equals("To album")) {
            AlbumSelectionDialog albumSelectionDialog = this.albumpane.getSelectionDialog();
            albumSelectionDialog.setTitle("Albums selection for - :" + nArray.length);
            ((Component)albumSelectionDialog).setVisible(true);
            TreePath[] treePathArray = albumSelectionDialog.getSelectedAlbums();
            if (treePathArray != null) {
                Serializer serializer = this.controller.getSerializer();
                boolean bl = Serializer.getInt(serializer.getProperty("AlbumOptions", "MoveToAlbum"), 0) == 1 && Serializer.getInt(serializer.getProperty("AlbumOptions", "AlbumFolders"), 0) == 1;
                BasicJpeg[] basicJpegArray = new BasicJpeg[nArray.length];
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                while (n5 < nArray.length) {
                    basicJpegArray[n5] = ((Thumbnail)collectionModel.getElementAt(nArray[n5])).getImageInfo();
                    if (bl) {
                        ((Thumbnail)collectionModel.getElementAt(nArray[n5])).select(false);
                        collectionModel.markDelete(nArray[n5]);
                        if (nArray[n5] > n4) {
                            n4 = nArray[n5];
                        }
                        if (nArray[n5] < n3) {
                            n3 = nArray[n5];
                        }
                    }
                    ++n5;
                }
                this.albumpane.addToAlbum(basicJpegArray, treePathArray);
                if (bl) {
                    collectionModel.removeAllMarked();
                    collectionModel.fireTableRowsDeleted(n3, n4);
                    this.controller.getUiUpdater().notify(false, UiUpdater.SELECTION_SELECTED);
                } else {
                    collectionModel.fireTableRowsUpdated(n3, n4);
                }
            }
        } else if (string.equals("Rename")) {
            this.rename(nArray);
        } else if (string.equals("Delete")) {
            this.delete(nArray);
        } else if (string.equals("Show")) {
            BasicJpeg basicJpeg;
            int n6 = this.rowAtPoint(this.lastmouse);
            if (n6 >= 0 && (basicJpeg = ((Thumbnail)collectionModel.getElementAt(n6)).getImageInfo()) != null) {
                ((PhotoImagePanel)this.controller.component(Controller.COMP_IMAGECOLLCTPANEL)).updateView(basicJpeg);
            }
        } else if (string.equals("Properties...")) {
            int n7 = 0;
            while (n7 < nArray.length && n7 < 20) {
                PropertiesPanel.showProperties(((Thumbnail)collectionModel.getElementAt(nArray[n7])).getImageInfo(), this.controller);
                ++n7;
            }
        } else if (string.equals("Extract thumbs")) {
            String string3;
            Serializer serializer = this.controller.getSerializer();
            String string4 = (String)serializer.getProperty("RenameOptions", "DestinationFolder");
            if (string4 == null || string4.length() == 0) {
                string4 = this.controller.getSerializer().getHomeDirectory();
            }
            if ((string3 = (String)serializer.getProperty("ThumbnailsOptions", "FileMask")) == null || string3.length() == 0) {
                string3 = DEFTNMASK;
            }
            FileNameFormat fileNameFormat = new FileNameFormat(string3, true);
            int n8 = 0;
            while (n8 < nArray.length) {
                BasicJpeg basicJpeg = ((Thumbnail)collectionModel.getElementAt(nArray[n8])).getImageInfo();
                AbstractImageInfo abstractImageInfo = basicJpeg.getImageInfo();
                try {
                    if (abstractImageInfo != null) {
                        abstractImageInfo.saveThumbnailImage(basicJpeg, new FileOutputStream(new File(string4, FileNameFormat.makeValidPathName(fileNameFormat.format(basicJpeg), abstractImageInfo.getThumbnailExtension()))));
                    }
                }
                catch (IOException iOException) {
                    System.err.println("" + iOException);
                }
                ++n8;
            }
        } else if (string.equals("Web publishing")) {
            if (nArray.length == 0) {
                return;
            }
            final Serializer serializer = this.controller.getSerializer();
            final boolean bl = Serializer.getInt(serializer.getProperty("WebPublishOptions", "CopyWebContent"), 1) == 0;
            String string5 = "";
            if (!bl && (string5 = (String)JOptionPane.showInputDialog(this, "Name of HTML file", "Web publishing", 3, null, null, "")) != null) {
                LastHtmlName = string5;
            }
            if (string5 != null) {
                if (string5.indexOf(46) < 0) {
                    string5 = string5 + ".html";
                }
                final String string6 = string5;
                final File[] fileArray = this.selectionsToFiles(nArray);
                new Thread(new Runnable(){

                    public void run() {
                        block14: {
                            try {
                                Courier courier = null;
                                switch (Serializer.getInt(serializer.getProperty("WebPublishOptions", "PublishingMode"), 0)) {
                                    case 1: {
                                        courier = new FTPCourier(PhotoCollectionPanel.this.controller);
                                        break;
                                    }
                                    case 2: {
                                        courier = new HTTPCourier(PhotoCollectionPanel.this.controller);
                                        break;
                                    }
                                    case 3: {
                                        new SendEmailFrame(PhotoCollectionPanel.this.controller, fileArray);
                                        return;
                                    }
                                    case 4: {
                                        break;
                                    }
                                    default: {
                                        courier = new FileCourier(PhotoCollectionPanel.this.controller);
                                    }
                                }
                                if (bl) {
                                    try {
                                        PhotoCollectionPanel.this.statusbar.displayInfo("Connecting");
                                        courier.init();
                                        String string = (String)serializer.getProperty("WebPublishOptions", "ImagePath");
                                        if (string == null) {
                                            string = "";
                                        } else {
                                            courier.checkForDestPath(string);
                                        }
                                        PhotoCollectionPanel.this.statusbar.clearProgress();
                                        PhotoCollectionPanel.this.statusbar.displayInfo("Copying");
                                        PhotoCollectionPanel.this.statusbar.setProgress(fileArray.length);
                                        int n = 0;
                                        while (n < fileArray.length) {
                                            courier.deliver(fileArray[n].toString(), string);
                                            PhotoCollectionPanel.this.statusbar.tickProgress();
                                            ++n;
                                        }
                                        Object var5_5 = null;
                                        PhotoCollectionPanel.this.statusbar.clearInfo();
                                        PhotoCollectionPanel.this.statusbar.clearProgress();
                                        courier.done();
                                        break block14;
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_6 = null;
                                        PhotoCollectionPanel.this.statusbar.clearInfo();
                                        PhotoCollectionPanel.this.statusbar.clearProgress();
                                        courier.done();
                                        throw throwable;
                                    }
                                }
                                new HtmlProducer(PhotoCollectionPanel.this.controller).produce(string6, fileArray, courier);
                            }
                            catch (IOException iOException) {
                                PhotoCollectionPanel.this.statusbar.flashInfo("Exception in Web publishing, see log for details.");
                                System.err.println("Exception in Web publishing " + iOException);
                                iOException.printStackTrace();
                            }
                        }
                    }
                }, "WebPublishing").start();
            }
        } else if (string.equals("Print")) {
            this.controller.print(this.selectionsToFiles(nArray));
        } else if (string.equals("Send by e-mail")) {
            new SendEmailFrame(this.controller, this.selectionsToFiles(nArray));
        }
        if ((n = Controller.convertCmdToTrnasformOp(string)) != -1) {
            this.transform(nArray, n);
        }
    }

    public int add(File file) {
        int n;
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int n2 = n = collectionModel.getRowCount();
        if (file.isFile()) {
            this.thumbnailspanel.addImage(file);
            ++n2;
        } else if (file.isDirectory()) {
            String[] stringArray = file.list();
            String string = file.getPath();
            int n3 = 0;
            while (n3 < stringArray.length) {
                file = new File(string, stringArray[n3]);
                if (file.isFile()) {
                    this.thumbnailspanel.addImage(file);
                    ++n2;
                }
                ++n3;
            }
        }
        collectionModel.fireTableRowsInserted(n, n2);
        return n2;
    }

    public int add(File[] fileArray) {
        int n;
        this.controller.setWaitCursor(this, true);
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int n2 = n = collectionModel.getRowCount();
        int n3 = 0;
        while (n3 < fileArray.length) {
            if (fileArray[n3].isFile()) {
                this.thumbnailspanel.addImage(fileArray[n3]);
                ++n2;
            } else if (fileArray[n3].isDirectory()) {
                String[] stringArray = fileArray[n3].list();
                String string = fileArray[n3].getPath();
                int n4 = 0;
                while (n4 < stringArray.length) {
                    fileArray[n3] = new File(string, stringArray[n4]);
                    if (fileArray[n3].isFile()) {
                        this.thumbnailspanel.addImage(fileArray[n3]);
                        ++n2;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        collectionModel.fireTableRowsInserted(n, n2);
        this.controller.setWaitCursor(this, false);
        return n2;
    }

    String transformName(File file, int n) {
        String string;
        Serializer serializer = this.controller.getSerializer();
        String string2 = (String)serializer.getProperty("RenameOptions", "DestinationFolder");
        if (string2 == null || string2.length() == 0) {
            string2 = this.controller.getSerializer().getHomeDirectory();
        }
        if ((string = (String)serializer.getProperty("TransformOptions", "Mask")) != null) {
            return string2 + File.separatorChar + FileNameFormat.makeValidPathName(new FileNameFormat(string, n, true).format(new BasicJpeg(file)));
        }
        return string2 + File.separatorChar + file.getName();
    }

    int findIndexOf(Thumbnail thumbnail) {
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int n = 0;
        while (n < collectionModel.getRowCount()) {
            if (collectionModel.getElementAt(n) == thumbnail) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    File[] selectionsToFiles(int[] nArray) {
        File[] fileArray = new File[nArray.length];
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int n = 0;
        while (n < nArray.length) {
            Thumbnail thumbnail = (Thumbnail)collectionModel.getElementAt(nArray[n]);
            if (thumbnail != null) {
                fileArray[n] = new File(thumbnail.getImageInfo().getLocationName());
            }
            ++n;
        }
        return fileArray;
    }

    void extractMarkers(int[] nArray) {
        Serializer serializer = this.controller.getSerializer();
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        int n = 0;
        while (n < nArray.length) {
            BasicJpeg basicJpeg = ((Thumbnail)collectionModel.getElementAt(nArray[n])).getImageInfo();
            AbstractImageInfo abstractImageInfo = basicJpeg.getImageInfo();
            if (abstractImageInfo != null) {
                String string = abstractImageInfo.getName();
                int n2 = string.lastIndexOf(46);
                string = n2 > 0 ? string.substring(0, n2 + 1) : string + '.';
                string = string + abstractImageInfo.getFormat();
                try {
                    basicJpeg.saveMarkers(new FileOutputStream(new File(basicJpeg.getParentPath(), string)));
                }
                catch (IOException iOException) {
                    System.err.println("Exception in markers extraction " + iOException);
                }
            }
            ++n;
        }
    }

    void rename(final int[] nArray) {
        String string;
        Serializer serializer = this.controller.getSerializer();
        String string2 = (String)serializer.getProperty("RenameOptions", "DestinationFolder");
        if (string2 == null || string2.length() == 0) {
            string2 = this.controller.getSerializer().getHomeDirectory();
        }
        if ((string = PhotoCollectionPanel.getRenameMask(this, serializer, " " + string2)) == null) {
            return;
        }
        final String string3 = string2;
        this.statusbar.displayInfo("Renaming");
        this.statusbar.setProgress(nArray.length);
        final boolean bl = Serializer.getInt(serializer.getProperty("RenameOptions", "RemoveAfterRename"), 0) == 1;
        new Thread(new Runnable(){

            public void run() {
                int n = 0;
                int n2 = 0;
                CollectionModel collectionModel = (CollectionModel)PhotoCollectionPanel.this.getModel();
                FileNameFormat fileNameFormat = new FileNameFormat(string, true);
                int n3 = 0;
                while (n3 < nArray.length) {
                    File file;
                    BasicJpeg basicJpeg = ((Thumbnail)collectionModel.getElementAt(nArray[n3])).getImageInfo();
                    if (basicJpeg.renameTo(file = new File(string3, FileNameFormat.makeValidPathName(fileNameFormat.format(basicJpeg))))) {
                        if (nArray[n3] > n2) {
                            n2 = nArray[n3];
                        }
                        if (nArray[n3] < n) {
                            n = nArray[n3];
                        }
                    }
                    if (bl) {
                        ((Thumbnail)collectionModel.getElementAt(nArray[n3])).select(false);
                        collectionModel.markDelete(nArray[n3]);
                    }
                    PhotoCollectionPanel.this.statusbar.tickProgress();
                    ++n3;
                }
                if (bl) {
                    collectionModel.removeAllMarked();
                    collectionModel.fireTableRowsDeleted(n, n2);
                    PhotoCollectionPanel.this.controller.getUiUpdater().notify(false, UiUpdater.SELECTION_SELECTED);
                } else {
                    collectionModel.fireTableRowsUpdated(n, n2);
                }
                PhotoCollectionPanel.this.statusbar.clearInfo();
                PhotoCollectionPanel.this.statusbar.clearProgress();
            }
        }, "Renaming").start();
    }

    static String getRenameMask(Component component, Serializer serializer, String string) {
        Object object = Serializer.getInt(serializer.getProperty("RenameOptions", "AskEdit"), 0) == 1 ? JOptionPane.showInputDialog(component, "New name", "Rename" + string, 3, null, null, serializer.getProperty("RenameOptions", "Mask")) : serializer.getProperty("RenameOptions", "Mask");
        return (String)object;
    }

    void delete(int[] nArray) {
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        this.statusbar.displayInfo("Removing");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            ((Thumbnail)collectionModel.getElementAt(nArray[n3])).select(false);
            collectionModel.markDelete(nArray[n3]);
            if (nArray[n3] > n2) {
                n2 = nArray[n3];
            }
            if (nArray[n3] < n) {
                n = nArray[n3];
            }
            ++n3;
        }
        collectionModel.removeAllMarked();
        collectionModel.fireTableRowsDeleted(n, n2);
        this.tableChanged(new TableModelEvent(collectionModel, n, n2, -1, -1));
        this.controller.getUiUpdater().notify(false, UiUpdater.SELECTION_SELECTED);
        this.statusbar.clearInfo();
    }

    void transform(final int[] nArray, final int n) {
        this.statusbar.displayInfo("Transforming");
        this.statusbar.setProgress(nArray.length);
        this.loadTransformOptions();
        new Thread(new Runnable(){

            public void run() {
                CollectionModel collectionModel = (CollectionModel)PhotoCollectionPanel.this.getModel();
                int n5 = 0;
                int n2 = 0;
                int n3 = collectionModel.getRowCount();
                int n4 = 0;
                while (n4 < nArray.length) {
                    block12: {
                        String string;
                        File file;
                        block11: {
                            file = new File(((Thumbnail)collectionModel.getElementAt(nArray[n4])).getImageInfo().getLocationName());
                            string = PhotoCollectionPanel.this.transformName(file, n);
                            if (n != 8) break block11;
                            BasicJpeg basicJpeg = ((Thumbnail)collectionModel.getElementAt(nArray[n4])).getImageInfo();
                            String string2 = basicJpeg.getComment();
                            if ((string2 = (String)JOptionPane.showInputDialog(PhotoCollectionPanel.this, "Type a commentary", "Commentary", 3, null, null, string2)) == null) break block12;
                            basicJpeg.setComment(string2);
                        }
                        if (((Thumbnail)collectionModel.getElementAt(nArray[n4])).getImageInfo().transform(string, n, PhotoCollectionPanel.this.keeporigmarkers, PhotoCollectionPanel.this.fclass)) {
                            if (PhotoCollectionPanel.this.transformmove && file.delete()) {
                                collectionModel.removeElementAt(nArray[n4]);
                                if (nArray[n4] > n2) {
                                    n2 = nArray[n4];
                                }
                                if (nArray[n4] < n5) {
                                    n5 = nArray[n4];
                                }
                            }
                            if (PhotoCollectionPanel.this.transformaddsel) {
                                PhotoCollectionPanel.this.add(new File(string));
                            }
                            PhotoCollectionPanel.this.statusbar.tickProgress();
                        }
                    }
                    ++n4;
                }
                if (PhotoCollectionPanel.this.transformaddsel) {
                    collectionModel.fireTableRowsInserted(n3 - 1, n3 + nArray.length - 1);
                    PhotoCollectionPanel.this.tableChanged(new TableModelEvent(collectionModel, n3 - 1, n3 + nArray.length - 1, -1, 1));
                }
                if (PhotoCollectionPanel.this.transformmove) {
                    collectionModel.fireTableRowsDeleted(n5, n2);
                    PhotoCollectionPanel.this.tableChanged(new TableModelEvent(collectionModel, n5, n2, -1, -1));
                    PhotoCollectionPanel.this.controller.getUiUpdater().notify(false, UiUpdater.SELECTION_SELECTED);
                }
                PhotoCollectionPanel.this.statusbar.clearInfo();
                PhotoCollectionPanel.this.statusbar.clearProgress();
            }
        }, "Transforming").start();
    }

    void loadTransformOptions() {
        Serializer serializer = this.controller.getSerializer();
        this.keeporigmarkers = Serializer.getInt(serializer.getProperty("TransformOptions", "Keep"), 0) == 1;
        this.transformmove = Serializer.getInt(serializer.getProperty("TransformOptions", "Move"), 0) == 0;
        this.transformaddsel = Serializer.getInt(serializer.getProperty("TransformOptions", "TransformedToSelection"), 1) == 1;
        String string = (String)serializer.getProperty("TransformOptions", "Format");
        this.fclass = null;
        if (string != null && !this.keeporigmarkers) {
            if ("Exif".equals(string)) {
                this.fclass = class$photoorganizer$formats$Exif == null ? (class$photoorganizer$formats$Exif = PhotoCollectionPanel.class$("photoorganizer.formats.Exif")) : class$photoorganizer$formats$Exif;
            } else if ("CIFF".equals(string)) {
                this.fclass = class$photoorganizer$formats$CIFF == null ? (class$photoorganizer$formats$CIFF = PhotoCollectionPanel.class$("photoorganizer.formats.CIFF")) : class$photoorganizer$formats$CIFF;
            } else if ("JFXX".equals(string)) {
                this.fclass = class$photoorganizer$formats$JFXX == null ? (class$photoorganizer$formats$JFXX = PhotoCollectionPanel.class$("photoorganizer.formats.JFXX")) : class$photoorganizer$formats$JFXX;
            } else if ("From ext file".equals(string)) {
                this.fclass = class$photoorganizer$formats$AbstractImageInfo == null ? (class$photoorganizer$formats$AbstractImageInfo = PhotoCollectionPanel.class$("photoorganizer.formats.AbstractImageInfo")) : class$photoorganizer$formats$AbstractImageInfo;
            }
        }
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        Integer[] integerArray = new Integer[this.getColumnCount()];
        int n = 0;
        while (n < integerArray.length) {
            integerArray[n] = new Integer(this.getColumn(this.getColumnName(n)).getWidth());
            ++n;
        }
        serializer.setProperty(SECNAME, COLWIDTH, integerArray);
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        Object[] objectArray = (Object[])serializer.getProperty(SECNAME, COLWIDTH);
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            this.getColumn(this.getColumnName(n)).setWidth((Integer)objectArray[n]);
            this.getColumn(this.getColumnName(n)).setPreferredWidth((Integer)objectArray[n]);
            ++n;
        }
    }

    JPopupMenu getRMouseMenu() {
        return new RButtonMenu();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CollectionModel
    extends AbstractTableModel
    implements ListModel {
        Vector collection;
        String[] colnames = new String[]{"Name", "Taken", "Shutter", "Aperture", "Flash"};
        Vector marked = new Vector(10);

        CollectionModel() {
        }

        public int getRowCount() {
            return PhotoCollectionPanel.this.thumbnailspanel.getComponentCount();
        }

        public int getColumnCount() {
            return this.colnames.length;
        }

        public String getColumnName(int n) {
            return this.colnames[n];
        }

        public Object getValueAt(int n, int n2) {
            BasicJpeg basicJpeg = ((Thumbnail)((Object)PhotoCollectionPanel.this.thumbnailspanel.getComponent(n))).getImageInfo();
            if (basicJpeg == null) {
                return null;
            }
            AbstractImageInfo abstractImageInfo = basicJpeg.getImageInfo();
            try {
                switch (n2) {
                    case 0: {
                        if (abstractImageInfo == null) {
                            return basicJpeg.getLocationName();
                        }
                        return abstractImageInfo.getName();
                    }
                    case 1: {
                        Date date;
                        if (abstractImageInfo == null || (date = abstractImageInfo.getDateTimeOriginal()) == null) break;
                        return date;
                    }
                    case 2: {
                        if (abstractImageInfo == null) break;
                        return abstractImageInfo.getShutter();
                    }
                    case 3: {
                        if (abstractImageInfo == null) break;
                        return new Float(abstractImageInfo.getFNumber());
                    }
                    case 4: {
                        if (abstractImageInfo == null) break;
                        return abstractImageInfo.isFlash() ? Boolean.TRUE : Boolean.FALSE;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return null;
        }

        public Object getElementAt(int n) {
            try {
                return PhotoCollectionPanel.this.thumbnailspanel.getComponent(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        void removeElementAt(int n) {
            PhotoCollectionPanel.this.thumbnailspanel.remove(n);
        }

        void markDelete(int n) {
            this.marked.addElement(PhotoCollectionPanel.this.thumbnailspanel.getComponent(n));
        }

        void removeAllMarked() {
            int n = 0;
            while (n < this.marked.size()) {
                PhotoCollectionPanel.this.thumbnailspanel.remove((Component)this.marked.elementAt(n));
                ++n;
            }
            this.marked.removeAllElements();
            PhotoCollectionPanel.this.thumbnailspanel.adjustDimension();
        }

        public void fireTableRowsUpdated(int n, int n2) {
            super.fireTableRowsUpdated(n, n2);
            int n3 = n;
            while (n3 <= n2) {
                ((Thumbnail)((Object)PhotoCollectionPanel.this.thumbnailspanel.getComponent(n3))).update();
                ++n3;
            }
        }

        public int getSize() {
            return this.getRowCount();
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    class RButtonMenu
    extends JPopupMenu {
        RButtonMenu() {
            JMenuItem jMenuItem = new JMenuItem("Invert selection");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem = new JMenuItem("Select all");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem = new JMenuItem("Show");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
            jMenuItem = new JMenuItem("To album");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
            jMenuItem = new JMenuItem("Extract markers");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
            this.addSeparator();
            jMenuItem = new JMenuItem("Rename");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
            jMenuItem = new JMenuItem("Delete");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
            this.addSeparator();
            jMenuItem = new JMenuItem("Print");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
            this.addSeparator();
            JMenu jMenu = Controller.createTransformMenu(PhotoCollectionPanel.this);
            this.add(jMenu);
            jMenu.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
            this.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoCollectionPanel.this);
            jMenuItem.setEnabled(PhotoCollectionPanel.this.controller.getUiUpdater().isEnabled(UiUpdater.SELECTION_SELECTED));
        }
    }
}

