/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.directory.JDirectoryChooser;
import photoorganizer.ftp.Ftp;
import photoorganizer.ftp.FtpConnectionInfo;
import photoorganizer.ftp.FtpFileSystemView;
import rogatkin.BaseController;
import rogatkin.GranulatedLayout;
import rogatkin.Persistentable;
import rogatkin.Serializer;

public class WebPublishOptionsTab
extends JPanel
implements ActionListener,
Persistentable {
    public static final String SECNAME = "WebPublishOptions";
    public static final String HOSTNAME = "HostName";
    public static final String FTPLOGIN = "FtpLogin";
    public static final String FTPPASSWORD = "FtpPassword";
    public static final String TIMEOUT = "FtpTimeout";
    public static final String PROXYHOST = "ProxyHost";
    public static final String PROXYPORT = "ProxyPort";
    public static final String USEPROXY = "UseProxy";
    public static final String ASKPSWD = "SavePassword";
    public static final String PASSIVEMODE = "PassiveMode";
    public static final String PUBMODE = "PublishingMode";
    public static final String HTMLTEMPL = "HTMLTemplate";
    public static final String WEBROOT = "WebRoot";
    public static final String IMAGEPATH = "ImagePath";
    public static final String TNWEBPATH = "ThumbnailPath";
    public static final String IMAGEURL = "ImageURL";
    public static final String USEURLPATH = "UseURL";
    public static final String CPYPICS = "CopyPictures";
    public static final String CPYPICSONLY = "CopyWebContent";
    public static final String SMTPSERVER = "SMTPServer";
    public static final String SMTPUSER = "SMTPUser";
    public static final String ORGANIZATION = "Organization";
    public static final String REPLYADDR = "Reply";
    public static final String EMAILADDR = "E-MailAddress";
    public static final String SMTPPORT = "SMTPPort";
    public static final String USESSL = "UseSSL";
    public static final String SRVTIMEOUT = "SMTPTimeout";
    public static final String UPL_SERVLET_URL = "UploadServletURL";
    public static final String UPL_DEST_NAME = "UploadDestName";
    public static final String UPL_DATA_NAME = "UploadDataName";
    public static final String HTTPLOGIN = "HttpLogin";
    public static final String HTTPPASSWORD = "HttpPassword";
    public static final String HTTPLOGIN_NAME = "HttpLoginName";
    public static final String HTTPPASSWORD_NAME = "HttpPasswordName";
    public static final String HTTP_AUTH_SHC = "HttpAuthentication";
    public static final String HTTPKEEPPSWD = "HttpKeepPswd";
    public static final String HTTPLOGINURL = "HttpLoginURL";
    public static final String HTTPLOGINMETHOD = "HttpLoginMethod";
    public static final String HTTPSTATICQUERY = "HttpStaticQuery";
    public static final int LOCAL = 0;
    public static final int FTP = 1;
    public static final int HTTP = 2;
    public static final int EMAIL = 3;
    public static final int XML_SVG = 4;
    static final int DEFTIMEOUT = 20;
    Controller controller;
    JTextField tf_webroot;
    JTextField tf_htmltmpl;
    JTextField tf_webpath;
    JTextField tf_tnwebpath;
    JTextField tf_pic_url;
    JCheckBox cb_webpic;
    JCheckBox cb_notCpyImgs;
    JCheckBox cb_notCpyThmbHtml;
    JButton bt_brws_htmltmpl;
    JButton bt_brws_wroot;
    RadioButtonsGroup publishModeSel;
    static FtpConnectionInfo connectioninfo = new FtpConnectionInfo();
    FtpDialog ftpdialog;

    public WebPublishOptionsTab(Controller controller) {
        this.controller = controller;
        this.setLayout(new GranulatedLayout(7, 8, 20, 4, 8, 8));
        this.add((Component)new JLabel("HTML template"), "0,0,2");
        this.tf_htmltmpl = new JTextField();
        this.add((Component)this.tf_htmltmpl, "2,0,4");
        this.bt_brws_htmltmpl = new JButton("Browse");
        this.add((Component)this.bt_brws_htmltmpl, "6,0,1");
        this.bt_brws_htmltmpl.addActionListener(this);
        this.add((Component)new JLabel("Web root"), "0,1,2");
        this.tf_webroot = new JTextField();
        this.add((Component)this.tf_webroot, "2,1,4");
        this.bt_brws_wroot = new JButton("Browse");
        this.add((Component)this.bt_brws_wroot, "6,1,1");
        this.bt_brws_wroot.addActionListener(this);
        this.add((Component)new JLabel("Use:"), "0,2");
        this.publishModeSel = new RadioButtonsGroup();
        JRadioButton jRadioButton = new JRadioButton("LOCAL");
        this.add((Component)jRadioButton, "5,2");
        this.publishModeSel.add(jRadioButton, 0);
        jRadioButton = new JRadioButton("Ftp");
        this.add((Component)jRadioButton, "1,2");
        this.publishModeSel.add(jRadioButton, 1);
        jRadioButton = new JRadioButton("HTTP");
        this.add((Component)jRadioButton, "2,2");
        this.publishModeSel.add(jRadioButton, 2);
        jRadioButton = new JRadioButton("SMTP");
        this.add((Component)jRadioButton, "3,2");
        this.publishModeSel.add(jRadioButton, 3);
        jRadioButton = new JRadioButton("XML");
        this.add((Component)jRadioButton, "4,2");
        this.publishModeSel.add(jRadioButton, 4);
        JButton jButton = new JButton("Setup >>");
        this.add((Component)jButton, "6,2,1");
        jButton.addActionListener(this);
        this.add((Component)new JLabel("Thumbnails location"), "0,3,2");
        this.tf_tnwebpath = new JTextField();
        this.add((Component)this.tf_tnwebpath, "2,3,4");
        this.add((Component)new JLabel("Pictures location"), "0,4,2");
        this.tf_webpath = new JTextField();
        this.add((Component)this.tf_webpath, "2,4,4");
        this.cb_notCpyImgs = new JCheckBox("Don't copy images");
        this.add((Component)this.cb_notCpyImgs, "1,5,2");
        this.cb_notCpyThmbHtml = new JCheckBox("Don't copy thumbs&HTML");
        this.add((Component)this.cb_notCpyThmbHtml, "3,5,2");
        this.cb_webpic = new JCheckBox("Use picture URL");
        this.add((Component)this.cb_webpic, "5,5,2");
        this.add((Component)new JLabel("Pictures URL"), "0,6,2");
        this.tf_pic_url = new JTextField();
        this.add((Component)this.tf_pic_url, "2,6,4");
        this.cb_webpic.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                WebPublishOptionsTab.this.tf_pic_url.setEnabled(((AbstractButton)changeEvent.getSource()).isSelected());
            }
        });
        this.cb_notCpyImgs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = ((AbstractButton)changeEvent.getSource()).isSelected();
                WebPublishOptionsTab.this.tf_webpath.setEnabled(!bl);
                if (bl && WebPublishOptionsTab.this.cb_notCpyThmbHtml.isSelected()) {
                    WebPublishOptionsTab.this.cb_notCpyThmbHtml.setSelected(false);
                }
            }
        });
        this.cb_notCpyThmbHtml.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (WebPublishOptionsTab.this.cb_notCpyImgs.isSelected() && WebPublishOptionsTab.this.cb_notCpyThmbHtml.isSelected()) {
                    WebPublishOptionsTab.this.cb_notCpyImgs.setSelected(false);
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bt_brws_wroot) {
            Object object;
            FtpFileSystemView ftpFileSystemView = null;
            if (this.publishModeSel.getSelectedIndex() == 1) {
                this.controller.setWaitCursor(this.getTopLevelAncestor(), true);
                object = new Ftp(WebPublishOptionsTab.getConnectionInfo(this.controller.getSerializer()), false);
                if (!((Ftp)object).isConnected) {
                    this.controller.setWaitCursor(this.getTopLevelAncestor(), false);
                    JOptionPane.showMessageDialog(this, "Ftp connection failed, check host name and/or proxy settings", "Error", 0);
                    return;
                }
                try {
                    ((Ftp)object).login();
                    ftpFileSystemView = new FtpFileSystemView((Ftp)object);
                }
                catch (IOException iOException) {
                    this.controller.setWaitCursor(this.getTopLevelAncestor(), false);
                    JOptionPane.showMessageDialog(this, "Ftp login's been failed, 'cause\n" + iOException, "Error", 0);
                    return;
                }
            }
            object = new JDirectoryChooser(new JFrame(), this.tf_webroot.getText(), ftpFileSystemView);
            this.controller.setWaitCursor(this.getTopLevelAncestor(), false);
            if (((JDirectoryChooser)object).getDirectory() != null) {
                this.tf_webroot.setText(((JDirectoryChooser)object).getDirectory());
            }
        } else if (actionEvent.getSource() == this.bt_brws_htmltmpl) {
            String string = this.tf_htmltmpl.getText();
            if (string.length() == 0) {
                string = this.controller.getSerializer().getHomeDirectory();
            }
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.addChoosableFileFilter(this.controller.getHtmlFilter());
            jFileChooser.setFileFilter(this.controller.getHtmlFilter());
            jFileChooser.setDialogTitle("Choose HTML template file");
            if (jFileChooser.showOpenDialog(this) == 0) {
                this.tf_htmltmpl.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        } else if (actionEvent.getActionCommand().equals("Setup >>")) {
            switch (this.publishModeSel.getSelectedIndex()) {
                case 1: {
                    if (this.ftpdialog == null) {
                        this.ftpdialog = new FtpDialog();
                    }
                    ((Component)this.ftpdialog).setVisible(true);
                    break;
                }
                case 2: {
                    ((Component)new HttpSettingsDialog()).setVisible(true);
                    break;
                }
                case 3: {
                    ((Component)new MailSettingsDialog()).setVisible(true);
                    break;
                }
            }
        }
    }

    public static FtpConnectionInfo getConnectionInfo(Serializer serializer) {
        WebPublishOptionsTab.connectioninfo.startDirectory = (String)serializer.getProperty(SECNAME, WEBROOT);
        WebPublishOptionsTab.connectioninfo.host = (String)serializer.getProperty(SECNAME, HOSTNAME);
        WebPublishOptionsTab.connectioninfo.user = (String)serializer.getProperty(SECNAME, FTPLOGIN);
        String string = (String)serializer.getProperty(SECNAME, FTPPASSWORD);
        if (string != null) {
            try {
                connectioninfo.setPassword(BaseController.encryptXor(new String(BaseController.hexToBytes(string), "iso-8859-1")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        WebPublishOptionsTab.connectioninfo.proxyHost = (String)serializer.getProperty(SECNAME, PROXYHOST);
        try {
            WebPublishOptionsTab.connectioninfo.proxyPort = (Integer)serializer.getProperty(SECNAME, PROXYPORT);
        }
        catch (Throwable throwable) {
            WebPublishOptionsTab.connectioninfo.proxyPort = 27;
        }
        try {
            WebPublishOptionsTab.connectioninfo.timeout = (Integer)serializer.getProperty(SECNAME, TIMEOUT);
        }
        catch (Throwable throwable) {
            WebPublishOptionsTab.connectioninfo.timeout = 20000;
        }
        try {
            WebPublishOptionsTab.connectioninfo.useProxy = (Integer)serializer.getProperty(SECNAME, USEPROXY) == 1;
        }
        catch (Throwable throwable) {
            WebPublishOptionsTab.connectioninfo.useProxy = false;
        }
        try {
            WebPublishOptionsTab.connectioninfo.active = (Integer)serializer.getProperty(SECNAME, PASSIVEMODE) == 0;
        }
        catch (Throwable throwable) {
            WebPublishOptionsTab.connectioninfo.active = true;
        }
        try {
            WebPublishOptionsTab.connectioninfo.askPassword = (Integer)serializer.getProperty(SECNAME, ASKPSWD) == 1;
        }
        catch (Throwable throwable) {
            WebPublishOptionsTab.connectioninfo.askPassword = true;
        }
        return connectioninfo;
    }

    public void load() {
        String string;
        Serializer serializer = this.controller.getSerializer();
        Integer n = (Integer)serializer.getProperty(SECNAME, PUBMODE);
        if (n != null) {
            this.publishModeSel.setSelectedIndex(n);
        }
        WebPublishOptionsTab.getConnectionInfo(serializer);
        if (WebPublishOptionsTab.connectioninfo.startDirectory != null) {
            this.tf_webroot.setText(WebPublishOptionsTab.connectioninfo.startDirectory);
        }
        if ((string = (String)serializer.getProperty(SECNAME, HTMLTEMPL)) != null) {
            this.tf_htmltmpl.setText(string);
        }
        if ((string = (String)serializer.getProperty(SECNAME, IMAGEPATH)) != null) {
            this.tf_webpath.setText(string);
        }
        if ((string = (String)serializer.getProperty(SECNAME, TNWEBPATH)) != null) {
            this.tf_tnwebpath.setText(string);
        }
        if ((string = (String)serializer.getProperty(SECNAME, IMAGEURL)) != null) {
            this.tf_pic_url.setText(string);
        }
        this.cb_webpic.setSelected(Serializer.getInt(serializer.getProperty(SECNAME, USEURLPATH), 0) == 1);
        boolean bl = Serializer.getInt(serializer.getProperty(SECNAME, CPYPICSONLY), 1) == 0;
        this.cb_notCpyThmbHtml.setSelected(bl);
        this.cb_notCpyImgs.setSelected(Serializer.getInt(serializer.getProperty(SECNAME, CPYPICS), 1) == 0 && bl);
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        serializer.setProperty(SECNAME, WEBROOT, this.tf_webroot.getText());
        serializer.setProperty(SECNAME, PUBMODE, new Integer(this.publishModeSel.getSelectedIndex()));
        serializer.setProperty(SECNAME, HTMLTEMPL, this.tf_htmltmpl.getText());
        serializer.setProperty(SECNAME, IMAGEPATH, this.tf_webpath.getText());
        serializer.setProperty(SECNAME, TNWEBPATH, this.tf_tnwebpath.getText());
        serializer.setProperty(SECNAME, IMAGEURL, this.tf_pic_url.getText());
        serializer.setProperty(SECNAME, USEURLPATH, this.cb_webpic.isSelected() ? Resources.I_YES : Resources.I_NO);
        serializer.setProperty(SECNAME, CPYPICS, this.cb_notCpyImgs.isSelected() ? Resources.I_NO : Resources.I_YES);
        serializer.setProperty(SECNAME, CPYPICSONLY, this.cb_notCpyThmbHtml.isSelected() ? Resources.I_NO : Resources.I_YES);
        WebPublishOptionsTab.getConnectionInfo(serializer);
    }

    class RadioButtonsGroup
    extends ButtonGroup {
        Hashtable sel_map = new Hashtable();

        RadioButtonsGroup() {
        }

        public void add(AbstractButton abstractButton, int n) {
            this.sel_map.put(abstractButton, new Integer(n));
            super.add(abstractButton);
        }

        int getSelectedIndex() {
            Enumeration<AbstractButton> enumeration = this.getElements();
            while (enumeration.hasMoreElements()) {
                JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                if (!jRadioButton.isSelected()) continue;
                return (Integer)this.sel_map.get(jRadioButton);
            }
            return -1;
        }

        void setSelectedIndex(int n) {
            Enumeration<AbstractButton> enumeration = this.getElements();
            while (enumeration.hasMoreElements()) {
                JRadioButton jRadioButton;
                jRadioButton.setSelected((Integer)this.sel_map.get(jRadioButton = (JRadioButton)enumeration.nextElement()) == n);
            }
        }
    }

    class HttpSettingsDialog
    extends PersistantDialog {
        JTextField tf_servletUrl;
        JTextField tf_inputDst;
        JTextField tf_inputData;
        JTextField tf_user;
        JTextField tf_login_url;
        JTextField tf_loginName;
        JTextField tf_passwordName;
        JTextField tf_staticQuery;
        JPasswordField tf_password;
        JComboBox cb_auths;
        JComboBox cb_loginMethod;

        HttpSettingsDialog() {
            super((JFrame)WebPublishOptionsTab.this.getTopLevelAncestor(), "HTTP settings", true);
            Container container = this.getContentPane();
            container.setLayout(new GranulatedLayout(2, 16, 20, 4, 8, 8));
            container.add((Component)new JLabel("URL of upload servlet"), "0,0,2");
            this.tf_servletUrl = new JTextField();
            container.add((Component)this.tf_servletUrl, "0,1,2");
            container.add((Component)new JLabel("Dest input name"), "0,2,1");
            this.tf_inputDst = new JTextField();
            container.add((Component)this.tf_inputDst, "1,2,1");
            container.add((Component)new JLabel("Data input name"), "0,3,1");
            this.tf_inputData = new JTextField();
            container.add((Component)this.tf_inputData, "1,3,1");
            container.add((Component)new JLabel("Authentication"), "0,4,1");
            this.cb_auths = new JComboBox<String>(Resources.HTTP_AUTHS);
            container.add(this.cb_auths, "1,4,1");
            container.add((Component)new JLabel("Login URL"), "0,5,1");
            this.tf_login_url = new JTextField();
            container.add((Component)this.tf_login_url, "0,6,2");
            container.add((Component)new JLabel("Login input name"), "0,7,1");
            this.tf_loginName = new JTextField();
            container.add((Component)this.tf_loginName, "1,7,1");
            container.add((Component)new JLabel("Password input name"), "0,8,1");
            this.tf_passwordName = new JTextField();
            container.add((Component)this.tf_passwordName, "1,8,1");
            container.add((Component)new JLabel("Login method"), "0,9,1");
            this.cb_loginMethod = new JComboBox<String>(Resources.HTTP_LOGIN_METHODS);
            container.add(this.cb_loginMethod, "1,9,1");
            container.add((Component)new JLabel("Login"), "0,10,1");
            this.tf_user = new JTextField();
            container.add((Component)this.tf_user, "1,10,1");
            container.add((Component)new JLabel("Password"), "0,11,1");
            this.tf_password = new JPasswordField();
            container.add((Component)this.tf_password, "1,11,1");
            container.add((Component)new JLabel("Additional param=value&..."), "0,12,2");
            this.tf_staticQuery = new JTextField();
            container.add((Component)this.tf_staticQuery, "0,13,2");
            this.cb_auths.addItemListener(new ItemListener(this){
                private final /* synthetic */ HttpSettingsDialog this$1;
                {
                    this.this$1 = httpSettingsDialog;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    HttpSettingsDialog.access$000(this.this$1);
                }
            });
            JButton jButton = new JButton("Reset");
            container.add((Component)jButton, "1,15,1");
            jButton.addActionListener(this);
            this.pack();
            this.load();
        }

        public void save() {
            Serializer serializer = WebPublishOptionsTab.this.controller.getSerializer();
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.UPL_SERVLET_URL, this.tf_servletUrl.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.UPL_DEST_NAME, this.tf_inputDst.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.UPL_DATA_NAME, this.tf_inputData.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPPASSWORD_NAME, this.tf_passwordName.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPSTATICQUERY, this.tf_staticQuery.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPLOGIN_NAME, this.tf_loginName.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPLOGIN, this.tf_user.getText());
            try {
                serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPPASSWORD, BaseController.bytesToHex(BaseController.encryptXor(new String(this.tf_password.getPassword())).getBytes("iso-8859-1")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTP_AUTH_SHC, new Integer(this.cb_auths.getSelectedIndex()));
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPLOGINURL, this.tf_login_url.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPLOGINMETHOD, new Integer(this.cb_loginMethod.getSelectedIndex()));
        }

        public void load() {
            Serializer serializer = WebPublishOptionsTab.this.controller.getSerializer();
            this.tf_servletUrl.setText((String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.UPL_SERVLET_URL));
            this.tf_inputDst.setText((String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.UPL_DEST_NAME));
            this.tf_inputData.setText((String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.UPL_DATA_NAME));
            this.tf_loginName.setText((String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPLOGIN_NAME));
            this.tf_passwordName.setText((String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPPASSWORD_NAME));
            this.tf_staticQuery.setText((String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPSTATICQUERY));
            this.tf_user.setText((String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPLOGIN));
            String string = (String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPPASSWORD);
            if (string != null) {
                try {
                    ((JTextComponent)this.tf_password).setText(BaseController.encryptXor(new String(BaseController.hexToBytes(string), "iso-8859-1")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.cb_auths.setSelectedIndex(Serializer.getInt(serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTP_AUTH_SHC), 0));
            this.tf_login_url.setText((String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPLOGINURL));
            this.cb_loginMethod.setSelectedIndex(Serializer.getInt(serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HTTPLOGINMETHOD), 0));
            this.updateUI();
        }

        private void updateUI() {
            boolean bl = this.cb_auths.getSelectedIndex() > 0;
            this.tf_user.setEnabled(bl);
            this.tf_password.setEnabled(bl);
            this.cb_loginMethod.setEnabled(bl);
            this.tf_login_url.setEnabled(bl);
            this.tf_loginName.setEnabled(bl);
            this.tf_passwordName.setEnabled(bl);
            this.tf_staticQuery.setEnabled(bl);
        }

        static /* synthetic */ void access$000(HttpSettingsDialog httpSettingsDialog) {
            httpSettingsDialog.updateUI();
        }
    }

    class MailSettingsDialog
    extends PersistantDialog {
        JTextField tf_name;
        JTextField tf_organization;
        JTextField tf_email;
        JTextField tf_reply;
        JTextField tf_server;
        JTextField tf_port;
        JCheckBox cb_ssl;
        JSlider sl_timeout;
        JLabel l_timeout;

        MailSettingsDialog() {
            super((JFrame)WebPublishOptionsTab.this.getTopLevelAncestor(), "E-mail settings", true);
            Container container = this.getContentPane();
            container.setLayout(new GranulatedLayout(3, 8, 20, 4, 8, 8));
            container.add((Component)new JLabel("Name"), "0,0,1");
            this.tf_name = new JTextField();
            container.add((Component)this.tf_name, "1,0,2");
            container.add((Component)new JLabel(WebPublishOptionsTab.ORGANIZATION), "0,1,1");
            this.tf_organization = new JTextField();
            container.add((Component)this.tf_organization, "1,1,2");
            container.add((Component)new JLabel("E-mail address"), "0,2,1");
            this.tf_email = new JTextField();
            container.add((Component)this.tf_email, "1,2,2");
            container.add((Component)new JLabel("Reply address"), "0,3,1");
            this.tf_reply = new JTextField();
            container.add((Component)this.tf_reply, "1,3,2");
            container.add((Component)new JLabel("SMTP server"), "0,4,1");
            this.tf_server = new JTextField();
            container.add((Component)this.tf_server, "1,4,2");
            container.add((Component)new JLabel("SMTP port"), "0,5,1");
            this.tf_port = new JTextField("25");
            container.add((Component)this.tf_port, "1,5,1");
            this.tf_port.setHorizontalAlignment(4);
            this.cb_ssl = new JCheckBox("SSL");
            container.add((Component)this.cb_ssl, "2,5,1");
            container.add((Component)new JLabel("Server timeout"), "0,6,1");
            JButton jButton = new JButton("Reset");
            container.add((Component)jButton, "2,6,1");
            jButton.addActionListener(this);
            this.sl_timeout = new JSlider(0, 120, 20);
            container.add((Component)this.sl_timeout, "0,7,2,0");
            this.sl_timeout.setMajorTickSpacing(30);
            this.sl_timeout.setMinorTickSpacing(5);
            this.sl_timeout.setSnapToTicks(true);
            this.l_timeout = new JLabel("sec");
            container.add((Component)this.l_timeout, "2,7,1");
            this.sl_timeout.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ MailSettingsDialog this$1;
                {
                    this.this$1 = mailSettingsDialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (changeEvent.getSource() == this.this$1.sl_timeout) {
                        this.this$1.l_timeout.setText("" + this.this$1.sl_timeout.getValue() + " " + "sec");
                    }
                }
            });
            this.pack();
            this.load();
        }

        public void save() {
            Serializer serializer = WebPublishOptionsTab.this.controller.getSerializer();
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.SMTPSERVER, this.tf_server.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.SMTPUSER, this.tf_name.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.ORGANIZATION, this.tf_organization.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.REPLYADDR, this.tf_reply.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.EMAILADDR, this.tf_email.getText());
            try {
                serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.SMTPPORT, new Integer(this.tf_port.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.USESSL, this.cb_ssl.isSelected() ? Resources.I_YES : Resources.I_NO);
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.SRVTIMEOUT, new Integer(this.sl_timeout.getValue()));
        }

        public void load() {
            Serializer serializer = WebPublishOptionsTab.this.controller.getSerializer();
            this.cb_ssl.setSelected(Serializer.getInt(serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.USESSL), 0) == 1);
            this.sl_timeout.setValue(Serializer.getInt(serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.SRVTIMEOUT), 20));
            this.l_timeout.setText("" + this.sl_timeout.getValue() + " " + "sec");
            String string = (String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.SMTPSERVER);
            if (string != null) {
                this.tf_server.setText(string);
            }
            if ((string = Serializer.arrayToString(serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.SMTPUSER))) != null) {
                this.tf_name.setText(string);
            }
            if ((string = Serializer.arrayToString(serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.ORGANIZATION))) != null) {
                this.tf_organization.setText(string);
            }
            if ((string = (String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.REPLYADDR)) != null) {
                this.tf_reply.setText(string);
            }
            if ((string = (String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.EMAILADDR)) != null) {
                this.tf_email.setText(string);
            }
            this.tf_port.setText("" + Serializer.getInt(serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.SMTPPORT), 25));
        }
    }

    class FtpDialog
    extends PersistantDialog {
        JSlider sl_conntimeout;
        JPasswordField tf_pswd;
        JTextField tf_proxyhost;
        JTextField tf_proxyport;
        JTextField tf_hostname;
        JTextField tf_user;
        JCheckBox cb_useproxy;
        JCheckBox cb_keeppswd;
        JCheckBox cb_passivemode;
        JLabel l_timeout;

        FtpDialog() {
            super((JFrame)WebPublishOptionsTab.this.getTopLevelAncestor(), "FTP settings", true);
            Container container = this.getContentPane();
            container.setLayout(new GranulatedLayout(2, 15, 20, 4, 8, 8));
            container.add((Component)new JLabel("Ftp host"), "0,0,2");
            this.tf_hostname = new JTextField();
            container.add((Component)this.tf_hostname, "0,1,2");
            container.add((Component)new JLabel("Login"), "0,2,2");
            this.tf_user = new JTextField();
            container.add((Component)this.tf_user, "0,3,2");
            container.add((Component)new JLabel("Password"), "0,4,1");
            this.tf_pswd = new JPasswordField();
            container.add((Component)this.tf_pswd, "0,5,1");
            this.cb_keeppswd = new JCheckBox("Save password");
            container.add((Component)this.cb_keeppswd, "1,5,1");
            this.cb_passivemode = new JCheckBox("Passive mode");
            container.add((Component)this.cb_passivemode, "0,6,1");
            container.add((Component)new JLabel("Connection timeout"), "0,7,2");
            this.sl_conntimeout = new JSlider(0, 120, 20);
            container.add((Component)this.sl_conntimeout, "0,9,1,0");
            this.l_timeout = new JLabel("sec");
            container.add((Component)this.l_timeout, "1,9,1");
            this.cb_useproxy = new JCheckBox("Use proxy");
            container.add((Component)this.cb_useproxy, "0,10,1");
            container.add((Component)new JLabel("Host"), "0,11,1");
            this.tf_proxyhost = new JTextField();
            container.add((Component)this.tf_proxyhost, "0,12,2");
            container.add((Component)new JLabel("Port"), "0,13,1");
            this.tf_proxyport = new JTextField();
            container.add((Component)this.tf_proxyport, "0,14,1");
            this.tf_proxyport.setHorizontalAlignment(4);
            JButton jButton = new JButton("Reset");
            container.add((Component)jButton, "1,14,1");
            jButton.addActionListener(this);
            this.sl_conntimeout.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ FtpDialog this$1;
                {
                    this.this$1 = ftpDialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (changeEvent.getSource() == this.this$1.sl_conntimeout) {
                        this.this$1.l_timeout.setText("" + this.this$1.sl_conntimeout.getValue() + " " + "sec");
                    }
                }
            });
            this.cb_useproxy.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ FtpDialog this$1;
                {
                    this.this$1 = ftpDialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    boolean bl = ((AbstractButton)changeEvent.getSource()).isSelected();
                    this.this$1.tf_proxyhost.setEnabled(bl);
                    this.this$1.tf_proxyport.setEnabled(bl);
                }
            });
            this.cb_keeppswd.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ FtpDialog this$1;
                {
                    this.this$1 = ftpDialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    boolean bl = ((AbstractButton)changeEvent.getSource()).isSelected();
                    if (!bl) {
                        ((JTextComponent)this.this$1.tf_pswd).setText("");
                    }
                    this.this$1.tf_pswd.setEnabled(bl);
                }
            });
            this.pack();
            this.load();
        }

        public void save() {
            Integer n;
            Serializer serializer = WebPublishOptionsTab.this.controller.getSerializer();
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.HOSTNAME, this.tf_hostname.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.FTPLOGIN, this.tf_user.getText());
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.PROXYHOST, this.tf_proxyhost.getText());
            try {
                n = new Integer(this.tf_proxyport.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = Resources.I_NO;
            }
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.PROXYPORT, n);
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.TIMEOUT, new Integer(this.sl_conntimeout.getValue() * 1000));
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.USEPROXY, this.cb_useproxy.isSelected() ? Resources.I_YES : Resources.I_NO);
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.ASKPSWD, this.cb_keeppswd.isSelected() ? Resources.I_NO : Resources.I_YES);
            serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.PASSIVEMODE, this.cb_passivemode.isSelected() ? Resources.I_YES : Resources.I_NO);
            if (this.cb_keeppswd.isSelected()) {
                try {
                    serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.FTPPASSWORD, BaseController.bytesToHex(BaseController.encryptXor(new String(this.tf_pswd.getPassword())).getBytes("iso-8859-1")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                serializer.setProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.FTPPASSWORD, "");
            }
        }

        public void load() {
            Serializer serializer = WebPublishOptionsTab.this.controller.getSerializer();
            if (WebPublishOptionsTab.connectioninfo.host != null) {
                this.tf_hostname.setText(WebPublishOptionsTab.connectioninfo.host);
            }
            if (WebPublishOptionsTab.connectioninfo.user != null) {
                this.tf_user.setText(WebPublishOptionsTab.connectioninfo.user);
            }
            if (!WebPublishOptionsTab.connectioninfo.askPassword && connectioninfo.getPassword() != null) {
                ((JTextComponent)this.tf_pswd).setText(connectioninfo.getPassword());
            }
            this.tf_proxyport.setText("" + WebPublishOptionsTab.connectioninfo.proxyPort);
            this.sl_conntimeout.setValue(WebPublishOptionsTab.connectioninfo.timeout / 1000);
            this.l_timeout.setText("" + this.sl_conntimeout.getValue() + " " + "sec");
            if (WebPublishOptionsTab.connectioninfo.proxyHost != null) {
                this.tf_proxyhost.setText(WebPublishOptionsTab.connectioninfo.proxyHost);
            }
            this.cb_useproxy.setSelected(WebPublishOptionsTab.connectioninfo.useProxy);
            this.cb_keeppswd.setSelected(!WebPublishOptionsTab.connectioninfo.askPassword);
            this.cb_passivemode.setSelected(!WebPublishOptionsTab.connectioninfo.active);
        }
    }

    abstract class PersistantDialog
    extends JDialog
    implements Persistentable,
    ActionListener {
        PersistantDialog(JFrame jFrame, String string, boolean bl) {
            super(jFrame, string, bl);
        }

        protected void processWindowEvent(WindowEvent windowEvent) {
            if (windowEvent.getID() == 201) {
                this.save();
            }
            super.processWindowEvent(windowEvent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("Reset")) {
                this.load();
            }
        }

        public abstract void load();

        public abstract void save();
    }
}

