/* PhotoOrganizer 
 * Copyright (C) 1999-2000 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package photoorganizer;

import java.util.Hashtable;

public class Resources {
    // menu constraints
    public final static String MENU_PROPERTIES = "Properties...";
    public final static String MENU_DRIVE_SEL = "Change drive";
    public final static String MENU_FILE = "File";
    public final static String MENU_EXIT = "Exit";
    public final static String MENU_TOOLS = "Tools";
    public final static String MENU_ADDTOCOLLECT = "To selection";
    public final static String MENU_CF_TOCOLLECT = "Get CF";
    public final static String MENU_ADDTOALBUM = "To album";
    public final static String MENU_HELP = "Help";
    public final static String MENU_VIEW = "View";
    public final static String MENU_CONTENTS = "Contents...";
    public final static String MENU_TRANSFORM = "Transformation";
    public final static String MENU_NONE = "None";
    public final static String MENU_ROTATE90 = "Rotate 90";
    public final static String MENU_ROTATE180 = "Rotate 180";
    public final static String MENU_ROTATE270 = "Rotate 270";
    public final static String MENU_FLIP_H = "Horizontal flip";
    public final static String MENU_FLIP_V = "Vertical flip";
    public final static String MENU_TRANSPOSE = "Transpose";
    public final static String MENU_TRANSVERSE = "Transverse";
    public final static String MENU_ABOUT = "About...";
    public final static String MENU_SHOW = "Show";
    public final static String MENU_SELECT = "Select";
    public final static String MENU_REVERSE_SELECT = "Invert selection";
    public final static String MENU_SELECTALL = "Select all";
    public final static String MENU_DELETE = "Delete";
    public final static String MENU_DELETE_COMPLETLY = "Delete all";
    public final static String MENU_RENAME = "Rename";
    public final static String MENU_EXTRACTTUMBNAILS = "Extract thumbs";
    public final static String MENU_EXTRACTMARKERS = "Extract markers";
    public final static String MENU_GENERATEHTML = "Web publishing";
    public final static String MENU_POPUPWIN = "PopUp";
    public final static String MENU_PUBLISH = "Publish";
    public final static String MENU_PUBLISH_CURRENT = "This album";
    public final static String MENU_PUBLISH_ALL = "All albums";
    public final static String MENU_INTWIN = "GetBack";
    public final static String MENU_FULLSCREEN = "FullScreen";
    public final static String MENU_PRINT = "Print";
    public final static String MENU_VIEW_HTML = "View HTML";
    public final static String MENU_STITCH = "Stitch";
    public final static String MENU_COMMENT = "Add comment";
    public final static String MENU_SENDTO = "Send by e-mail";
    public final static String MENU_COPY_MOVE = "Copy/move";
    public final static String MENU_EXPORTTOCSV = "Export to CSV...";
    public final static String MENU_OPTIONS = "Options...";
    public final static String MENU_REFRESH = "Refresh";
    public final static String MENU_NEXT = "Next";
    public final static String MENU_PREVIOUS = "Prev";
    public final static String MENU_MOVE_ALBUM = "Move album {0} under {1}";
    public final static String MENU_COPY_ALBUM = "Copy album {0} under {1}";
    public final static String LIST_DATETIME = "DateTime";
    public final static String LIST_DATE = "Date";
    public final static String LIST_TIME = "Time";
    public final static String LIST_SHUTTER = "Shutter";
    public final static String LIST_APERTURE = "Aperture";
    public final static String LIST_FLASH = "Flash";
    public final static String LIST_QUALITY = "Quality";
    public final static String LIST_COUNTER = "Counter";
    public final static String LIST_ORIG = "OriginalName";
    public final static String LIST_ORIENTATION = "Orientation";
    public final static String LIST_ZOOM = "Zoom";
    public final static String LIST_FILESIZE = "Size";
    public final static String LIST_MAKE = "Make";
    public final static String LIST_MODEL = "Model";
    public final static String LIST_METERING = "Metering mode";
    public final static String LIST_MODE = "Exposure program";
    public final static String LIST_ONTOP = "On top";
    public final static String LIST_ONBOTTOM = "On bottom";
    public final static String LIST_ONLEFT = "On left";
    public final static String LIST_ONRIGHT = "On right";
    public final static String [][]MASKS = new String[][]
    {{"%D", "%d","%t", "%s", "%a", "%f", "%q", "%c", "%o", "%r", "%z", "%S", "%M", "%m", "%e", "%E"},
    {LIST_DATETIME, LIST_DATE, LIST_TIME, LIST_SHUTTER, LIST_APERTURE,
    LIST_FLASH, LIST_QUALITY, LIST_COUNTER, LIST_ORIG, LIST_ORIENTATION,
    LIST_ZOOM, LIST_FILESIZE, LIST_MAKE, LIST_MODEL, LIST_METERING, LIST_MODE}
    };
    public final static String LIST_NONE = "None";
    public final static String LIST_EXIF = "Exif";
    public final static String LIST_CIFF = "CIFF";
    public final static String LIST_JFIF = "JFXX";
    public final static String LIST_EXTRN = "From ext file";
    public final static String [] FORMATS = new String[] {
        LIST_NONE, LIST_EXIF, LIST_CIFF, LIST_JFIF, LIST_EXTRN
    };

    public final static String [] POSITIONS = new String[] {
        LIST_ONTOP, LIST_ONBOTTOM, LIST_ONLEFT, LIST_ONRIGHT
    };

    public final static String [] ROTATIONS = new String[] {
        "None", "HFlip", "VFlip", "Transpose", "Transverse", "Rot90",
        "Rot180", "Rot270", "Cmt"
    };

    public final static String BORDER_BEVELLOWERED = "BevelLowered";
    public final static String BORDER_BEVELRAISED = "BevelRaised";
    public final static String BORDER_ETCHED = "Etched";
    public final static String BORDER_LINE = "Line";
    public final static String [] BORDERS = new String[] {
        "None", BORDER_BEVELLOWERED, BORDER_BEVELRAISED, BORDER_ETCHED, BORDER_LINE
    };

    public final static String [] HTTP_AUTHS = new String[] {
                                                  "No authentication",
                                                  "Login/Cookie",
                                                  "Login/UID"
                                                 };

    public final static String [] HTTP_LOGIN_METHODS = new String[] {
                                                          "Get",
                                                          "Post"
                                                          };

    public final static String [] COUNTRIES = {"US", "FR", "RU"};
    public final static String [] LANGUAGES = {"en", "fr", "ru"};
    public final static String LABEL_NAMEGENMASK = "Target name generation mask";
    public final static String LABEL_INSERT = "Insert";
    public final static String LABEL_INS_R = "<";
    public final static String LABEL_INS_L = ">";
    public final static String LABEL_KEEP_APPS = "Preserve APPs";
    public final static String LABEL_KEEP_ORIG = "Keep original";
    public final static String LABEL_ENFORCE_FMT = "Enforce format";
    public final static String LABEL_DESTINATIONDIR = "Destination folder for renaming and transformation";
    public final static String LABEL_CHOOSE_DIR = "Choose a folder";
    public final static String LABEL_DIRECTORIES = "Folders";
    public final static String LABEL_WEB_ROOT = "Web root";
    public final static String LABEL_HTML_TEMPLATE = "HTML template";
    public final static String LABEL_HTML_FILES = "HTML files";
    public final static String LABEL_DIRECTORY = "Directory";
    public final static String LABEL_CF_DIR = "CF directory";
    public final static String LABEL_FILE = "File";
    public final static String LABEL_NUM_ = "Number of ";
    public final static String LABEL_COL = "columns";
    public final static String LABEL_ROW = "rows";
    public final static String LABEL_SCROLL_VERT = "Scroll vertically";
    public final static String LABEL_THUMBNAILFILE_MASK = "Thumbnail file mask";
    public final static String LABEL_THUMBNAILSIZE = "Thumbnail";
    public final static String LABEL_EDIT_NEW_NAME = "Edit name before";
    public final static String LABEL_LABEL_MASK = "Label mask";
    public final static String LABEL_TTIP_MASK = "Tooltip mask";
    public final static String LABEL_WIDTH_SHORT = "width:";
    public final static String LABEL_HEIGHT_SHORT = "height:";
    public final static String LABEL_NEW_NAME = "New name";
    public final static String LABEL_CONFIRM_DEL = "- will be removed permanently.\nAre you sure?";
    public final static String LABEL_CHOOSE_DRIVE = "Choose drive";
    public final static String LABEL_START_COUNTER = "Initial counter";
    public final static String LABEL_MENU = "Menu";
    public final static String LABEL_TOOLBAR = "ToolBar";
    public final static String LABEL_SATUSBAR = "StatusBar";
    public final static String LABEL_TABPOS = "Tab position";
    public final static String LABEL_DATEFMT = "Date format";
    public final static String LABEL_TIMEFMT = "Time format";
    public final static String LABEL_TRANS_CODE = "Transform code";
    public final static String LABEL_NOTUMBNAIL = "No thumbnail for ";
    public final static String LABEL_HTML_NAME = "Name of HTML file";
    public final static String LABEL_MARKERS = "Markers";
    public final static String LABEL_NOJDBCWARN = "No warn if JDBC failed";
    public final static String LABEL_JDBCDRV_CLASS = "JDBC driver class name";
    public final static String LABEL_PASSWORD = "Password";
    public final static String LABEL_USER = "User";
    public final static String LABEL_HTTP_AUTH = "Authentication";
    public final static String LABEL_HTTP_LOGIN_URL = "Login URL";
    public final static String LABEL_HTTP_LOGIN_METHOD = "Login method";
    public final static String LABEL_STATIC_QUERY = "Additional param=value&...";
    public final static String LABEL_DATABASE_URL = "Database URL";
    public final static String LABEL_FTP_HOST = "Ftp host";
    public final static String LABEL_LOGIN = "Login";
    public final static String LABEL_SAVE_PSWD = "Save password";
    public final static String LABEL_CONN_TIMEOUT = "Connection timeout";
    public final static String LABEL_USE_PROXY = "Use proxy";
    public final static String LABEL_HOST = "Host";
    public final static String LABEL_PORT = "Port";
    public final static String LABEL_USE_FTP = "Ftp";
    public final static String LABEL_USE = "Use:";
    public final static String LABEL_NAME_OF_ALBUM = "Name of the album";
    public final static String LABEL_ALBUMROOT = "Albums";
    public final static String LABEL_INCLUSIVE = "add to selcted albums";
    public final static String LABEL_SHOWWARNDLG = "Show confirmation dialogs";
    public final static String LABEL_ERR_FTP_LOGIN = "Ftp login's been failed, 'cause\n";
    public final static String LABEL_ERR_JDBCDRV_LOAD = "JDBC driver can't be instantiated, 'cause\n";
    public final static String LABEL_ERR_JDBC_CONN = "Couldn't establish database connection, check URL\n";
    public final static String LABEL_ERR_FTP_CONNECT = "Ftp connection failed, check host name and/or proxy settings";
    public final static String LABEL_ERR_MAIL_SEND = "E-Mail sending failed, check e-mail settings";
    public final static String LABEL_ERR_COPYALBUM = "The album can't be moved/copied, because it includes target album(s)";
    public final static String LABEL_COFIRMDROPTABLE = "All albums will be destroyed, please confirm.";
    public final static String LABEL_COFIRMDELETE = "Confirm deleting ";
    public final static String LABEL_ADDTRANSFORMEDTOSEL = "Add transformed to selection";
    public final static String LABEL_REMOVE_AFTER_REN = "Remove from selection";
    public final static String LABEL_USE_DIRALBUM = "Maintain folder for albums";
    public final static String LABEL_MOVETO_ALBUM = "Move picture to album folder";
    public final static String LABEL_COMMENT = "Type a commentary";
    public final static String LABEL_LOCALES = "Locales";
    public final static String LABEL_SPLIT_VERT = "Split vertically";
    public final static String LABEL_SPLIT_HORZ = "Split horizontally";
    public final static String LABEL_OUTOFMEMORY = "The system runs on very low free memory, the current operation will be terminated.";
    public final static String LABEL_USE_COMMENT = "Comment as label";
    public final static String LABEL_PIC_LOC = "Pictures location";
    public final static String LABEL_PIC_URL = "Pictures URL";
    public final static String LABEL_TN_LOC = "Thumbnails location";
    public final static String LABEL_USE_WEB_PIC = "Use picture URL";
    public final static String LABEL_CPY_PIC = "Don't copy images";
    public final static String LABEL_NOTCOPY_THUMBS = "Don't copy thumbs&HTML";
    public final static String LABEL_NAME = "Name";
    public final static String LABEL_CLASS = "Class";
    public final static String LABEL_TOOLTIP = "Tool tip";
    public final static String LABEL_DISABLED = "Disabled";
    public final static String LABEL_ALL_DISABLED = "All disabled";
    public final static String LABEL_ORG = "Organization";
    public final static String LABEL_EMAILA = "E-mail address";
    public final static String LABEL_REPLYA = "Reply address";
    public final static String LABEL_SMTPSRV = "SMTP server";
    public final static String LABEL_SMTPPRT = "SMTP port";
    public final static String LABEL_PASSIVE_MODE = "Passive mode";
    public final static String LABEL_SSL = "SSL";
    public final static String LABEL_SRVTIMEOUT = "Server timeout";
    public final static String LABEL_MIN = "min";
    public final static String LABEL_SEC = "sec";
    public final static String LABEL_INPUT_URL = "Specify complete URL of created page";
    public final static String LABEL_SENDTO = MENU_SENDTO;
    public final static String LABEL_USE_LOCAL = "LOCAL";
    public final static String LABEL_USE_HTTP = "HTTP";
    public final static String LABEL_USE_SMTP = "SMTP";
    public final static String LABEL_USE_XML = "XML";
    public final static String LABEL_UPLOAD_SERVLET_URL = "URL of upload servlet";
    public final static String LABEL_UPLOAD_DST_NAME = "Dest input name";
    public final static String LABEL_UPLOAD_DATA_NAME = "Data input name";
    public final static String LABEL_LOGIN_NAME = "Login input name";
    public final static String LABEL_PASSWORD_NAME = "Password input name";
    public final static String LABEL_FOR_NEXT_VER = "For next release";
    public final static String LABEL_NO_ALBUMNAME = "put album name here";
    public final static String LABEL_CURRENT_SELECTION = "Current selection";
    public final static String LABEL_BORDER = "Border";
    public final static String LABEL_SELECTEDBORDER = "Selected border";
    public final static String INFO_RENAMING = "Renaming";
    public final static String INFO_TRANSFORMING = "Transforming";
    public final static String INFO_REMOVING = "Removing";
    public final static String INFO_MOVING = "Moving";
    public final static String INFO_COPYING = "Copying";
    public final static String INFO_PRINTING = "Printing";
    public final static String INFO_CONNECTING = "Connecting";
    public final static String INFO_WEBPUBLISHING = "Web publishing";
    public final static String INFO_ERR_WEBPUBLISHING = "Exception in Web publishing, see log for details.";
    public final static String HDR_NAME = "Name";
    public final static String HDR_LOCATION = "Location";
    public final static String HDR_COMMENT = "Comment";
    public final static String HDR_TAG = "Tag";
    public final static String HDR_VALUE = "Value";
    public final static String HDR_TYPE = "Type";
    public final static String HDR_SIZE = "Size";
    public final static String HDR_MODIFIED = "Modified";
    public final static String HDR_SHUTTER = "Shutter";
    public final static String HDR_APERTURE = "Aperture";
    public final static String HDR_FLASH = "Flash";
    public final static String HDR_QUALITY = "Quality";
    public final static String HDR_ZOOM = "Zoom";
    public final static String HDR_TAKEN = "Taken";
    public final static String CMD_YES = "Yes";
    public final static String CMD_NO = "No";
    public final static String CMD_OK = "OK";
//    public final static String CMD_APPLY = "Apply";
    public final static String CMD_APPLY = "<html><i>Apply";
    public final static String CMD_CANCEL = "Cancel";
    public final static String CMD_BROWSE = "Browse";
    public final static String CMD_CLOSE = "Close";
    public final static String CMD_OPEN = "Open";
    public final static String CMD_RESET = "Reset";
    public final static String CMD_CREATEDB = "Drop db";
    public final static String CMD_INITJDBC = "Check driver";
    public final static String CMD_CREATEALBUM = "Create a new album";
    public final static String CMD_SETUP = "Setup >>";
    public final static String CMD_HELP = MENU_HELP;
    public final static String CMD_ADDTOALBUM = MENU_ADDTOALBUM;
    public final static String CMD_ADDRESSBOOK = "Address Book";
    public final static String TITLE_HELP = MENU_HELP;
    public final static String TITLE_OPTIONS = "Options";
    public final static String TITLE_HTML_TEMPL = "Choose HTML template file";
    public final static String TITLE_SHOW = "Show";
    public final static String TITLE_PROPS_OF = "Properties of ";
    public final static String TITLE_RENAME = "Rename";
    public final static String TITLE_DELETE = "Delete";
    public final static String TITLE_CHANGE_DRIVE = "Change current drive";
    public final static String TITLE_CREATEHTML = "Web publishing";
    public final static String TITLE_SELECT_FOLDER = "Select folder";
    public final static String TITLE_SELECT_ALBUM = "Albums selection for - ";
    public final static String TITLE_ERROR = "Error";
    public final static String TITLE_COMMENT = "Commentary";
    public final static String TITLE_COFIRMATION = "Confirmation...";
    public final static String TITLE_PRINT = "Printing...";
    public final static String TITLE_FTP = "FTP settings";
    public final static String TITLE_EMAILS = "E-mail settings";
    public final static String TITLE_HTTP = "HTTP settings";
    public final static String TITLE_SENDTO = "Send E-mail";
    public final static String TITLE_URL_SEL = "URL selection";
    public final static String TITLE_ALBUMPROPS = "Album properties";
    public final static String TITLE_DEF_EMAILSUBJECT = "Information you've rquested";
    public final static String TTIP_RULEFORRENAME = "Specify a rule for renaming images";
    public final static String TTIP_RULEFORTRANSFORM = "Specify options for trnsformation images";
    public final static String TTIP_TUMBNAILSOPTION = "Specify thumbnails panel options";
    public final static String TTIP_MISCELLANEOUS = "Specify misc options concerning layout";
    public final static String TTIP_MAIN_IFD = "Main image IFD";
    public final static String TTIP_THUMB_IFD = "Thumbnail image IFD";
    public final static String TTIP_PICTURE_INFO = "[Picture info]";
    public final static String TTIP_CAMERA_INFO = "[Camera info]";
    public final static String TTIP_DIAG_INFO = "[Diag info]";
    public final static String TTIP_HEAP = "CIFF Heap";
    public final static String TTIP_COLLECTTAB = "Use it to navigate through your selection structure";
    public final static String TTIP_BROWSETAB = "Use it to navigate through your directory structure";
    public final static String TTIP_COLLECTLIST = "Use it to place your selection";
    public final static String TTIP_IMAGETAB = "Use it to see original sized image";
    public final static String TTIP_DIRECTORYTAB = "Use it to navigate through your directory structure";
    public final static String TTIP_ALBUM = "Viewing and creation photo albums";
    public final static String TTIP_ALBUMTAB = "Use it to view content of your photo albums";
    public final static String TTIP_ALBUMOPTIONS = "Setting album options, includimg database settings";
    public final static String TTIP_PLUGINOPTIONS = "Adding, editing, and removing plug-ins";
    public final static String TTIP_WEBPUBLISH = "Web root and Ftp settings";
    public final static String TTIP_ADDTRANSFORMEDTOSEL = "Check it, if you'd like to add a transformed image to selection";
    public final static String TTIP_CREATEALBUMINCL = "Check it, if the new created album has to be included to selected";
    public final static String TTIP_GENERALPROPS = "Use it to get general information about properties requested component";
    public final static String TTIP_DETAILSPROPS = "Use it to get deeply in properties of requested component";
    public final static String TAB_COLLECTION = "Selection";
    public final static String TAB_DIRECTORY = "Directory";
    public final static String TAB_IMAGE = "Image";
    public final static String TAB_THUMBNAILS = "Thumbnails";
    public final static String TAB_RENAME = "Rename";
    public final static String TAB_TRANSFORM = "Transform";
    public final static String TAB_BROWSE = "Browse";
    public final static String TAB_MISCELLANEOUS = "Miscellaneous";
    public final static String TAB_MAIN_IFD = "Main";
    public final static String TAB_THUMBNAIL = "Thumbnail";
    public final static String TAB_PICTURE_INFO = "Picture";
    public final static String TAB_CAMERA = "Camera";
    public final static String TAB_DIAGNOSTIC = "Diagnostic";
    public final static String TAB_HEAP = "Heap";
    public final static String TAB_ALBUM = "Album";
    public final static String TAB_PLUGIN = "Plug-ins";
    public final static String TAB_WEBPUBLISH = "WebPublishing";
    public final static String TAB_GENERAL = "General";
    public final static String TAB_DETAILS = "Details";
    public final static String URL_HELP = "./R-PhotoOrganizer.html";
	public final static String TMPL_NOPUBLISHTEMPLATE = "<html>"
		+ "<body bgcolor=\"#F1D0F2\" link=\"#0000FF\" vlink=\"#800080\">"
		+ "<p align=\"center\"><h2>No publishing template HTML defined</h2></p>"
		+ "<p><small><strong>Open Settings/WebPublishing and check template location.</stron></small></p>"
		+ "<!--!%loop-->"
		+ "<a href=\"!%webp!%tnof\"><img src=\"!%tnfn\" alt=\"!%tntt\" border=0 style=\"border: 0px none\"></a><br>"
		//+ "<!--!%tn+-->"
		+ "<!--!%endl-->"
		+ "</body>"
		+ "</html>";
    public final static String EXT_HTML = ".html";
    public final static String EXT_JPEG = "jpeg";
    public final static String EXT_TIFF = "tiff";
    public final static String EXT_BMP  = "bmp";
    public final static String EXT_GIF  = ".gif";
    public final static String IMG_LOGO = "logo.jpg";
    public final static String IMG_CHANGE_DRV = "changedrive.jpg";
    public final static String IMG_PHOTOORG = "photoorganizer.jpg";
    public final static String IMG_READCF = "readcf.jpg";
    public final static String NO = "no";
    public final static String YES = "yes";
    public final static Integer I_YES = new Integer(1);
    public final static Integer I_NO = new Integer(0);
    public final static int I_FLASH_DELAY = 8*1000;

    public final static int CTRL_VERT_SIZE = 20;
    public final static int CTRL_VERT_GAP = 4;
    public final static int CTRL_HORIS_INSET = 8;
    public final static int CTRL_HORIZ_GAP = 8;
    public final static java.awt.Dimension MIN_PANEL_DIMENSION = new java.awt.Dimension(40, 20);
}