/* Quat - A 3D fractal generation program */ 
/* Copyright (C) 1997,98 Dirk Meyer */ 
/* (email: dirk.meyer@studbox.uni-stuttgart.de) */ 
/* mail:  Dirk Meyer */ 
/*        Marbacher Weg 29 */ 
/*        D-71334 Waiblingen */ 
/*        Germany */ 
/* */ 
/* This program is free software; you can redistribute it and/or */ 
/* modify it under the terms of the GNU General Public License */ 
/* as published by the Free Software Foundation; either version 2 */ 
/* of the License, or (at your option) any later version. */ 
/* */ 
/* This program is distributed in the hope that it will be useful, */ 
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */ 
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */ 
/* GNU General Public License for more details. */ 
/* */ 
/* You should have received a copy of the GNU General Public License */ 
/* along with this program; if not, write to the Free Software */ 
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */ 
 
#include <qpainter.h>
#include <qcolor.h>

#include "colors.h"
#include "ColorPreview.h"

//#include <stdio.h>

ColorPreview::ColorPreview(QWidget *parent=0, const char *name=0)
   :QWidget(parent, name)
{
   len_x = 390; len_y = 20;
   image.create(len_x, len_y, 32, 0, QImage::IgnoreEndian);
   pixmap = new QPixmap(len_x, len_y, -1);
}

void ColorPreview::Update(struct realpal_struct *pal, int idx)
{
   bool zero;
   int i, j;
   QPainter painter;
   float BBuf, CBuf;
   unsigned char col[3];
   uint *p;
//   QRect qr(0,0,len_x,len_y);
//   QPaintEvent qp(qr);
   float offs, weightsum;

   pixmap->fill(QColor(255, 255, 255));
   painter.begin(pixmap);
   CalcWeightsum(pal);
   zero = FALSE;
   for (i=0; i<pal->colnum; i++) if (pal->cols[i].weight == 0) zero = TRUE;
   if (zero) painter.drawText(5,14, "A weight is zero!", 17);
   else
   {
      BBuf = (float)1;
      for (i=1; i<len_x-1; i++)
      {
         CBuf = ((float)i-1)/((float)len_x-2);
         PixelvalueTrueMode(0, 0, 255, 255, 255, pal, &col[0], &CBuf, &BBuf);
         for (j=1; j<len_y-1; j++)
         {
            p = (uint *)image.scanLine(j) + i;
            *p = qRgb(col[0], col[1], col[2]); 
         }
      }
      pixmap->convertFromImage(image, 0);
      painter.drawRect(0, 0, len_x, len_y);
   }
   offs = 0;weightsum = 0;
   for (i=0; i<pal->colnum; i++) weightsum += pal->cols[i].weight;
   for (i=0; i<idx-1; i++) offs += pal->cols[i].weight;
   painter.setPen(QColor(0, 0, 0));
   painter.drawRect((int)(offs/weightsum*(float)(len_x-2)+0.5)+1, 1,
      (int)((pal->cols[idx-1].weight)/weightsum*(float)(len_x-2)+0.5), len_y-2);
   painter.end();
//   paintEvent(&qp);
   repaint(FALSE);
}

void ColorPreview::paintEvent(QPaintEvent *QP)
{
   QPainter painter(this);

   painter.setClipRect(QP->rect());
   painter.drawPixmap(0, 0, *pixmap, 0, 0, -1, -1);
   painter.end(); painter.flush();
}
