#include <qwidget.h>
#include <qstring.h>
#include <qevent.h>
#include <qpixmap.h>
#include <qimage.h>

class JuliaPreview : public QWidget
{
   Q_OBJECT
public:
   JuliaPreview(QWidget *parent=0, const char *name=0);
   void Coo2C(int x, int y, double *cx, double *cy);
   static int QT_putline2(long x1, long x2, long xres, int y, unsigned char *Buf, int whichbuf);
   static int QT_update_bitmap2(long x1, long x2, long xres, int y, unsigned char *Buf, int which);
   static void QT_eol2(int line);
   QPixmap *Pixmap;
   QImage *Image;
public slots:
   void CalcImage2D();
   void CalcImage3D();
   void setOwnView(bool);
   void setCx(QString);
   void setCy(QString);
   void setCk(QString);
   void setCl(QString);
   void setBailout(QString);
   void setLvalue(QString);
   void setKvalue(int);
   void setMaxiter(QString);
   void setFormula(int);
protected:
   void paintEvent(QPaintEvent *);
private:
   int CalcJPixel(int x, int y);
   void CheckUpdate();
   bool updated, is3D, ownView;
   bool pic_ownView;
   double cx, cy, ck, cl, Bailout, LValue, KValue;
   int Maxiter, Formula;
   double pic_cx, pic_cy, pic_ck, pic_cl, pic_Bailout, pic_LValue, pic_KValue;
   int pic_Maxiter, pic_Formula;
   double len_x, len_y;
   double julia_x, julia_y, julia_lx, julia_ly;
};

