// videotestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "videotest.h"
#include "videotestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define COMPRESS    1
#define DECOMPRESS  2

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
    CAboutDlg();

// Dialog Data
    //{{AFX_DATA(CAboutDlg)
    enum { IDD = IDD_ABOUTBOX };
    //}}AFX_DATA

    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CAboutDlg)
    protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    //}}AFX_VIRTUAL

// Implementation
protected:
    //{{AFX_MSG(CAboutDlg)
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
    //{{AFX_DATA_INIT(CAboutDlg)
    //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CAboutDlg)
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
    //{{AFX_MSG_MAP(CAboutDlg)
        // No message handlers
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVideotestDlg dialog

CVideotestDlg::CVideotestDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CVideotestDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CVideotestDlg)
    m_strRecvDstIP = _T("10.110.0.11");
    m_sRecvDstPort = 3000;
    m_sRecvSrcPort = 4000;
    m_sSendDstPort = 4000;
    m_sSendSrcPort = 3000;
    m_strRecvSrcIP = _T("10.110.0.11");
    m_strSendDstIP = _T("10.110.0.11");
    m_strSendSrcIP = _T("10.110.0.11");
    //}}AFX_DATA_INIT
    // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
    m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

    sockRtp = INVALID_SOCKET;
}

void CVideotestDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CVideotestDlg)
    DDX_Control(pDX, IDC_NETVIDEO, m_netvideo);
    DDX_Control(pDX, IDC_NETVIDEO2, m_netvideo2);
    DDX_Text(pDX, IDC_EDIT_RECV_DST_IP, m_strRecvDstIP);
    DDX_Text(pDX, IDC_EDIT_RECV_DST_PORT, m_sRecvDstPort);
    DDX_Text(pDX, IDC_EDIT_RECV_SRC_PORT, m_sRecvSrcPort);
    DDX_Text(pDX, IDC_EDIT_SEND_DST_PORT, m_sSendDstPort);
    DDX_Text(pDX, IDC_EDIT_SEND_SRC_PORT, m_sSendSrcPort);
    DDX_Text(pDX, IDC_EDIT_RECV_SRC_IP, m_strRecvSrcIP);
    DDX_Text(pDX, IDC_EDIT_SEND_DST_IP, m_strSendDstIP);
    DDX_Text(pDX, IDC_EDIT_SEND_SRC_IP, m_strSendSrcIP);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVideotestDlg, CDialog)
    //{{AFX_MSG_MAP(CVideotestDlg)
    ON_WM_SYSCOMMAND()
    ON_WM_PAINT()
    ON_WM_QUERYDRAGICON()
    ON_WM_CLOSE()
    ON_BN_CLICKED(ID_MAX, OnMax)
    ON_BN_CLICKED(ID_STD, OnStd)
    ON_BN_CLICKED(ID_STARTSEND, OnStartsend)
    ON_BN_CLICKED(ID_STOPSEND, OnStopsend)
    ON_BN_CLICKED(ID_STARTRECV, OnStartrecv)
    ON_BN_CLICKED(ID_STOPRECV, OnStoprecv)
	ON_BN_CLICKED(ID_FULL_SCREEN, OnFullScreen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVideotestDlg message handlers

BOOL CVideotestDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    // Add "About..." menu item to system menu.

    // IDM_ABOUTBOX must be in the system command range.
    ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
    ASSERT(IDM_ABOUTBOX < 0xF000);

    CMenu* pSysMenu = GetSystemMenu(FALSE);
    if (pSysMenu != NULL)
    {
        CString strAboutMenu;
        strAboutMenu.LoadString(IDS_ABOUTBOX);
        if (!strAboutMenu.IsEmpty())
        {
            pSysMenu->AppendMenu(MF_SEPARATOR);
            pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
        }
    }

    // Set the icon for this dialog.  The framework does this automatically
    //  when the application's main window is not a dialog
    SetIcon(m_hIcon, TRUE);         // Set big icon
    SetIcon(m_hIcon, FALSE);        // Set small icon
    
    // TODO: Add extra initialization here
    //this->SetWindowPos(NULL,0,0,1024,768,SWP_SHOWWINDOW);
    //m_netvideo.SetWindowPos(NULL,0,0,1000,700,SWP_NOMOVE);

    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVideotestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
    if ((nID & 0xFFF0) == IDM_ABOUTBOX)
    {
        CAboutDlg dlgAbout;
        dlgAbout.DoModal();
    }
    else
    {
        CDialog::OnSysCommand(nID, lParam);
    }
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVideotestDlg::OnPaint() 
{
    if (IsIconic())
    {
        CPaintDC dc(this); // device context for painting

        SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

        // Center icon in client rectangle
        int cxIcon = GetSystemMetrics(SM_CXICON);
        int cyIcon = GetSystemMetrics(SM_CYICON);
        CRect rect;
        GetClientRect(&rect);
        int x = (rect.Width() - cxIcon + 1) / 2;
        int y = (rect.Height() - cyIcon + 1) / 2;

        // Draw the icon
        dc.DrawIcon(x, y, m_hIcon);
    }
    else
    {
        CDialog::OnPaint();
    }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVideotestDlg::OnQueryDragIcon()
{
    return (HCURSOR) m_hIcon;
}


void CVideotestDlg::OnClose() 
{
    CDialog::OnClose();
}

void CVideotestDlg::OnMax() 
{
    SetWindowPos(NULL,0,0,800,600,SWP_SHOWWINDOW);      
    m_netvideo.SetWindowPos(NULL,10,30,550,480,SWP_SHOWWINDOW);     
    m_netvideo2.SetWindowPos(NULL,550,400,800,600,SWP_SHOWWINDOW);      
    
}

void CVideotestDlg::OnStd() 
{
    SetWindowPos(NULL,0,0,320,240,SWP_SHOWWINDOW);  
    m_netvideo.SetWindowPos(NULL,10,30,250,200,SWP_SHOWWINDOW);     
    m_netvideo2.SetWindowPos(NULL,250,150,320,240,SWP_SHOWWINDOW);  
}

void CVideotestDlg::OnStartsend() 
{
    UpdateData(TRUE);

    if( ! m_netvideo2.HaveVideoCapture() )
    {
        AfxMessageBox("Have no capture device!");
        return;
    }

    m_netvideo2.SetLanguageVersion(2); //English
    m_netvideo2.SetUserName("Who am i"); 

    m_netvideo2.SetBandwidth(400000, COMPRESS );    
    //m_netvideo2.SetSendFrameRate(10);

	m_netvideo2.SetVideoInFormat("CIF");
	m_netvideo2.SetVideoOutFormat("CIF");

    BOOL bRet = m_netvideo2.InitCapture(0); 
    if( bRet == false )
    {
        int nErr = m_netvideo2.GetErrorID();
        m_netvideo2.GetErrorMessage(nErr);
        return;
    }

    m_netvideo2.SetLocalIPAddress( (LPCTSTR)m_strSendSrcIP, m_sSendSrcPort );
    sockRtp = m_netvideo2.SetRemoteIPAddress( (LPCTSTR)m_strSendDstIP, m_sSendDstPort,sockRtp);
    bRet = m_netvideo2.SendVideo(); 
    if( bRet == false )
    {
        int nErr = m_netvideo2.GetErrorID();
        m_netvideo2.GetErrorMessage(nErr);
        return;
    }
}

void CVideotestDlg::OnStopsend() 
{
    m_netvideo2.StopSend();
    m_netvideo2.CloseCapture();
}

void CVideotestDlg::OnStartrecv() 
{
    UpdateData(TRUE);

    m_netvideo .SetBandwidth(400000, DECOMPRESS);
    //m_netvideo .SetSendFrameRate(10);

	m_netvideo.SetVideoInFormat("CIF"); 
	m_netvideo.SetVideoOutFormat("CIF");

    m_netvideo.SetMulticastIPAddress("225.0.0.1", 30000 );

    m_netvideo.SetLocalIPAddress( (LPCTSTR)m_strRecvSrcIP, m_sRecvSrcPort );
    sockRtp = m_netvideo.SetRemoteIPAddress( (LPCTSTR)m_strRecvDstIP, m_sRecvDstPort,sockRtp );
    m_netvideo.RecvVideo();
    
}

void CVideotestDlg::OnStoprecv() 
{
    m_netvideo.StopRecv();
}

void CVideotestDlg::OnFullScreen() 
{
    m_netvideo.ShowFullScreen();
}

BOOL CVideotestDlg::PreTranslateMessage(MSG* pMsg) 
{
    if(pMsg->message == WM_KEYDOWN)
    {
        switch(pMsg->wParam)
        {
        case VK_RETURN://λس
            return TRUE;
        case VK_ESCAPE://Esc
            return TRUE;
        }
    }
	
	return CDialog::PreTranslateMessage(pMsg);
}
