// WinPlot3D.cpp : implementation of the WinPlot3D class.
// Applies Plot3D for Windows 95/NT
//

#include "stdafx.h"
#include "WinPlot3D.h"

// -------------------------------------------------------------------
// common OnDraw() routine
// pWnd - pointer to the window to be redrawn
// fn - filepath of draw commands
// pDC - pointer to device context
void WinOnDraw(CWnd* pWnd,char* fn,CDC* pDC)
{
	FILE* fh;
	char ReadBuf[100];
	char TextBuf[100];
	char FontNameBuf[100];
	int	is_color=0,xv,yv,it1,it2;
	char* pStr;
	long color=1, ltemp, ltemp2, ltemp3;

	CWaitCursor wait;	// put up hour glass

	// get window size
	RECT rect;
	pWnd->GetClientRect(&rect);
	CSize wsize = CSize(rect.right-rect.left, rect.bottom-rect.top);

	// rescale for printer
	if (pDC->IsPrinting())
	{
		CWnd* pdcWnd = pDC->GetWindow();
		if (pdcWnd)
		{
			pdcWnd->GetClientRect(&rect);
			wsize = CSize(rect.right-rect.left, rect.bottom-rect.top);
		}
	}

	// set mapping mode and view port extents
	pDC->SetMapMode(MM_ISOTROPIC);
	pDC->SetWindowOrg(0,wsize.cy);
	pDC->SetWindowExt(wsize);
	pDC->SetViewportExt(wsize);
	pDC->ScaleViewportExt(1,1,-1,1);	// invert y coordinate

	// open the drawing command file
	fh = fopen(fn,"r");
	if (fh==0) return;
	memset(ReadBuf,0,sizeof(ReadBuf));
	fgets(ReadBuf,sizeof(ReadBuf)-1,fh);
	if (memcmp(ReadBuf,PLOT3D_FILE_SIG,strlen(PLOT3D_FILE_SIG)) != 0) { fclose(fh); return; }
	pStr = &ReadBuf[strlen(PLOT3D_FILE_SIG)+1];
	if (memcmp(pStr,PLOT3D_COLOR_MODE,strlen(PLOT3D_COLOR_MODE)) == 0) is_color=1;

	// interpret drawing commands from file
	while( !feof(fh) )
	{
		memset(ReadBuf,0,sizeof(ReadBuf));
		fgets(ReadBuf,sizeof(ReadBuf)-1,fh);
		if (ReadBuf[0] == 'S')
		{
			// "S=%ld,%ld"  background,pencolor
			if (sscanf(&ReadBuf[2],"%ld,%ld",&ltemp, &ltemp2) != EOF)
			{
				// clear screen to background color
				RECT rect;
				pWnd->GetClientRect(&rect);
				pDC->FillSolidRect(&rect,ltemp);

				// set pen color
				CPen* pOldPen;
				CPen Pen(PS_SOLID,1,ltemp2);		// construct a pen with the desired color
		        pOldPen = pDC->SelectObject(&Pen);	// select the pen into the device context
			}
		}
		else if (ReadBuf[0] == 'C')	// color
		{
			// "C=%-12d\n"
			if (sscanf(&ReadBuf[2],"%d",&ltemp) != EOF) color = ltemp;
		}
		else if (ReadBuf[0] == 'M')	// move
		{
			// "M=%6d,%6d\n"
			if (sscanf(&ReadBuf[2],"%6d,%6d",&it1,&it2) != EOF)
			{
				xv = it1;
				yv = it2;
				pDC->MoveTo(xv,yv);
			}
		}
		else if (ReadBuf[0] == 'P')	// set pixel
		{
			// "P=%6d,%6d,%12ld\n"
			if (sscanf(&ReadBuf[2],"%6d,%6d,%ld",&it1,&it2,&ltemp) != EOF)
			{
				xv = it1;
				yv = it2;
				pDC->SetPixel(xv,yv,ltemp);
			}
		}
		else if (ReadBuf[0] == 'D')	// draw
		{
			// "D=%6d,%6d\n"
			if (sscanf(&ReadBuf[2],"%6d,%6d",&it1,&it2) != EOF)
			{
				xv = it1;
				yv = it2;

				if (is_color)
				{
					CPen* pOldPen;
					CPen Pen(PS_SOLID,1,color);	// construct a pen with the desired color
			        pOldPen = pDC->SelectObject(&Pen);	// select the pen into the device context
					pDC->LineTo(xv,yv);		   	// draw the colored line
			        pDC->SelectObject(pOldPen);	// restore the original pen
				}
				else
				{
					// just draw the line if in monochrome mode
					pDC->LineTo(xv,yv);
				}
			}
		}
		else if (ReadBuf[0] == 'T')	// text
		{
			// "T=%6d,%6d,%ld,%ld,%ld,%s,%s\n",
			if (sscanf(&ReadBuf[2],"%6d,%6d,%ld,%ld,%ld,%s %s",&it1,&it2,&ltemp,&ltemp2,&ltemp3,FontNameBuf,TextBuf) != EOF)
			{
				xv = it1;
				yv = it2;

				// setup font info
				LOGFONT logFont;
				memset((char*)&logFont,0,sizeof(logFont));
				strcpy(logFont.lfFaceName,FontNameBuf);
				logFont.lfHeight = ltemp;
				logFont.lfWidth  = ltemp2;
				logFont.lfEscapement = ltemp3;
		
				// create a rotated font
				CFont rotFont;
				rotFont.CreateFontIndirect(&logFont);
		
				// output the text
				pDC->SelectObject(rotFont);
				pDC->TextOut(xv,yv,CString(TextBuf));
			}
		}

	} // while
	fclose(fh);
}

/*	<><><><><><><><><><><><><>  WinPlot3D.cpp  <><><><><><><><><><><><><><> */
