// DlgEditPlotF.cpp : implementation file
//

#include "stdafx.h"
#include "Plot3DF.h"
#include "Win3DF.h"
#include "DlgEditPlotF.h"
#include "DlgHelpParm.h"
#include "DlgNewSurface.h"
#include "DlgSyntax.h"
#include "..\Common\WinPlotReg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// TODO ###
//   1) Start plotting does not remove dialog image

/////////////////////////////////////////////////////////////////////////////
// DlgEditPlotF dialog


DlgEditPlotF::DlgEditPlotF(CWnd* pParent /*=NULL*/)
	: CDialog(DlgEditPlotF::IDD, pParent)
{
	m_pPlotCalc = 0;
	//{{AFX_DATA_INIT(DlgEditPlotF)
	//}}AFX_DATA_INIT
	m_surface_name = DEFAULT_SURFACE;
	// other data is iniitalized in OnInitDialog()
}

void DlgEditPlotF::SetDefaults()
{
 	UpdateData(FALSE);	// load these values into the dialog
	// Note: don't set m_surface_name
	m_sPlotEquation = _T("2*sin(x*y/4)");
	m_sC1 = _T("1");
	m_sC2 = _T("1");
	m_sC3 = _T("1");
	m_sC4 = _T("1");
	m_sC5 = _T("1");
	m_sC6 = _T("1");
	m_sC7 = _T("1");
	m_sC8 = _T("1");
	m_zrotate = 70.0;
	m_xytilt  = 60.0;
	m_line_color = RGB(0,0,0);	// black
	m_background_color = RGB(255,255,255);	// white
	m_is_color = FALSE;
	m_remove_hidden_lines = TRUE;
	m_scale = 1.0;
	m_show_axis = FALSE;
	m_sEquationStatus = _T("");
	m_is_equation_ok = 0;
	m_xmin = -10.0;
	m_xmax =  10.0;
	m_ymin = -10.0;
	m_ymax =  10.0;
	m_zmin = -10.0;
	m_zmax =  10.0;
	m_nzplanes = 50;
	m_sphere_radius  = 12.0;
	m_sphere_xcenter = 0.0;
	m_sphere_ycenter = 0.0;
	m_sphere_zcenter = 0.0;
	m_use_sphere_range = 0;
	m_plot_mode = 0;
	m_is_clip_inverted = 0;
	m_clip_mode = CLIP_NONE;
	m_is_clip_inverted = FALSE;
}

void DlgEditPlotF::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(DlgEditPlotF)
	DDX_Control(pDX, IDC_COMBO_VIEW_PROGRAM, m_ViewProgram);
	DDX_Control(pDX, IDC_COMBO_LIST_SURFACE, m_list_surfaces);
	DDX_Text(pDX, IDC_EDIT_XMIN, m_xmin);
	DDX_Text(pDX, IDC_EDIT_XMAX, m_xmax);
	DDX_Text(pDX, IDC_EDIT_YMIN, m_ymin);
	DDX_Text(pDX, IDC_EDIT_YMAX, m_ymax);
	DDX_Text(pDX, IDC_EDIT_ZMIN, m_zmin);
	DDX_Text(pDX, IDC_EDIT_ZMAX, m_zmax);
	DDX_Text(pDX, IDC_EDIT_ZROTATE, m_zrotate);
	DDX_Text(pDX, IDC_EDIT_XYTILT, m_xytilt);
	DDX_Check(pDX, IDC_CHECK_IS_COLOR, m_is_color);
	DDX_Check(pDX, IDC_CHECK_HIDDEN_LINE_REMOVAL, m_remove_hidden_lines);
	DDX_Text(pDX, IDC_EDIT_SCALE, m_scale);
	DDV_MinMaxDouble(pDX, m_scale, 1.e-002, 1.);
	DDX_Text(pDX, IDC_EDIT_NZPLINES, m_nzplanes);
	DDV_MinMaxUInt(pDX, m_nzplanes, 2, 1000);
	DDX_Text(pDX, IDC_SPHERE_RADIUS, m_sphere_radius);
	DDX_Text(pDX, IDC_SPHERE_XCENTER, m_sphere_xcenter);
	DDX_Text(pDX, IDC_SPHERE_YCENTER, m_sphere_ycenter);
	DDX_Text(pDX, IDC_SPHERE_ZCENTER, m_sphere_zcenter);
	DDX_Check(pDX, IDC_CHECK_INVERT_CLIPPING, m_is_clip_inverted);
	DDX_Text(pDX, IDC_EDIT_C1, m_sC1);
	DDX_Text(pDX, IDC_EDIT_C2, m_sC2);
	DDX_Text(pDX, IDC_EDIT_C3, m_sC3);
	DDX_Text(pDX, IDC_EDIT_C4, m_sC4);
	DDX_Text(pDX, IDC_EDIT_C5, m_sC5);
	DDX_Text(pDX, IDC_EDIT_C6, m_sC6);
	DDX_Text(pDX, IDC_EDIT_C7, m_sC7);
	DDX_Text(pDX, IDC_EDIT_C8, m_sC8);
	DDX_Text(pDX, IDC_EDIT_EQUATION_STATUS, m_sEquationStatus);
	DDX_Text(pDX, IDC_EDIT_PLOT_EQUATION, m_sPlotEquation);
	DDX_Check(pDX, IDC_CHECK_SHOW_AXIS, m_show_axis);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(DlgEditPlotF, CDialog)
	//{{AFX_MSG_MAP(DlgEditPlotF)
	ON_BN_CLICKED(IDC_RADIO_RANGE_CUBE, OnRadioRangeCube)
	ON_BN_CLICKED(IDC_RADIO_RANGE_SPHERE, OnRadioRangeSphere)
	ON_BN_CLICKED(IDC_RADIO_CROSS_SECTIONS, OnRadioCrossSections)
	ON_BN_CLICKED(IDC_RADIO_PARAMETRIC, OnRadioParametric)
	ON_BN_CLICKED(IDC_BUTTON_LINE_COLOR, OnButtonLineColor)
	ON_BN_CLICKED(IDC_BUTTON_BACKGROUND_COLOR, OnButtonBackgroundColor)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_PARM_HELP, OnParmHelp)
	ON_BN_CLICKED(IDC_PARM_DEFAULTS, OnParmDefaults)
	ON_BN_CLICKED(IDC_RADIO_CLIP_CUBE, OnRadioClipCube)
	ON_BN_CLICKED(IDC_RADIO_CLIP_NONE, OnRadioClipNone)
	ON_BN_CLICKED(IDC_RADIO_CLIP_SPHERE, OnRadioClipSphere)
	ON_BN_CLICKED(IDC_RADIO_CLIP_USER, OnRadioClipUser)
	ON_BN_CLICKED(IDC_BUTTON_TEST, OnButtonTest)
	ON_BN_CLICKED(IDC_BUTTON_NEW, OnButtonNew)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_CBN_DROPDOWN(IDC_COMBO_VIEW_PROGRAM, OnDropdownComboViewProgram)
	ON_CBN_SELCHANGE(IDC_COMBO_LIST_SURFACE, OnSelchangeComboListSurface)
	ON_BN_CLICKED(IDC_BUTTON_SYNTAX, OnButtonSyntax)
	ON_BN_CLICKED(IDC_BUTTON_SAVE, OnButtonSave)
	ON_BN_CLICKED(IDC_CANCEL, OnCancel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// if name is null, just save existing name
int DlgEditPlotF::SetSurfaceName(CString name)
{
	HKEY hkey = 0;

	if (OpenReg(PLOT_REGISTRY_HIVE,1,&hkey)!=0) return(1);
	if (!name.IsEmpty())
		m_surface_name = name;
	if (m_surface_name.IsEmpty()) m_surface_name = DEFAULT_SURFACE;
	SetRegStr(hkey,"CurrentSurface", m_surface_name);
	CloseReg(hkey);
	return(0);
}

// ------------------------------------------------------------------------
// get current surface name from regisitry
CString DlgEditPlotF::GetSurfaceName()
{
	HKEY hkey = 0;
	char TempBuf[200];
	CString name = DEFAULT_SURFACE;

	if (OpenReg(PLOT_REGISTRY_HIVE,1,&hkey)!=0) return(name);
	if (GetRegStr(hkey, "CurrentSurface", TempBuf,sizeof(TempBuf)) == 0)
		name = TempBuf;
	CloseReg(hkey);
	if (name.IsEmpty()) name = DEFAULT_SURFACE;
	return(name);
}

// ------------------------------------------------------------------------
void DlgEditPlotF::SaveToRegistry()
{
	HKEY hkey = 0;

	// save the current surface name
	SetSurfaceName();

	// open registry
	if (OpenReg(GetSurfaceRegPath(),1,&hkey)!=0) return;

	// save the surface parameters
 	UpdateData(TRUE);	// get values from dialog
 	SetRegStr   (hkey, "PlotEquation", m_sPlotEquation);
	SetRegStr   (hkey, "C1",	       m_sC1);
	SetRegStr   (hkey, "C2",	       m_sC2);
	SetRegStr   (hkey, "C3",	       m_sC3);
	SetRegStr   (hkey, "C4",	       m_sC4);
	SetRegStr   (hkey, "C5",	       m_sC5);
	SetRegStr   (hkey, "C6",	       m_sC6);
	SetRegStr   (hkey, "C7",	       m_sC7);
	SetRegStr   (hkey, "C8",	       m_sC8);
	SetRegDouble(hkey, "ZRotate",      m_zrotate);
	SetRegDouble(hkey, "XYTilt",       m_xytilt);
	SetRegLong  (hkey, "LineColor",    m_line_color);
	SetRegLong  (hkey, "BackgroundColor",  m_background_color);
	SetRegInt   (hkey, "ShowColor",    m_is_color);
	SetRegInt   (hkey, "RemoveHidden", m_remove_hidden_lines);
	SetRegDouble(hkey, "PlotScale",    m_scale);
 	SetRegInt   (hkey, "ShowAxis",     m_show_axis);
	SetRegDouble(hkey, "XMin",         m_xmin);
	SetRegDouble(hkey, "XMax",         m_xmax);
	SetRegDouble(hkey, "YMin",         m_ymin);
	SetRegDouble(hkey, "YMax",         m_ymax);
	SetRegDouble(hkey, "ZMin",         m_zmin);
	SetRegDouble(hkey, "ZMax",         m_zmax);
	SetRegInt   (hkey, "nZPlanes",     m_nzplanes);
	SetRegInt   (hkey, "UseSpherical", m_use_sphere_range);
	SetRegDouble(hkey, "SphereXCenter",m_sphere_xcenter);
	SetRegDouble(hkey, "SphereYCenter",m_sphere_ycenter);
	SetRegDouble(hkey, "SphereZCenter",m_sphere_zcenter);
	SetRegDouble(hkey, "SphereRadius", m_sphere_radius);
	SetRegInt   (hkey, "PlotMode",     m_plot_mode);
	SetRegInt   (hkey, "ClipMode",     (int)m_clip_mode);
	SetRegInt   (hkey, "InvertClip",   m_is_clip_inverted);
	CloseReg(hkey);
}

/////////////////////////////////////////////////////////////////////////////
int  DlgEditPlotF::GetFromRegistry()
{
	HKEY hkey = 0;
	char TempBuf[200];


	// get the current surface name
	m_surface_name = GetSurfaceName();

	// open registry
	if (OpenReg(GetSurfaceRegPath(),1,&hkey)!=0) return(1);

	// get surface parameters
 	UpdateData(FALSE);	// load these values into the dialog
	if(GetRegStr(hkey, "PlotEquation", TempBuf,sizeof(TempBuf)) == 0) m_sPlotEquation = TempBuf;
	if(GetRegStr(hkey, "C1", TempBuf,sizeof(TempBuf)) == 0)  m_sC1 = TempBuf;
	if(GetRegStr(hkey, "C2", TempBuf,sizeof(TempBuf)) == 0)  m_sC2 = TempBuf;
	if(GetRegStr(hkey, "C3", TempBuf,sizeof(TempBuf)) == 0)  m_sC3 = TempBuf;
	if(GetRegStr(hkey, "C4", TempBuf,sizeof(TempBuf)) == 0)  m_sC4 = TempBuf;
	if(GetRegStr(hkey, "C5", TempBuf,sizeof(TempBuf)) == 0)  m_sC5 = TempBuf;
	if(GetRegStr(hkey, "C6", TempBuf,sizeof(TempBuf)) == 0)  m_sC6 = TempBuf;
	if(GetRegStr(hkey, "C7", TempBuf,sizeof(TempBuf)) == 0)  m_sC7 = TempBuf;
	if(GetRegStr(hkey, "C8", TempBuf,sizeof(TempBuf)) == 0)  m_sC8 = TempBuf;
	GetRegDouble(hkey, "ZRotate",      &m_zrotate);
	GetRegDouble(hkey, "XYTilt",       &m_xytilt);
	GetRegLong  (hkey, "LineColor",    (long*)&m_line_color);
	GetRegLong  (hkey, "BackgroundColor",  (long*)&m_background_color);
	GetRegInt   (hkey, "ShowColor",    &m_is_color);
	GetRegInt   (hkey, "RemoveHidden", &m_remove_hidden_lines);
	GetRegDouble(hkey, "PlotScale",    &m_scale);
 	GetRegInt   (hkey, "ShowAxis",     &m_show_axis);
	GetRegDouble(hkey, "XMin",         &m_xmin);
	GetRegDouble(hkey, "XMax",         &m_xmax);
	GetRegDouble(hkey, "YMin",         &m_ymin);
	GetRegDouble(hkey, "YMax",         &m_ymax);
	GetRegDouble(hkey, "ZMin",         &m_zmin);
	GetRegDouble(hkey, "ZMax",         &m_zmax);
	GetRegInt   (hkey, "nZPlanes",     (int*)&m_nzplanes);
	GetRegInt   (hkey, "UseSpherical", &m_use_sphere_range);
	GetRegDouble(hkey, "SphereXCenter",&m_sphere_xcenter);
	GetRegDouble(hkey, "SphereYCenter",&m_sphere_ycenter);
	GetRegDouble(hkey, "SphereZCenter",&m_sphere_zcenter);
	GetRegDouble(hkey, "SphereRadius", &m_sphere_radius);
	GetRegInt   (hkey, "PlotMode",     &m_plot_mode);
	GetRegInt   (hkey, "InvertClip",   &m_is_clip_inverted);
	GetRegInt   (hkey, "ClipMode",     (int*)&m_clip_mode);
	CloseReg(hkey);
	m_plot_mode = 0; // cross section only
	if (m_plot_mode!=0 && m_plot_mode!=1) m_plot_mode = 0;
	if (m_clip_mode<CLIP_NONE || m_clip_mode>LAST_CLIP_VALUE) m_clip_mode = CLIP_NONE;
	return(0);
}

// ------------------------------------------------------
// create a string path for the plot registry
CString DlgEditPlotF::GetPlotRegPath()
{
	CString sHive = PLOT_REGISTRY_HIVE;
	sHive += "\\";
	sHive += SURFACE_HIVE_SUBDIR;
	return(sHive);
}

// ------------------------------------------------------
// create a string path for the suface registry
CString DlgEditPlotF::GetSurfaceRegPath()
{
	CString sHive = PLOT_REGISTRY_HIVE;
	sHive += "\\";
	sHive += SURFACE_HIVE_SUBDIR;
	sHive += "\\";
	if (m_surface_name.IsEmpty()) m_surface_name = DEFAULT_SURFACE;
	sHive += m_surface_name;
	return(sHive);
}

// ------------------------------------------------------
void DlgEditPlotF::UpdateDialogState()
{
 	UpdateData(FALSE); // load values into dialog
	// set color buttons
	CWnd* pWnd;
	RECT rect;
	pWnd = (CWnd *)GetDlgItem(IDC_STATIC_FG);
	if (pWnd)
	{
		pWnd->GetClientRect(&rect);
		pWnd->GetDC()->FillSolidRect(&rect,m_line_color);
		pWnd->Invalidate();
	}

	pWnd = (CWnd *)GetDlgItem(IDC_STATIC_BG);
	if (pWnd)
	{
		pWnd->GetClientRect(&rect);
		pWnd->GetDC()->FillSolidRect(&rect,m_background_color);
		pWnd->Invalidate();
	}

	// update surface name drop-down box
	HKEY hKey;
	char Buffer[200];
	int index;
	if (OpenReg(GetPlotRegPath(),0,&hKey) == 0)
	{
	 	m_list_surfaces.ResetContent();
		m_list_surfaces.SetCurSel(0);
		for (index=0;   ;index++)
		{
			if (EnumRegKey(hKey,index,Buffer,sizeof(Buffer))) break;
	 		m_list_surfaces.AddString(Buffer);
			if (stricmp(Buffer,(LPCTSTR)m_surface_name)!=0) continue;
			m_list_surfaces.SetCurSel(index);
		} // for
		m_list_surfaces.Invalidate();
		CloseReg(hKey);
	}

	// set radio buttons
	CButton	*pBtn;
	// cube range
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_RANGE_CUBE);
	if (pBtn) pBtn->SetCheck(!m_use_sphere_range);
	// shpere range
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_RANGE_SPHERE);
	if (pBtn) pBtn->SetCheck(m_use_sphere_range);
	// cross section
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_CROSS_SECTIONS);
	if (pBtn) pBtn->SetCheck(m_plot_mode==0);
	// parametric
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_PARAMETRIC);
	if (pBtn) pBtn->SetCheck(m_plot_mode);\

	// clipping radio buttions
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_CLIP_NONE);
	if (pBtn) pBtn->SetCheck(m_clip_mode==CLIP_NONE);
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_CLIP_CUBE);
	if (pBtn) pBtn->SetCheck(m_clip_mode==CLIP_CUBE);
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_CLIP_SPHERE);
	if (pBtn) pBtn->SetCheck(m_clip_mode==CLIP_SPHERE);
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_CLIP_USER);
	if (pBtn) pBtn->SetCheck(m_clip_mode==CLIP_USER);
}


// ------------------------------------------------------
// Attatch the calculator to the dialog
void DlgEditPlotF::AttachCalculator(PlotCalc* pPlotCalc)
{
	m_pPlotCalc = pPlotCalc;
}

/////////////////////////////////////////////////////////////////////////////
// DlgEditPlotF message handlers

void DlgEditPlotF::OnOK() 
{
	OnButtonTest();	// test equation before returning
	if (!m_is_equation_ok)
	{
		AfxMessageBox("Plot equation errors", MB_OK);
		return;
	}

	// save settings to windows registry
	SaveToRegistry();
	
	CDialog::OnOK();
}

// ------------------------------------------------------
void DlgEditPlotF::OnCancel() 
{
	CDialog::OnCancel();
}

// ------------------------------------------------------
BOOL DlgEditPlotF::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// initialize data
	SetDefaults();
	GetFromRegistry();
	// update dialog to reflect state
	UpdateDialogState();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// ------------------------------------------------------
void DlgEditPlotF::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotF::OnParmHelp() 
{
	CDlgHelpParm dlg;
	dlg.DoModal();
}

// ------------------------------------------------------
void DlgEditPlotF::OnButtonTest() 
{
	char buf[200];
	unsigned no;
	int rc, col;

	if (m_pPlotCalc==0) return;

	// update calculator - load constants and program
 	UpdateData(TRUE); // get values from dialog
 	col = m_pPlotCalc->LoadProgram((LPCTSTR)m_sPlotEquation,1,
			(LPCTSTR)m_sC1,(LPCTSTR)m_sC2,(LPCTSTR)m_sC3,(LPCTSTR)m_sC4,
			(LPCTSTR)m_sC5,(LPCTSTR)m_sC6,(LPCTSTR)m_sC7,(LPCTSTR)m_sC8);
	m_is_equation_ok = (col) ? 0 : 1;

	// show Status string
 	m_sEquationStatus = m_pPlotCalc->GetErrString();
 	SetDlgItemText(IDC_EDIT_EQUATION_STATUS,m_sEquationStatus);

 	// update view program combo box
 	m_ViewProgram.ResetContent();
 	for (no=0;  ;no++)
 	{
 		rc = m_pPlotCalc->GetProgramInst(no,buf);
 		if (rc != 0) break;
 		m_ViewProgram.AddString(buf);
 	}
}

// ------------------------------------------------------
void DlgEditPlotF::OnParmDefaults() 
{
	int rc;
	rc = AfxMessageBox("Reset to default values?", MB_OKCANCEL);
	if (rc != IDOK) return;
	SetDefaults();
	Invalidate();
}

// ------------------------------------------------------
void DlgEditPlotF::OnButtonLineColor() 
{
	CColorDialog dlg(m_line_color,CC_ANYCOLOR,this);
	if (dlg.DoModal() == IDOK)
	{
		m_line_color = dlg.GetColor();
		UpdateDialogState();
	}
}

// ------------------------------------------------------
void DlgEditPlotF::OnButtonBackgroundColor() 
{
	CColorDialog dlg(m_background_color,CC_ANYCOLOR,this);
	if (dlg.DoModal() == IDOK)
	{
		m_background_color = dlg.GetColor();
		UpdateDialogState();
	}
}

// ------------------------------------------------------
void DlgEditPlotF::OnButtonNew() 
{
	CDlgNewSurface dlg;
	if (dlg.DoModal() != IDOK) return;
	CString sNewName = dlg.GetNewName();

	HKEY hKey;
	char Buffer[200];
	int is_dup=0, index;

	// see if name already exists
	if (OpenReg(GetPlotRegPath(),0,&hKey)==0)
	{
		for (index=0; ;index++)
		{
			if (EnumRegKey(hKey,index,Buffer,sizeof(Buffer))) break;
			if (stricmp(Buffer,(LPCTSTR)sNewName)!=0) continue;
			is_dup = 1;
			break;
		} // for
		CloseReg(hKey);
	}
	if (is_dup)
	{
		sprintf(Buffer,"%s already exists", (LPCTSTR)sNewName );
		AfxMessageBox(Buffer, MB_OK);
		return;
	}

	// save data to registry
	m_surface_name = sNewName;
	SaveToRegistry();
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotF::OnButtonDelete() 
{
	int rc;
	CString msg;

	msg.Format("Delete %s surface?", (LPCTSTR)m_surface_name);
	if (AfxMessageBox((LPCTSTR)msg, MB_OKCANCEL) != IDOK) return;

	// delete surface registry info
	HKEY hKey;
	char Buffer[200];
	int index;
	if (OpenReg(GetSurfaceRegPath(),0,&hKey)==0)
	{
		// delete all registry values first
	 	for (index=0; ;index++)
	 	{
	 		if (EnumRegValue(hKey,index,Buffer,sizeof(Buffer))) break;
			rc = DelRegValue(hKey,Buffer);
	 	} // for
		CloseReg(hKey);
	}
	// delete registry key
	if (OpenReg(GetPlotRegPath(),0,&hKey)==0)
	{
		rc = DelRegKey(hKey,(LPCTSTR)m_surface_name);
		CloseReg(hKey);
	}

	// set current to first list item
	UpdateData(FALSE); // load values into dialog
	CString sNewName;
	m_list_surfaces.GetLBText(0,sNewName);
	if (sNewName==m_surface_name)
		m_list_surfaces.GetLBText(1,sNewName);
	// change to selected surface
	SetSurfaceName(sNewName);
	// get surface info from registry
	GetFromRegistry();
	// update the dialog
	UpdateDialogState();
	Invalidate();
}

// ------------------------------------------------------
void DlgEditPlotF::OnDropdownComboViewProgram() 
{
	OnButtonTest();	// test equation showing program
}

// ------------------------------------------------------
void DlgEditPlotF::OnSelchangeComboListSurface() 
{
	CString sNewName;
	int index;

 	UpdateData(TRUE); // get values from dialog
	index = m_list_surfaces.GetCurSel();
	m_list_surfaces.GetLBText(index,sNewName);
	if (sNewName.IsEmpty()) return;
	// save current surface
	SaveToRegistry();
	// change to selected surface
	SetSurfaceName(sNewName);
	// get surface info from registry
	GetFromRegistry();
	// update the dialog
	UpdateDialogState();
	Invalidate();
}

// ------------------------------------------------------
void DlgEditPlotF::OnRadioRangeCube() 
{
	m_use_sphere_range = 0;
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotF::OnRadioRangeSphere() 
{
	m_use_sphere_range = 1;
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotF::OnRadioCrossSections() 
{
	m_plot_mode = 0;
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotF::OnRadioParametric() 
{
	m_plot_mode = 1;
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotF::OnRadioClipCube() 
{
	m_clip_mode = CLIP_CUBE;
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotF::OnRadioClipNone() 
{
	m_clip_mode = CLIP_NONE;
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotF::OnRadioClipSphere() 
{
	m_clip_mode = CLIP_SPHERE;
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotF::OnRadioClipUser() 
{
	m_clip_mode = CLIP_USER;
	UpdateDialogState();
}

// ------------------------------------------------------
void DlgEditPlotF::OnButtonSyntax() 
{
	DlgSyntax dlg;
	dlg.DoModal();
}

// ------------------------------------------------------
void DlgEditPlotF::OnButtonSave() 
{
	SaveToRegistry();
	UpdateDialogState();
}

