// DlgWinResize.h : header file
// CAUTION! This must be included in only one file

/////////////////////////////////////////////////////////////////////////////
// DlgWinResize dialog

class DlgWinResize : public CDialog
{
// Construction
public:
	DlgWinResize(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(DlgWinResize)
	enum { IDD = IDD_WINDOW_RESIZE };
	UINT	m_CustomCols;
	UINT	m_CustomRows;
	//}}AFX_DATA

	enum SIZE_MODE {
		SIZE_NONE,
		SIZE_640x480,
		SIZE_800x600,
		SIZE_1024x768,
		SIZE_1280x1024,
		SIZE_CUSTOM
	};

	void SetCustom()
	{
		CButton	*pBtn;
		pBtn = (CButton *)GetDlgItem(IDC_RADIO_CUSTOM);
		if (pBtn) pBtn->SetCheck(1);
		pBtn = (CButton *)GetDlgItem(IDC_RADIO_640x480);
		if (pBtn) pBtn->SetCheck(0);
		pBtn = (CButton *)GetDlgItem(IDC_RADIO_800x600);
		if (pBtn) pBtn->SetCheck(0);
		pBtn = (CButton *)GetDlgItem(IDC_RADIO_1024x768);
		if (pBtn) pBtn->SetCheck(0);
		pBtn = (CButton *)GetDlgItem(IDC_RADIO_1280x1024);
		if (pBtn) pBtn->SetCheck(0);
	}

	BOOL IsSizeSet() { return(m_SizeMode != SIZE_NONE); }
	SIZE_MODE	m_SizeMode;
	UINT		m_WinRows;
	UINT		m_WinCols;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(DlgWinResize)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(DlgWinResize)
	afx_msg void OnRADIO1024x768();
	afx_msg void OnRADIO1280x1024();
	afx_msg void OnRADIO640x480();
	afx_msg void OnRADIO800x600();
	afx_msg void OnRadioCustom();
	virtual void OnOK();
	afx_msg void OnUpdateEditWincols();
	afx_msg void OnUpdateEditWinrows();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

/////////////////////////////////////////////////////////////////////////////
// DlgWinResize dialog


DlgWinResize::DlgWinResize(CWnd* pParent /*=NULL*/)
	: CDialog(DlgWinResize::IDD, pParent)
{
	//{{AFX_DATA_INIT(DlgWinResize)
	m_CustomCols = 640;
	m_CustomRows = 480;
	//}}AFX_DATA_INIT
	m_SizeMode = SIZE_CUSTOM;
	m_WinCols = 640;
	m_WinRows = 480;
}


void DlgWinResize::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(DlgWinResize)
	DDX_Text(pDX, IDC_EDIT_WINCOLS, m_CustomCols);
	DDX_Text(pDX, IDC_EDIT_WINROWS, m_CustomRows);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(DlgWinResize, CDialog)
	//{{AFX_MSG_MAP(DlgWinResize)
	ON_BN_CLICKED(IDC_RADIO_1024x768, OnRADIO1024x768)
	ON_BN_CLICKED(IDC_RADIO_1280x1024, OnRADIO1280x1024)
	ON_BN_CLICKED(IDC_RADIO_640x480, OnRADIO640x480)
	ON_BN_CLICKED(IDC_RADIO_800x600, OnRADIO800x600)
	ON_BN_CLICKED(IDC_RADIO_CUSTOM, OnRadioCustom)
	ON_EN_UPDATE(IDC_EDIT_WINCOLS, OnUpdateEditWincols)
	ON_EN_UPDATE(IDC_EDIT_WINROWS, OnUpdateEditWinrows)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// DlgWinResize message handlers

void DlgWinResize::OnRADIO640x480() 
{
	UpdateData(FALSE);
	m_SizeMode = SIZE_640x480;
	m_WinCols = 640;
	m_WinRows = 480;
}

void DlgWinResize::OnRADIO800x600() 
{
	UpdateData(FALSE);
	m_SizeMode = SIZE_800x600;
	m_WinCols = 800;
	m_WinRows = 600;
}

void DlgWinResize::OnRADIO1024x768() 
{
	UpdateData(FALSE);
	m_SizeMode = SIZE_1024x768;
	m_WinCols = 1024;
	m_WinRows = 768;
}

void DlgWinResize::OnRADIO1280x1024() 
{
	UpdateData(FALSE);
	m_SizeMode = SIZE_1280x1024;
	m_WinCols = 1280;
	m_WinRows = 1024;
}

void DlgWinResize::OnRadioCustom() 
{
	UpdateData(FALSE);
	m_SizeMode = SIZE_CUSTOM;
	// The rows/cols is not necessarily valid at this time
}

void DlgWinResize::OnOK() 
{
	UpdateData(TRUE);
	if (m_SizeMode == SIZE_CUSTOM)
	{
		m_WinCols = m_CustomCols;
		m_WinRows = m_CustomRows;
	}
	CDialog::OnOK();
}

BOOL DlgWinResize::OnInitDialog() 
{
	CDialog::OnInitDialog();
	SetCustom();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void DlgWinResize::OnUpdateEditWincols() 
{
	SetCustom();
	m_SizeMode = SIZE_CUSTOM;
}

void DlgWinResize::OnUpdateEditWinrows() 
{
	SetCustom();
	m_SizeMode = SIZE_CUSTOM;
}
