// Win3DPView.cpp : implementation of the CWin3DPView class
//

#include "stdafx.h"
#include "Win3DP.h"
#include "Win3DPDoc.h"
#include "Win3DPView.h"
#include "WinPlot3DP.h"
#include "DlgEditPlotP.h"
#include "DlgGetStart.h"
#include "DlgIntro.h"
#include "DlgTips.h"
#include "DlgHiddenLine.h"
#include "DlgHelpParm.h"
#include "DlgCppProgram.h"
#include "DlgHelpExport.h"
#include "DlgExportPOV.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern	CWin3DPApp theApp;	// access the windows application

#include "..\Common\DlgWinResize.h"

/////////////////////////////////////////////////////////////////////////////
// CWin3DPView

IMPLEMENT_DYNCREATE(CWin3DPView, CView)

BEGIN_MESSAGE_MAP(CWin3DPView, CView)
	//{{AFX_MSG_MAP(CWin3DPView)
	ON_COMMAND(ID_DRAW_PLOT, OnDrawPlot)
	ON_COMMAND(ID_RESIZE_WINDOW, OnResizeWindow)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_HELP_GETTINGSTARTED, OnHelpGettingstarted)
	ON_COMMAND(ID_HELP_HIDDENLINEREMOVAL, OnHelpHiddenlineremoval)
	ON_COMMAND(ID_HELP_INTRODUCTION, OnHelpIntroduction)
	ON_COMMAND(ID_HELP_PLOTPARAMETERS, OnHelpPlotparameters)
	ON_COMMAND(ID_HELP_TIPS, OnHelpTips)
	ON_COMMAND(ID_HELP_CPROGRAMMING, OnHelpCprogramming)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(ID_HELP_EXPORT, OnHelpExport)
	ON_COMMAND(ID_EXPORT_POV, OnExportPov)
	ON_UPDATE_COMMAND_UI(ID_EXPORT_POV, OnUpdateExportPov)
	ON_UPDATE_COMMAND_UI(ID_DRAW_PLOT, OnUpdateDrawPlot)
	ON_UPDATE_COMMAND_UI(ID_FILE_CLOSE, OnUpdateCloseView)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEW, OnUpdateNewView)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWin3DPView construction/destruction

CWin3DPView::CWin3DPView()
{
	m_is_drawn = 0;
}

CWin3DPView::~CWin3DPView()
{
}

BOOL CWin3DPView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CWin3DPView drawing

void CWin3DPView::OnDraw(CDC* pDC)
{
	if (m_plot3D.m_hBitmap==0) return;
	int nwidth, nheight;
	nwidth  = m_plot3D.m_rect.right  - m_plot3D.m_rect.left;
	nheight = m_plot3D.m_rect.bottom - m_plot3D.m_rect.top ;

	// set mapping mode and view port extents
	CSize wsize = CSize(nwidth,nheight);
	pDC->SetMapMode(MM_ISOTROPIC);
	pDC->SetWindowOrg(0,wsize.cy);
	pDC->SetWindowExt(wsize);
	pDC->SetViewportExt(wsize);
	pDC->ScaleViewportExt(1,1,-1,1);	// invert y coordinate
	pDC->StretchBlt(0,0,nwidth,nheight,m_plot3D.m_pMemDC,0,0,nwidth,nheight,SRCCOPY);
}

/////////////////////////////////////////////////////////////////////////////
// CWin3DPView diagnostics

#ifdef _DEBUG
void CWin3DPView::AssertValid() const
{
	CView::AssertValid();
}

void CWin3DPView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CWin3DPDoc* CWin3DPView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWin3DPDoc)));
	return (CWin3DPDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWin3DPView message handlers

void CWin3DPView::OnDrawPlot() 
{
	// create a dialog box and allow user input
	DlgEditPlotP  dlg;
	dlg.AttachCalculator(m_plot3D.m_pXPlotCalc,m_plot3D.m_pYPlotCalc,m_plot3D.m_pZPlotCalc,
						 m_plot3D.m_pRPlotCalc,m_plot3D.m_pGPlotCalc,m_plot3D.m_pBPlotCalc);
	if (dlg.DoModal()!=IDOK)
		return;

	// get clients rectangle size
	GetClientRect(&m_plot_rect);

	// set plot object parameters from dialog info
	m_plot3D.m_surface_name = dlg.m_surface_name;
	m_plot3D.Reset();
	m_plot3D.SetWnd(this,&theApp);
	m_plot3D.SetParameters(dlg.m_uLines,dlg.m_vLines,dlg.m_draw_ulines,dlg.m_draw_vlines,dlg.m_remove_hidden_lines);
	m_plot3D.SetRanges(dlg.m_umin,dlg.m_umax,dlg.m_vmin,dlg.m_vmax);
	m_plot3D.SetViewingPosition(dlg.m_xytilt,dlg.m_zrotate);
	m_plot3D.SetVideoRes((int)m_plot_rect.left,(int)m_plot_rect.top,(int)m_plot_rect.right,(int)m_plot_rect.bottom,dlg.m_scale);
	m_plot3D.SetColorMode(dlg.m_is_color);
	m_plot3D.SetAxisParameters(dlg.m_show_axis);
	m_plot3D.SetMonochromePen(dlg.m_line_color);
	m_plot3D.SetBackgroundColor(dlg.m_background_color);
	m_plot3D.WinSetColorMode(dlg.m_is_color);
	m_plot3D.WinSetMonochromePen(dlg.m_line_color);
	m_plot3D.WinSetBackgroundColor(dlg.m_background_color);

	// draw the plot
	m_is_drawn = 0;
	CWaitCursor wait;	// put up hour glass
	if (m_plot3D.Plot()==0)
		m_is_drawn = 1;
}

void CWin3DPView::OnResizeWindow() 
{
	DlgWinResize dlg;
	if (dlg.DoModal()!=IDOK || !dlg.IsSizeSet())
		return;

	GetParent()->MoveWindow(0,0,dlg.m_WinCols,dlg.m_WinRows,TRUE);
}

// -------------------------------------------------------------------------------
void CWin3DPView::OnEditCopy() 
{
	m_plot3D.CopyDCToClipBoard();
}

// -------------------------------------------------------------------------------
void CWin3DPView::OnHelpGettingstarted() 
{
	CDlgGettingStarted dlg;
	dlg.DoModal();
}

void CWin3DPView::OnHelpHiddenlineremoval() 
{
	CDlgHiddenLine dlg;
	dlg.DoModal();
}

void CWin3DPView::OnHelpIntroduction() 
{
	CDlgIntro dlg;
	dlg.DoModal();
}

void CWin3DPView::OnHelpPlotparameters() 
{
	CDlgHelpParm dlg;
	dlg.DoModal();
}

void CWin3DPView::OnHelpTips() 
{
	CDlgTips dlg;
	dlg.DoModal();
}

void CWin3DPView::OnHelpCprogramming() 
{
	CDlgCppProgram dlg;
	dlg.DoModal();
}

void CWin3DPView::OnHelpExport() 
{
	DlgHelpExport dlg;
	dlg.DoModal();
}

// -------------------------------------------------------------------------------
void CWin3DPView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();

	GetParent()->MoveWindow(0,0,400,400);
}

// -------------------------------------------------------------------------------
void CWin3DPView::OnUpdateDrawPlot(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!m_plot3D.IsRendering());
}

void CWin3DPView::OnUpdateCloseView(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!m_plot3D.IsRendering());
}

void CWin3DPView::OnUpdateNewView(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!m_plot3D.IsRendering());
}

void CWin3DPView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_is_drawn && !m_plot3D.IsRendering());
}

void CWin3DPView::OnUpdateExportPov(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_is_drawn && !m_plot3D.IsRendering());
}

// -------------------------------------------------------------------------------
// Note: POV uses a left handed coordinate system; thus Z = -Z
void CWin3DPView::OnExportPov() 
{
	Triangle3DP* pTri;
	Point3DP* pP1;
	Point3DP* pP2;
	Point3DP* pP3;
	double xo,yo,zo; // object centroid
	double xc,yc,zc; // camera coordinate
	double xsky,ysky,zsky; // unit vector point to sky
	double xat,yat,zat; // vector pointing from camera to object centroid
	double xright,yright,zright; // unit vector pointing to right side of view
	double red_bg, green_bg, blue_bg; // color components
	double xlight[3], ylight[3], zlight[3]; // coordinates of light sources
	double at_dist;
	unsigned i,nt;
	long bgcolor;
	FILE* fhpov=0;
	CString sObjectName;

	// get object name; remove any spaces from surface name
	sObjectName = m_plot3D.m_surface_name;
	sObjectName.Replace(' ', '_'); // replace spaces with underscore
	sObjectName.Replace('\'', '_'); // replace single quotes with underscore

	// allow user to enter POV parameters
	CDlgExportPOV dlg(this,sObjectName);
	if (dlg.DoModal() != IDOK) return;

	// open file for writing
	fhpov = fopen((LPCTSTR)dlg.m_sPovFilePath,"w");
	if (fhpov == NULL)
	{
		MessageBox("Can not open file for writing");
		return;
	}

	CWaitCursor wait;	// put up hour glass

	// calculate background color values
	bgcolor = m_plot3D.GetBackgroundColor();
	red_bg   = (double)GetRValue(bgcolor)/255.;
	green_bg = (double)GetGValue(bgcolor)/255.;
	blue_bg  = (double)GetBValue(bgcolor)/255.;

	// calculate camera and object coordinates
	m_plot3D.GetCenter(&xo,&yo,&zo); // get center of object
	m_plot3D.GetPOVCamera(&xc,&yc,&zc);
	zc = -zc; // POV is a lefty
	zo = -zo; // POV is a lefty

	// calclulate sky unit vector
	xsky = m_plot3D.xof(0., 1., 0.) - m_plot3D.xof(0., 0., 0.);
	ysky = m_plot3D.yof(0., 1., 0.) - m_plot3D.yof(0., 0., 0.);
	zsky = m_plot3D.zof(0., 1., 0.) - m_plot3D.zof(0., 0., 0.);
	zsky = -zsky; // POV uses a left-hand coordinate system

	// calculate right unit vector
	xright = m_plot3D.xof(1., 0., 0.) - m_plot3D.xof(0., 0., 0.);
	yright = m_plot3D.yof(1., 0., 0.) - m_plot3D.yof(0., 0., 0.);
	zright = m_plot3D.zof(1., 0., 0.) - m_plot3D.zof(0., 0., 0.);
	zright = -zright; // POV is a lefty

	// calculate look_at vector
	xat = xc-xo;
	yat = yc-yo;
	zat = zc-zo;
	at_dist = sqrt(xat*xat+yat*yat+zat*zat); // distance from camera to object centroid

	// calculate light source coordinates
	// light#0
	xlight[0] = xo + (xat)*.6 + (xsky*at_dist)*0.6 + (xright*at_dist)*0.6;
	ylight[0] = yo + (yat)*.6 + (ysky*at_dist)*0.6 + (yright*at_dist)*0.6;
	zlight[0] = zo + (zat)*.6 + (zsky*at_dist)*0.6 + (zright*at_dist)*0.6;
	// light#1
	xlight[1] = xo + (xat)*.6 + (xsky*at_dist)*0.6 - (xright*at_dist)*0.6;
	ylight[1] = yo + (yat)*.6 + (ysky*at_dist)*0.6 - (yright*at_dist)*0.6;
	zlight[1] = zo + (zat)*.6 + (zsky*at_dist)*0.6 - (zright*at_dist)*0.6;
	// light#2
	xlight[2] = xo + (xat)*.9 - (xsky*at_dist)*0.6 + (xright*at_dist)*.2;
	ylight[2] = yo + (yat)*.9 - (ysky*at_dist)*0.6 + (yright*at_dist)*.2;
	zlight[2] = zo + (zat)*.9 - (zsky*at_dist)*0.6 + (zright*at_dist)*.2;

	// output POV header commands
	fprintf(fhpov,"// POV Image File Generated from Plot3DP\n");
	fprintf(fhpov,"#include \"colors.inc\"\n");
	fprintf(fhpov,"#include \"textures.inc\"\n\n");
	fprintf(fhpov,"camera {\n");                 
	fprintf(fhpov,"  location <%.6lf, %.6lf, %.6lf>\n",xc,yc,zc); 
	fprintf(fhpov,"  orthographic\n"); 
	fprintf(fhpov,"  sky <%.6lf, %.6lf, %.6lf>\n",xsky,ysky,zsky); 
	fprintf(fhpov,"  look_at <%.6lf, %.6lf, %.6lf>\n",xo,yo,zo);     
	fprintf(fhpov,"}\n");                        
	fprintf(fhpov,"light_source { <%.6lf, %.6lf, %.6lf> colour White }\n",xlight[0],ylight[0],zlight[0]);
	fprintf(fhpov,"light_source { <%.6lf, %.6lf, %.6lf> colour White }\n",xlight[1],ylight[1],zlight[1]);
	fprintf(fhpov,"light_source { <%.6lf, %.6lf, %.6lf> colour White }\n",xlight[2],ylight[2],zlight[2]);
	fprintf(fhpov,"background { color rgb < %.6lf, %.6lf, %.6lf > }\n", red_bg, green_bg, blue_bg);
	fprintf(fhpov,"\n");

	// loop through each triangle
	nt = m_plot3D.TriangleCount();
	fprintf(fhpov,"#declare %s = union { // define the object\n", (LPCTSTR)dlg.m_sPovObjectName);
	for (i=0; i<nt; i++)
	{
		pTri = m_plot3D.GetTriangle(i);
		pP1  = pTri->m_pPnt[0];
		pP2  = pTri->m_pPnt[1];
		pP3  = pTri->m_pPnt[2];
		if (dlg.m_is_smooth)
		{
			fprintf(fhpov," smooth_triangle {<%.6lf,%.6lf,%.6lf>,<%.6lf,%.6lf,%.6lf>,<%.6lf,%.6lf,%.6lf>,<%.6lf,%.6lf,%.6lf>,<%.6lf,%.6lf,%.6lf>,<%.6lf,%.6lf,%.6lf>",
				pP1->m_xf,pP1->m_yf,-pP1->m_zf, -pP1->m_xn,-pP1->m_yn,pP1->m_zn,
				pP2->m_xf,pP2->m_yf,-pP2->m_zf, -pP2->m_xn,-pP2->m_yn,pP2->m_zn,
				pP3->m_xf,pP3->m_yf,-pP3->m_zf, -pP3->m_xn,-pP3->m_yn,pP3->m_zn);
		}
		else
		{
			fprintf(fhpov," triangle {<%.6lf,%.6lf,%.6lf>,<%.6lf,%.6lf,%.6lf>,<%.6lf,%.6lf,%.6lf>",
				pP1->m_xf,pP1->m_yf,-pP1->m_zf,
				pP2->m_xf,pP2->m_yf,-pP2->m_zf,
				pP3->m_xf,pP3->m_yf,-pP3->m_zf);
		}

		if (dlg.m_is_color)
		{
			fprintf(fhpov," pigment {color rgb <%.6lf,%.6lf,%.6lf>}}\n",
				pTri->RedTri()  /(double)PLOT3D_MAX_COLOR,	// 0-1
				pTri->GreenTri()/(double)PLOT3D_MAX_COLOR,	// 0-1
				pTri->BlueTri() /(double)PLOT3D_MAX_COLOR);	// 0-1
		}
		else
		{
			fprintf(fhpov,"}\n");
		}

	} // for i
	fprintf(fhpov," texture { %s } }\n", (LPCTSTR)dlg.m_sPovTextureName);

	// usage
	fprintf(fhpov,"\nobject { %s } // use the object\n", (LPCTSTR)dlg.m_sPovObjectName);

	// cleanup
	fclose(fhpov);
}

// -------------------------------------------------------------------------------

