/* Quat - A 3D fractal generation program */ 
/* Copyright (C) 1997,98 Dirk Meyer */ 
/* (email: dirk.meyer@studbox.uni-stuttgart.de) */ 
/* mail:  Dirk Meyer */ 
/*        Marbacher Weg 29 */ 
/*        D-71334 Waiblingen */ 
/*        Germany */ 
/* */ 
/* This program is free software; you can redistribute it and/or */ 
/* modify it under the terms of the GNU General Public License */ 
/* as published by the Free Software Foundation; either version 2 */ 
/* of the License, or (at your option) any later version. */ 
/* */ 
/* This program is distributed in the hope that it will be useful, */ 
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */ 
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */ 
/* GNU General Public License for more details. */ 
/* */ 
/* You should have received a copy of the GNU General Public License */ 
/* along with this program; if not, write to the Free Software */ 
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */ 
 
#include <qpainter.h>

#include "ColorClipboard.h"

ColorClipboard::ColorClipboard(QWidget *parent = 0, const char *name = 0)
   : QWidget(parent, name)
{
}

void ColorClipboard::paintEvent(QPaintEvent *QP)
{
   QPainter painter(this);

   painter.setBrush(QColor(r, g, b));
   painter.drawRect(0, 0, 20, 20);
   painter.end();
}

void ColorClipboard::SetColor(unsigned char s_r, unsigned char s_g, unsigned char s_b)
{
   r = s_r; g = s_g; b = s_b;
   repaint();
}

void ColorClipboard::GetColor(unsigned char* g_r, unsigned char *g_g, unsigned char *g_b)
{
   *g_r = r; *g_g = g; *g_b = b;
}
