#include <qwidget.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qstring.h>

class MandelPreview : public QWidget
{
   Q_OBJECT
public:
   MandelPreview(QWidget *parent=0, const char *name=0);
   void CalcImage(void);
//   void SetData(double s_cx, double s_cy, double s_ck, double s_cl,
//      double s_bailout, int s_maxiter, int s_formula);
   void SetMyCursor(int x, int y);
   void C2Coo(double cx, double cy, int *x, int *y);
   void Coo2C(int x, int y, double *cx, double *cy);
   double GetCursorX(void);
   double GetCursorY(void);
public slots:
   void setCx(QString);
   void setCy(QString);
   void setCk(QString);
   void setCl(QString);
   void setMaxiter(QString);
   void setBailout(QString);
   void setFormula(int);
   void MoveLeft();
   void MoveRight();
   void MoveUp();
   void MoveDown();
   void ZoomIn();
   void ZoomOut();
signals:
   void cxChanged(const char *);
   void cyChanged(const char *);
protected:
   void paintEvent(QPaintEvent *);
   void mousePressEvent(QMouseEvent *);
   void mouseMoveEvent(QMouseEvent *);
   void mouseReleaseEvent(QMouseEvent *);
private:
   int CalcMPixel(int x, int y);
   void CheckUpdate();
   bool updated;
   double cx, cy, ck, cl, Bailout;
   int Maxiter, Formula;
   double pic_ck, pic_cl, pic_Bailout;
   int pic_Maxiter, pic_Formula;
   bool LButtonPressed;
   double len_x, len_y;
   double mandel_x, mandel_y,
      mandel_lx, mandel_ly;
   int CursorX, CursorY;
   QPixmap *Pixmap;
};

