/* Quat - A 3D fractal generation program */ 
/* Copyright (C) 1997,98 Dirk Meyer */ 
/* (email: dirk.meyer@studbox.uni-stuttgart.de) */ 
/* mail:  Dirk Meyer */ 
/*        Marbacher Weg 29 */ 
/*        D-71334 Waiblingen */ 
/*        Germany */ 
/* */ 
/* This program is free software; you can redistribute it and/or */ 
/* modify it under the terms of the GNU General Public License */ 
/* as published by the Free Software Foundation; either version 2 */ 
/* of the License, or (at your option) any later version. */ 
/* */ 
/* This program is distributed in the hope that it will be useful, */ 
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */ 
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */ 
/* GNU General Public License for more details. */ 
/* */ 
/* You should have received a copy of the GNU General Public License */ 
/* along with this program; if not, write to the Free Software */ 
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */ 
 
#include <qpainter.h>
#include <qstring.h>
//#include "ViewSelector.h"
#include "ViewSelector.moc"
#include "iter.h"

#include <stdio.h>

ViewSelector::ViewSelector(QWidget *parent = 0, const char *name) : QWidget(parent, name)
{
   len_x = 80; len_y = 60;
   v.xres = 80; v.yres = 60; v.zres = 60; state = 0;
   Pixmap = new QPixmap((int)len_x, (int)len_y, -1);
   plane = new QPointArray((int)5);
   CHECK_PTR(Pixmap);
}

void ViewSelector::SetData(int s_x, int s_y, int s_dx, int s_dy)
{
   x = s_x; y = s_y; dx = s_dx; dy = s_dy;
}

void ViewSelector::setView_e(const char *c)
{
   QString s;

   s.setStr(c);
   v.s[0] = s.toDouble(NULL);
   CalcCoo();
}

void ViewSelector::setView_j(const char *c)
{
   QString s;

   s.setStr(c);
   v.s[1] = s.toDouble(NULL);   
   CalcCoo();
}

void ViewSelector::setView_k(const char *c)
{
   QString s;

   s.setStr(c);
   v.s[2] = s.toDouble(NULL);   
   CalcCoo();
}

void ViewSelector::setUp_e(const char *c)
{
   QString s;

   s.setStr(c);
   v.up[0] = s.toDouble(NULL);   
   CalcCoo();
}

void ViewSelector::setUp_j(const char *c)
{
   QString s;

   s.setStr(c);
   v.up[1] = s.toDouble(NULL);   
   CalcCoo();
}

void ViewSelector::setUp_k(const char *c)
{
   QString s;

   s.setStr(c);
   v.up[2] = s.toDouble(NULL);   
   CalcCoo();
}

void ViewSelector::setMove_x(const char *c)
{
   QString s;

   s.setStr(c);
   v.Mov[0] = s.toDouble(NULL);   
   CalcCoo();
}

void ViewSelector::setMove_y(const char *c)
{
   QString s;

   s.setStr(c);
   v.Mov[1] = s.toDouble(NULL);   
   CalcCoo();
}

void ViewSelector::setLxr(const char *c)
{
   QString s;

   s.setStr(c);
   v.LXR = s.toDouble(NULL);   
   CalcCoo();
}

void ViewSelector::CalcCoo()
{
   struct basestruct base, sbase;
   int i, e, j, k;
   int plane_x[4], plane_y[4];
   QPainter painter;
//   QRect qr(0,0,(int)len_x,(int)len_y);
//   QPaintEvent qp(qr);
   int posx, posy, arrowadd;

   /* Draw coordinate system */
   Pixmap->fill(QColor(255,255,255));
   painter.begin(Pixmap);
   painter.setPen(QColor(0, 0, 0));
   /* x axis */
   posy = (int)(len_y/2)/*30*/;
   if (dx>0)
   {
      posx = (int)(len_x/2)+20/*60*/; arrowadd = -6; 
   }
   else
   {
      posx = (int)(len_x/2)-20/*20*/; arrowadd = 6;
   }
   (*plane)[0] = QPoint((int)(len_x/2), (int)(len_y)/2);
   (*plane)[1] = QPoint(posx, posy);
   (*plane)[2] = QPoint(posx+arrowadd, posy-3);
   painter.drawPolyline(*plane, 0, 3);
   (*plane)[0] = QPoint(posx, posy);
   (*plane)[1] = QPoint(posx+arrowadd, posy+3);
   painter.drawPolyline(*plane, 0, 2);
   posy += 10;
   switch (x)
   {
      case 0: painter.drawText(posx-arrowadd, posy, "e", 1); break;
      case 1: painter.drawText(posx-arrowadd, posy, "j", 1); break;
      case 2: painter.drawText(posx-arrowadd, posy, "k", 1); break;
   }
   /* y axis */
   posx = (int)(len_x/2);
   if (dy>0)
   {
      posy = (int)(len_y/2)+20; arrowadd = -6;
   }
   else
   {
      posy = (int)(len_y/2)-20; arrowadd = 6;
   }
   (*plane)[0] = QPoint((int)(len_x/2), (int)(len_y/2));
   (*plane)[1] = QPoint(posx, posy);
   (*plane)[2] = QPoint(posx-3, posy+arrowadd);
   painter.drawPolyline(*plane, 0, 3);
   (*plane)[0] = QPoint(posx, posy);
   (*plane)[1] = QPoint(posx+3, posy+arrowadd);
   painter.drawPolyline(*plane, 0, 2);
   posy += 10;
   if (dy>0) posy = (int)(len_y/2)+20;
   switch (y)
   {
      case 0: painter.drawText(posx + 4, posy, "e", 1); break;
      case 1: painter.drawText(posx + 4, posy, "j", 1); break;
      case 2: painter.drawText(posx + 4, posy, "k", 1); break;
   }
   /* Draw viewpoint and view plane */
   e = (int)(v.s[0]*10); j = (int)(v.s[1]*10); k = (int)(v.s[2]*10);
   if (x==0) vx = e;
   if (x==1) vx = j;
   if (x==2) vx = k;
   if (y==0) vy = e;
   if (y==1) vy = j;
   if (y==2) vy = k;
   if (dx<0) vx *= -1;
   if (dy<0) vy *= -1;
   vx += (int)(len_x/2); vy += (int)(len_y/2);
   if (!calcbase(&base, &sbase, v, 0))
   {
      /* Calculate bitmap coordinates of view rectangle */
      plane_x[0] = (int)(base.O[x]*10);
      plane_x[1] = (int)((base.O[x]+v.LXR*base.x[x])*10);
      plane_x[2] = (int)((base.O[x]+v.LXR*base.x[x]+v.LXR*0.75*base.y[x])*10);
      plane_x[3] = (int)((base.O[x]+v.LXR*0.75*base.y[x])*10);
      plane_y[0] = (int)(base.O[y]*10);
      plane_y[1] = (int)((base.O[y]+v.LXR*base.x[y])*10);
      plane_y[2] = (int)((base.O[y]+v.LXR*base.x[y]+v.LXR*0.75*base.y[y])*10);
      plane_y[3] = (int)((base.O[y]+v.LXR*0.75*base.y[y])*10);
      /* adjust to orientation of axes */
      if (dx<0) 
         for (i=0; i<4; i++) plane_x[i] *= -1;
      if (dy<0)
         for (i=0; i<4; i++) plane_y[i] *= -1;
      for (i=0; i<4; i++)
      {
         plane_x[i] += (int)(len_x/2);
         plane_y[i] += (int)(len_y/2);
         (*plane)[i] = QPoint(plane_x[i], plane_y[i]);
      }
      (*plane)[4] = QPoint(plane_x[0], plane_y[0]);
      painter.setPen(QColor(0,196,0));
      painter.drawPolyline(*plane, 0, -1);
      painter.setPen(QColor(255,128,0));
      painter.drawEllipse(plane_x[0]-1, plane_y[0]-1, 3, 3);
   }
   else
   {
      painter.drawText(1, 16, "not def.", 8);
   }
   painter.setPen(QColor(0, 0, 0));
   painter.drawRect(0, 0, (int)len_x, (int)len_y);
   painter.end();
//   paintEvent(&qp);
   repaint(FALSE);
}

void ViewSelector::paintEvent(QPaintEvent *QP)
{
   QRect R;
   QPainter painter(this);
   R = QP->rect();
   if (R.right()>(int)len_x-1) R.setRight((int)len_x-1);
   if (R.bottom()>(int)len_y-1) R.setBottom((int)len_y-1);
   painter.setClipRect(R);
   painter.drawPixmap(0, 0, *Pixmap, 0, 0, -1, -1);
   if (state==0) painter.setPen(QColor(0, 0, 255));
   else painter.setPen(QColor(255, 0, 0));
   painter.drawRect(vx-2, vy-2, 5, 5);
   painter.end(); painter.flush();

}

void ViewSelector::mousePressEvent(QMouseEvent *QM)
{
//   QRect qr(0,0,(int)len_x,(int)len_y);
//   QPaintEvent qp(qr);

   if (QM->button() == LeftButton && QM->x()>=vx-2 && QM->x()<=vx+2 
      && QM->y()>=vy-2 && QM->y()<=vy+2)
   {
      state = 1;
//      paintEvent(&qp);
      repaint(FALSE);
   }
}

void ViewSelector::mouseMoveEvent(QMouseEvent *QM)
{
   int xm, ym;
   QString s;   

   if (state!=1) return;
   xm = QM->x(); ym = QM->y();
   if (xm<0) xm = 0;
   if (ym<0) ym = 0;
   if (xm>(int)len_x-1) xm = (int)len_x-1;
   if (ym>(int)len_y-1) ym = (int)len_y-1;
   xm -= (int)(len_x/2);
   ym -= (int)(len_y/2);
   if (dx<0) xm *= -1;
   if (dy<0) ym *= -1;
   s.setNum((double)xm/10, 'g', 12);
   switch (x)
   {
      case 0: emit view_e_Changed((const char *)s); break;
      case 1: emit view_j_Changed((const char *)s); break;
      case 2: emit view_k_Changed((const char *)s); break;
   }
   s.setNum((double)ym/10, 'g', 12);  
   switch (y)
   {
      case 0: emit view_e_Changed((const char *)s); break;
      case 1: emit view_j_Changed((const char *)s); break;
      case 2: emit view_k_Changed((const char *)s); break;
   }
}

void ViewSelector::mouseReleaseEvent(QMouseEvent *QM)
{
//   QRect qr(0,0,(int)len_x,(int)len_y);
//   QPaintEvent qp(qr);

   if (QM->button() == LeftButton) 
   {
      state = 0;
//      paintEvent(&qp);
      repaint(FALSE);
   }
}


