/* RenameOptionsTab 
 * Copyright (C) 1999 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package photoorganizer.renderer;

import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;

import rogatkin.*;
import photoorganizer.*;
import photoorganizer.formats.*;
import photoorganizer.directory.JDirectoryChooser;

public final class RenameOptionsTab extends JPanel implements ActionListener,
    DocumentListener, FocusListener, Persistentable {
    public final static String SECNAME = "RenameOptions";
    public final static String MASK = "Mask";
    public final static String ASKEDIT = "AskEdit";
    public final static String REMOVEAFTER = "RemoveAfterRename";
    public final static String COUNTER = "Counter";
    final static String DESTFOLDER = "DestinationFolder";

    public RenameOptionsTab(Controller controller) {
	this.controller = controller;
        setLayout(new GranulatedLayout(5, 5, Resources.CTRL_VERT_SIZE, Resources.CTRL_VERT_GAP,
	    Resources.CTRL_HORIS_INSET, Resources.CTRL_HORIZ_GAP));
        add(new JLabel(Resources.LABEL_NAMEGENMASK), "0,0,4,1");
        add(textfield = new JTextField(), "0,1,4,1");
        textfield.getDocument().addDocumentListener(this);
        add(cb_editnewname = new JCheckBox(Resources.LABEL_EDIT_NEW_NAME), "0,2,2,1,12");
	add(cb_remafter = new JCheckBox(Resources.LABEL_REMOVE_AFTER_REN), "2,2,2,1,12");
        add(new PopupCombo(Resources.MASKS[1], Resources.LABEL_INS_R, this, "4,1,1,1", textfield), "4,1,2,1");
	add(new JLabel(Resources.LABEL_START_COUNTER/*, SwingConstants.RIGHT*/), "0,3,2,1");
	add(tf_counter = new JTextField(), "2,3,1,1");
        tf_counter.setHorizontalAlignment(JTextField.RIGHT);
        add(new JLabel(Resources.LABEL_DESTINATIONDIR), "0,4,4,1");
        add(tf_destdir = new JTextField(), "0,5,4,1");
        add(bt_brws_dstdir = new JButton(Resources.CMD_BROWSE), "4,5,1,1");
        bt_brws_dstdir.addActionListener(this);
	tf_counter.addFocusListener(this);
    }
    
    public void actionPerformed(ActionEvent a) {
	if (a.getSource() == bt_brws_dstdir) {
            JDirectoryChooser dc = new JDirectoryChooser(new JFrame(), tf_destdir.getText(), null);
            if (dc.getDirectory() != null)
                tf_destdir.setText(dc.getDirectory());
        }
    }
    
    public void insertUpdate(DocumentEvent e) {
        changedUpdate(e);
    }
    
    public void removeUpdate(DocumentEvent e) {
        changedUpdate(e);
    }
    
    public void changedUpdate(DocumentEvent e) {
        textfield.setToolTipText(
	    FileNameFormat.makeValidPathName(new FileNameFormat(textfield.getText()).format(controller.sampleJpeg)));
    }

    public void focusGained(FocusEvent e) {
	tf_counter.setText(""+FileNameFormat.counter);
    }
    
    public void focusLost(FocusEvent e) {
    }
    
    public void load() {
        Serializer s = controller.getSerializer();
        textfield.setText(s.arrayToString(s.getProperty(SECNAME, MASK)));
        cb_editnewname.setSelected(Serializer.getInt(s.getProperty(SECNAME, ASKEDIT), 0) == 1);
        cb_remafter.setSelected(Serializer.getInt(s.getProperty(SECNAME, REMOVEAFTER), 0) == 1);
        tf_counter.setText(""+FileNameFormat.counter);
	String f = (String)s.getProperty(SECNAME, DESTFOLDER);
        if (f != null)
            tf_destdir.setText(f);    }
    
    public void save() {
        Serializer s = controller.getSerializer();
        s.setProperty(SECNAME, MASK, textfield.getText());
	s.setProperty(SECNAME, ASKEDIT, cb_editnewname.isSelected()?Resources.I_YES:Resources.I_NO);
	s.setProperty(SECNAME, REMOVEAFTER, cb_remafter.isSelected()?Resources.I_YES:Resources.I_NO);
	s.setProperty(SECNAME, DESTFOLDER, tf_destdir.getText());
	Integer i = Resources.I_NO;
	try {
	    i = new Integer(tf_counter.getText());
	} catch (NumberFormatException e) {
	}
	s.setProperty(SECNAME, COUNTER, i);
        FileNameFormat.counter = i.intValue();
    }

    public static String getNewName(BasicJpeg format, Controller controller) {
        return new FileNameFormat((String)controller.getSerializer().
	    getProperty(SECNAME, MASK), true).format(format);
    }

    Controller controller;
    private JTextField textfield, tf_counter, tf_destdir;
    private JButton bt_brws_dstdir;
    private JCheckBox cb_editnewname, cb_remafter;
}