//----------------------------------------------------------
#include <math.h>
#pragma hdrstop

#include "D3dMove.h"
//----------------------------------------------------------
//      
//----------------------------------------------------------
void Cruise(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->AddTranslation(D3DRMCOMBINE_BEFORE,
                                           0, 0, ctrl->Arg);
  } else {//    
  }
}//---------------------------------------------------------
void HSlide(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->AddTranslation(D3DRMCOMBINE_BEFORE,
                                           ctrl->Arg, 0, 0);
  } else {//    
  }
}//---------------------------------------------------------
void VSlide(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->AddTranslation(D3DRMCOMBINE_BEFORE,
                                           0, ctrl->Arg, 0);
  } else {//    
  }
}//---------------------------------------------------------
void Pitch(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->AddRotation(D3DRMCOMBINE_BEFORE,
                                           1,0,0,ctrl->Arg);
  } else {//    
  }
}//---------------------------------------------------------
void Turn(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->AddRotation(D3DRMCOMBINE_BEFORE,
                                           0,1,0,ctrl->Arg);
  } else {//    
  }
}//---------------------------------------------------------
void Bank(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->AddRotation(D3DRMCOMBINE_BEFORE,
                                           0,0,1,ctrl->Arg);
  } else {//    
  }
}//---------------------------------------------------------
void SetCruise(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  D3DVECTOR vec;
  ctrl->IFrame->GetVelocity(ctrl->IFrame, &vec, FALSE);
  if (fabs(vec.z) >= fabs(ctrl->Lim)) return;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->SetVelocity(ctrl->IFrame,
                    vec.x, vec.y, vec.z + ctrl->Arg, FALSE);
  } else {//    
  }
}//---------------------------------------------------------
void SetHSlide(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  D3DVECTOR vec;
  ctrl->IFrame->GetVelocity(ctrl->IFrame, &vec, FALSE);
  if (fabs(vec.x) >= fabs(ctrl->Lim)) return;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->SetVelocity(ctrl->IFrame,
                    vec.x + ctrl->Arg, vec.y, vec.z, FALSE);
  } else {//    
  }
}//---------------------------------------------------------
void SetVSlide(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  D3DVECTOR vec;
  ctrl->IFrame->GetVelocity(ctrl->IFrame, &vec, FALSE);
  if (fabs(vec.y) >= fabs(ctrl->Lim)) return;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->SetVelocity(ctrl->IFrame,
                    vec.x, vec.y + ctrl->Arg, vec.z, FALSE);
  } else {//    
  }
}//---------------------------------------------------------
void StopMov(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  LPDIRECT3DRMFRAME Iscene = NULL;
  ctrl->IFrame->GetScene(&Iscene);
  if (!Iscene) return;
  ctrl->IFrame->SetVelocity(Iscene, 0, 0, 0, FALSE);
  Iscene->Release();
}//---------------------------------------------------------
void SetPitch(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  D3DVECTOR vec; D3DVALUE a;
  ctrl->IFrame->GetRotation(ctrl->IFrame, &vec, &a);
  if (fabs(a) >= fabs(ctrl->Lim)) return;
  a += ctrl->Arg;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->SetRotation(ctrl->IFrame, 1,0,0, a);
  } else {//    
  }
}//---------------------------------------------------------
void SetTurn(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  D3DVECTOR vec; D3DVALUE a;
  ctrl->IFrame->GetRotation(ctrl->IFrame, &vec, &a);
  if (fabs(a) >= fabs(ctrl->Lim)) return;
  a += ctrl->Arg;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->SetRotation(ctrl->IFrame, 0,1,0, a);
  } else {//    
  }
}//---------------------------------------------------------
void SetBank(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  D3DVECTOR vec; D3DVALUE a;
  ctrl->IFrame->GetRotation(ctrl->IFrame, &vec, &a);
  if (fabs(a) >= fabs(ctrl->Lim)) return;
  a += ctrl->Arg;
  if (ctrl->Msg != WM_MOUSEMOVE) {
     ctrl->IFrame->SetRotation(ctrl->IFrame, 0,0,1, a);
  } else {//    
  }
}//---------------------------------------------------------
void StopRot(PCtrl ctrl) {
  if (!ctrl || !ctrl->IFrame) return;
  D3DVECTOR rvAxis;
  D3DVALUE  rvTheta;
  ctrl->IFrame->GetRotation(ctrl->IFrame,&rvAxis, &rvTheta);
  ctrl->IFrame->SetRotation(ctrl->IFrame, rvAxis.x,
                                     rvAxis.y, rvAxis.z, 0);
}//---------------------------------------------------------
// TSampleCtrl
//----------------------------------------------------------
TSampleCtrl::TSampleCtrl() {
  IFrame = NULL;
  CtrLst = new TStringList;
}//---------------------------------------------------------
TSampleCtrl::~TSampleCtrl() {
  for (int i = 0; i < CtrLst->Count; i++)
     if (CtrLst->Objects[i]) delete CtrLst->Objects[i];
  delete CtrLst;
}//---------------------------------------------------------
void TSampleCtrl::SetFrame(LPDIRECT3DRMFRAME Iframe) {
  for (int i = 0; i < CtrLst->Count; i++) {
     PCtrl ctrl = PCtrl(CtrLst->Objects[i]);
     if (ctrl) ctrl->IFrame = Iframe;
  }
  IFrame = Iframe;
}//---------------------------------------------------------
void TSampleCtrl::SetView(TD3dView* view) {
  for (int i = 0; i < CtrLst->Count; i++) {
     PCtrl ctrl = PCtrl(CtrLst->Objects[i]);
     if (ctrl) ctrl->SetView(view);
  }
}//---------------------------------------------------------
void TSampleCtrl::SetArg(AnsiString& Name, D3DVALUE arg) {
  PCtrl ctrl;
  int index = CtrLst->IndexOf(Name);
  if (index == -1)  return;
  else ctrl = PCtrl(CtrLst->Objects[index]);
  ctrl->Arg = arg;
}//---------------------------------------------------------
void TSampleCtrl::SetLim(AnsiString& Name, D3DVALUE lim) {
  PCtrl ctrl;
  int index = CtrLst->IndexOf(Name);
  if (index == -1)  return;
  else ctrl = PCtrl(CtrLst->Objects[index]);
  ctrl->Lim = lim;
}//---------------------------------------------------------
void TSampleCtrl::AddCtrl(AnsiString& Name, D3DVALUE arg,
  PCTRLRFUN func, Cardinal msg,
  Word CharCode, TShiftState shift)
{
  PCtrl ctrl;
  int index = CtrLst->IndexOf(Name);
  if (index != -1)  ctrl = PCtrl(CtrLst->Objects[index]);
  else {
     ctrl = new TCtrl;
     CtrLst->AddObject(Name, (TObject*)ctrl);
  }
  ctrl->Arg      = arg;
  ctrl->Lim      = arg*10;
  ctrl->Func     = func;
  ctrl->Msg      = msg;
  ctrl->CharCode = CharCode;
  ctrl->Shift    = shift;
}//---------------------------------------------------------
// TSampleStepCtrl
//----------------------------------------------------------
TSampleStepCtrl::TSampleStepCtrl() : TSampleCtrl() {
  TShiftState s;
  //  :
  D3DVALUE L = 1.0;
  AddCtrl("CruiseFwd", L, Cruise, WM_KEYDOWN,VK_NUMPAD0, s);
  AddCtrl("CruiseBck",-L, Cruise, WM_KEYDOWN,VK_DECIMAL, s);
  AddCtrl("HSlideL",   L, HSlide, WM_KEYDOWN,VK_NUMPAD3, s);
  AddCtrl("HSlideR",  -L, HSlide, WM_KEYDOWN,VK_NUMPAD1, s);
  AddCtrl("VSlideU",   L, VSlide, WM_KEYDOWN,VK_SUBTRACT,s);
  AddCtrl("VSlideD",  -L, VSlide, WM_KEYDOWN,VK_ADD,     s);
  //  :
  D3DVALUE A = M_PI / 180;
  AddCtrl("PitchFwd",  A, Pitch,  WM_KEYDOWN,VK_NUMPAD8, s);
  AddCtrl("PitchBck", -A, Pitch,  WM_KEYDOWN,VK_NUMPAD2, s);
  AddCtrl("TurnL",    -A, Turn,   WM_KEYDOWN,VK_NUMPAD4, s);
  AddCtrl("TurnR",     A, Turn,   WM_KEYDOWN,VK_NUMPAD6, s);
  AddCtrl("BankL",     A, Bank,   WM_KEYDOWN,VK_NUMPAD7, s);
  AddCtrl("BankR",    -A, Bank,   WM_KEYDOWN,VK_NUMPAD9, s);
}//---------------------------------------------------------
void TSampleStepCtrl::SetLinearArgs(D3DVALUE arg) {
  SetArg("CruiseFwd", arg);  SetArg("CruiseBck",-arg);
  SetArg("HSlideL",   arg);  SetArg("HSlideR",  -arg);
  SetArg("VSlideU",   arg);  SetArg("VSlideD",  -arg);
}//---------------------------------------------------------
// TSampleFlyCtrl
//----------------------------------------------------------
TSampleFlyCtrl::TSampleFlyCtrl() : TSampleCtrl() {
  TShiftState s;
  //  :
  D3DVALUE L = 1.0;
AddCtrl("SetCruiseFwd",L,SetCruise,WM_KEYDOWN,VK_NUMPAD0,s);
AddCtrl("StpCruiseFwd", 0,StopMov, WM_KEYUP,  VK_NUMPAD0,s);
AddCtrl("SetCruiseBck",-L,SetCruise,WM_KEYDOWN,VK_DECIMAL,s);
AddCtrl("StpCruiseBck", 0,StopMov, WM_KEYUP,  VK_DECIMAL,s);
AddCtrl("SetHSlideL",  L,SetHSlide,WM_KEYDOWN,VK_NUMPAD3,s);
AddCtrl("StpHSlideL",  0,StopMov,  WM_KEYUP,  VK_NUMPAD3,s);
AddCtrl("SetHSlideR", -L,SetHSlide,WM_KEYDOWN,VK_NUMPAD1,s);
AddCtrl("StpHSlideR",  0,StopMov,  WM_KEYUP,  VK_NUMPAD1,s);
AddCtrl("SetVSlideU", L,SetVSlide,WM_KEYDOWN,VK_SUBTRACT,s);
AddCtrl("StpVSlideU",   0,StopMov,  WM_KEYUP,VK_SUBTRACT,s);
AddCtrl("SetVSlideD",  -L,SetVSlide,WM_KEYDOWN,VK_ADD,   s);
AddCtrl("StpVSlideD",   0,StopMov,  WM_KEYUP,  VK_ADD,   s);
//  :
D3DVALUE A = M_PI / 180;
AddCtrl("SetPitchFwd",  A,SetPitch,WM_KEYDOWN,VK_NUMPAD8,s);
AddCtrl("StpPitchFwd",  0,StopRot, WM_KEYUP,  VK_NUMPAD8,s);
AddCtrl("SetPitchBck", -A,SetPitch,WM_KEYDOWN,VK_NUMPAD2,s);
AddCtrl("StpPitchBck",  0,StopRot, WM_KEYUP,  VK_NUMPAD2,s);
AddCtrl("SetTurnL",    -A,SetTurn, WM_KEYDOWN,VK_NUMPAD4,s);
AddCtrl("StpTurnL",     0,StopRot, WM_KEYUP,  VK_NUMPAD4,s);
AddCtrl("SetTurnR",     A,SetTurn, WM_KEYDOWN,VK_NUMPAD6,s);
AddCtrl("StpTurnR",     0,StopRot, WM_KEYUP,  VK_NUMPAD6,s);
AddCtrl("SetBankL",     A,SetBank, WM_KEYDOWN,VK_NUMPAD7,s);
AddCtrl("StpBankL",     0,StopRot, WM_KEYUP,  VK_NUMPAD7,s);
AddCtrl("SetBankR",    -A,SetBank, WM_KEYDOWN,VK_NUMPAD9,s);
AddCtrl("StpBankR",     0,StopRot, WM_KEYUP,  VK_NUMPAD9,s);
}//---------------------------------------------------------
void TSampleFlyCtrl::SetFrame(LPDIRECT3DRMFRAME Iframe) {
  if (IFrame) { //    :
     TRY(IFrame->DeleteMoveCallback(Stay,  NULL));
     TRY(IFrame->DeleteMoveCallback(Shake, NULL));
  }
  TSampleCtrl::SetFrame(Iframe);
  if (IFrame) { //   :
    TRY(Iframe->AddMoveCallback(Stay,  NULL));
    TRY(Iframe->AddMoveCallback(Shake, NULL));
  }
}//---------------------------------------------------------
void Stay(LPDIRECT3DRMFRAME Iframe, LPVOID /*arg*/,
     D3DVALUE /*delta*/)
{
  LPDIRECT3DRMFRAME Iscene = NULL;
  Iframe->GetScene(&Iscene);
  D3DRMBOX box;
  FrameGetBox(Iscene, &box);
  D3DVECTOR pos;
  Iframe->GetPosition(Iscene, &pos);
  if (pos.x < box.min.x) pos.x = box.min.x;
  if (pos.y < box.min.y) pos.y = box.min.y;
  if (pos.z < box.min.z) pos.z = box.min.z;
  if (pos.x > box.max.x) pos.x = box.max.x;
  if (pos.y > box.max.y) pos.y = box.max.y;
  if (pos.z > box.max.z) pos.z = box.max.z;
  Iframe->SetPosition(Iscene, pos.x, pos.y, pos.z);
  Iscene->Release();
}//---------------------------------------------------------
D3DVALUE shake = 0.5;
void Shake(LPDIRECT3DRMFRAME Iframe, LPVOID /*arg*/,
     D3DVALUE /*delta*/)
{
  static TDateTime LastTime = Now();
  TDateTime SpentTime = Now() - LastTime;
  unsigned short hour, min, sec, msec;
  SpentTime.DecodeTime(&hour, &min, &sec, &msec);
  if (msec >= 10) {
    Iframe->AddTranslation(D3DRMCOMBINE_BEFORE, 0,shake,0);
    shake = -shake;
  }
  LastTime = Now();
}//---------------------------------------------------------
