//----------------------------------------------------------
#ifndef D3dUtilH
#define D3dUtilH
#include <vcl\vcl.h>
#include <d3drmwin.h>
#include <mapicode.h>
//----------------------------------------------------------
//      
//  HRError()   hr AnError
#define TRY(exp) \
{{ \
   HRESULT hr = exp; \
   if(HR_FAILED(hr)) { \
      HRError(__FILE__, __LINE__, hr, #exp); \
      return; \
   } \
}}
//----------------------------------------------------------
#define RELEASE(p) { if(p) {p->Release(); p = NULL;} }
#define ASLIGHT(p)   (LPDIRECT3DRMLIGHT(p))
#define ASFRAME(p)   (LPDIRECT3DRMFRAME(p))
#define ASOBJECT(p)  (LPDIRECT3DRMOBJECT(p))
#define ASVISUAL(p)  (LPDIRECT3DRMVISUAL(p))
#define ASBUILDER(p) (LPDIRECT3DRMMESHBUILDER(p))
#define ASTEXTURE(p) (LPDIRECT3DRMTEXTURE(p))
#define ASFACE(p)    (LPDIRECT3DRMFACE(p))
//----------------------------------------------------------
//     D3dMacs.h   SDK:
//----------------------------------------------------------
#define PUTD3DINSTRUCTION(op, sz, cnt, ptr)                \
    ((LPD3DINSTRUCTION) ptr)->bOpcode = op;                \
    ((LPD3DINSTRUCTION) ptr)->bSize   = sz;                \
    ((LPD3DINSTRUCTION) ptr)->wCount  = cnt;               \
    ptr = (void *)(((LPD3DINSTRUCTION) ptr) + 1)
//----------------------------------------------------------
#define OP_STATE_LIGHT(cnt, ptr)                           \
PUTD3DINSTRUCTION(D3DOP_STATELIGHT,sizeof(D3DSTATE),cnt,ptr)
//----------------------------------------------------------
#define OP_STATE_RENDER(cnt, ptr)                          \
PUTD3DINSTRUCTION(D3DOP_STATERENDER,sizeof(D3DSTATE),cnt,ptr)
//----------------------------------------------------------
#define OP_EXIT(ptr)                                       \
PUTD3DINSTRUCTION(D3DOP_EXIT, 0, 0, ptr)
//----------------------------------------------------------
#define STATE_DATA(type, arg, ptr)                         \
((LPD3DSTATE) ptr)->drstRenderStateType =                  \
                                  (D3DRENDERSTATETYPE)type;\
((LPD3DSTATE) ptr)->dwArg[0] = arg;                        \
ptr = (void *)(((LPD3DSTATE) ptr) + 1)
//----------------------------------------------------------
#define D3DSTATE_OVERRIDE(type) ((DWORD) (type) +          \
        D3DSTATE_OVERRIDE_BIAS)
//----------------------------------------------------------
typedef enum _PROJECTION {
    PROJECTION_POS  = 1,
    PROJECTION_POSX = 2,
    PROJECTION_POSY = 3,
    PROJECTION_POSZ = 4,
    PROJECTION_NEG  = 5,
    PROJECTION_NEGX = 6,
    PROJECTION_NEGY = 7,
    PROJECTION_NEGZ = 8,
} PROJECTION;
//----------------------------------------------------------
AnsiString    HRString(HRESULT hr);
void          HRError(char *file, int line,
                                     HRESULT hr, char *exp);
//----------------------------------------------------------
char *RMName(const void* ptr);
char *RMClassName(const void* ptr);
//----------------------------------------------------------
bool IsD3D    (const void* ptr, const char* name);
bool IsFrame  (const void* ptr);
bool IsFace   (const void* ptr);
bool IsMesh   (const void* ptr);
bool IsBuilder(const void* ptr);
bool IsTexture(const void* ptr);
bool IsLight  (const void* ptr);
bool IsShadow (const void* ptr);
bool IsVisual (const void* ptr);
//----------------------------------------------------------
void ClearFrame(LPDIRECT3DRMFRAME IPar);
void CopyFrame(LPDIRECT3DRMFRAME Idst,
               LPDIRECT3DRMFRAME Isrc, bool clone = false);
//----------------------------------------------------------
DWORD BitDepth();
LPGUID FindDevice(D3DCOLORMODEL model = D3DCOLOR_MONO);
//----------------------------------------------------------
void BuilderRotate(LPDIRECT3DRMMESHBUILDER  IBuilder,
                   D3DVALUE x, D3DVALUE y, D3DVALUE z,
                   D3DVALUE theta);
LPDIRECT3DRMFACE GetFaceAt(LPDIRECT3DRMVIEWPORT  IRMVport,
                           LPDIRECT3DRMFRAME     IFrame,
                           LPDIRECT3DRMFACEARRAY IFaces,
                           int X, int Y);
HRESULT FrameGetBox(LPDIRECT3DRMFRAME IFrame,
                    D3DRMBOX *pBox);
void FrameProjection(LPDIRECT3DRMFRAME IFrame,
                     LPDIRECT3DRMVIEWPORT IRMVport,
                     PROJECTION proj);
void BuilderProjection(LPDIRECT3DRMMESHBUILDER IBuilder,
                       LPDIRECT3DRMVIEWPORT IRMVport,
                       PROJECTION proj);
void BoxProjection(D3DRMBOX *pBox,
                   LPDIRECT3DRMVIEWPORT IRMVport,
                   PROJECTION proj);
void ViewPoint(LPDIRECT3DRMFRAME IFrame,
               LPDIRECT3DRMVIEWPORT IRMVport,
               D3DVALUE x,  D3DVALUE y,  D3DVALUE z,
               D3DVALUE rx, D3DVALUE ry, D3DVALUE rz);
void ViewBox(D3DRMBOX &Box,
               LPDIRECT3DRMVIEWPORT IRMVport,
               D3DVALUE x,  D3DVALUE y,  D3DVALUE z,
               D3DVALUE rx, D3DVALUE ry, D3DVALUE rz);
//----------------------------------------------------------
HRESULT SetRenderState(
  LPDIRECT3DDEVICE   IDevice,
  D3DRENDERSTATETYPE dwRenderStateType,
  DWORD              dwRenderState);
HRESULT SetRMRenderState(
  LPDIRECT3DRMDEVICE IRMDevice,
  D3DRENDERSTATETYPE dwRenderStateType,
  DWORD              dwRenderState);
//----------------------------------------------------------
#include "_Wraps.h"
void AppDataDestroy(LPDIRECT3DRMOBJECT IObject, LPVOID arg);
//----------------------------------------------------------
struct TAppData {
  TWrap *Wrap;
  // T *;
  TAppData() {memset(this, 0, sizeof(TAppData));}
  ~TAppData() {
     delete Wrap;
     // delete ;
  }
};//--------------------------------------------------------
#endif