//----------------------------------------------------------
#ifndef DXEnumH
#define DXEnumH
#define _MBCS
#define __TRACE
#define __WARN
#include <checks.h>
#include <dstring.h>
#include <d3drmwin.h>
//----------------------------------------------------------
struct TDDDesc {
  LPGUID     guid;
  AnsiString about;
  AnsiString name;
  DDCAPS     DriverCaps;
  DDCAPS     HELCaps;
  TDDDesc() { memset(this, 0, sizeof(TDDDesc)); }
};//--------------------------------------------------------
struct TD3DDesc {
  bool          IsHardware;
  LPGUID        guid;
  AnsiString    about;
  AnsiString    name;
  D3DDEVICEDESC d3ddesc;
  TD3DDesc() { memset(this, 0, sizeof(TD3DDesc)); }
};//--------------------------------------------------------
struct TModeDesc {
  DWORD width, height, RGBbits;
  TModeDesc() { memset(this, 0, sizeof(TModeDesc)); }
};//--------------------------------------------------------
struct TEnumModesArg {
  DWORD     GDIMem;
  TD3DDesc *D3DDesc;
  DDCAPS   *ddcaps;
  TEnumModesArg(){ memset(this, 0, sizeof(TEnumModesArg)); }
};//--------------------------------------------------------
BOOL WINAPI DDEnumCallback(LPGUID guid, LPSTR about,
  LPSTR name, LPVOID arg);
//----------------------------------------------------------
HRESULT WINAPI D3DEnumDevicesCallback (
  LPGUID guid, LPSTR about, LPSTR name,
  LPD3DDEVICEDESC hw_d3ddesc,
  LPD3DDEVICEDESC hel_d3ddesc, LPVOID arg);
//----------------------------------------------------------
HRESULT WINAPI EnumModesCallback(LPDDSURFACEDESC ddsd,
  LPVOID arg);
//----------------------------------------------------------
void RMTraceObjects(LPDIRECT3DRM IRM);
//----------------------------------------------------------
void ResetDdDescriptions();
extern TStrings *DdDescriptions;
void ResetD3dDescriptions();
extern TStrings *D3dDescriptions;
void ResetVideoModes();
extern TStrings *VideoModes;
//----------------------------------------------------------
#endif
