//----------------------------------------------------------
#include <vcl\vcl.h>
#include <checks.h>
#include <values.h>
#include <math.h>
#pragma hdrstop
//----------------------------------------------------------
#include "FrmDesgn.h"
#include "FrmSave.h"
#include "FrmSetup.h"
#include "FrmMatl.h"
#include "FrmTextr.h"
#include "FrmSplsh.h"
#include "D3dUtil.h"
#include "D3dInOut.h"
#include "FrmWrap.h"
//----------------------------------------------------------
#pragma resource "*.dfm"
TDesignForm *DesignForm;
//----------------------------------------------------------
#include "_ToTree.cpp"  //   
#include "_GetImIx.cpp" //    
#include "_Create.cpp"  //   
#include "_Delete.cpp"  //   
#include "_Loaders.cpp" //     
#include "_Savers.cpp"  //     
#include "_Edit.cpp"    //  
#include "_Drag.cpp"    //   
#include "_Select.cpp"  //     
#include "_Drawing.cpp" //    
#include "_Tools.cpp"   //   
#include "_Color.cpp"   //  
#include "_Look.cpp"    //  
#include "_Trans.cpp"   //    
#include "_Manip.cpp"   //   
#include "_Appeare.cpp" //   
//----------------------------------------------------------
__fastcall TDesignForm::TDesignForm(TComponent* Owner)
  : TForm(Owner)
{
  D3dView = new TD3dView(this);
  D3dView->Parent  = this;
  D3dView->Align   = alClient;
  D3dView->Enabled = true;
  D3dView->TabStop = true;
  D3dView->Color   = clBlack;

  Vport = new TVport(D3dView);
  Vport->Parent       = D3dView;
  Vport->Align        = alClient;
  Vport->OnMouseDown  = VportMouseDown;
  Vport->OnMouseMove  = VportMouseMove;

  Ctrl = new TSampleStepCtrl();
  Ctrl->SetView(D3dView);

  D3dView->Init();
  D3dView->OnRedraw = UpdateTools;
  Vport->IRMVport->SetBack(3333);
  Ctrl->SetFrame(Vport->GetCamera());

  IRM = D3dView->IRM;
  AnsiString TexPath = ExtractFilePath(ParamStr(0));
  TexPath += "Textures\\";
  IRM-> AddSearchPath(TexPath.c_str());
  IRM->CreateFrame(D3dView->IScene, &IScene);
  IScene->SetName("The_Scene");

  //      :
  Tree->Items->Clear();

  if (FileExists("Default.x")) {
     IScene->SetName("");
     LoadScene(IScene, "Default.x");
     LPDIRECT3DRMFRAMEARRAY IFrames = NULL;
     IScene->GetChildren(&IFrames);
     if (IFrames && (IFrames->GetSize()==1)) {
        IScene->Release();
        IFrames->GetElement(0, &IScene);
        IFrames->Release();
     }
     FrameProjection(IScene,Vport->IRMVport,PROJECTION_POS);
     Tree->FullExpand();
  }

  FrameToTree(IScene);
  EditorState("Untitled", false);
}//---------------------------------------------------------
void __fastcall TDesignForm::FormClose(TObject*,
  TCloseAction &Action)
{
  // if CanClose();
  D3dView->OnRedraw = NULL;
  ClearFrame(IScene);
  RELEASE(IScene);
}//---------------------------------------------------------
void __fastcall TDesignForm::TreeEdited(TObject*,
  TTreeNode *Node, AnsiString &S)
{
  ASOBJECT(Node->Data)->SetName(S.c_str());
  TreeChange(this, Node);
  ClipboardNode = NULL;
}//---------------------------------------------------------
void __fastcall TDesignForm::TreeEditing(TObject*,
  TTreeNode *Node, bool &AllowEdit)
{
  if (IsTexture(Node->Data)) AllowEdit = false;
}//---------------------------------------------------------
TTreeNode* __fastcall TDesignForm::CurrentFrameNode() {
  TTreeNode *Node = Tree->Selected;
  if (!Node) return NULL;
  if (!IsFrame(Node->Data))
  do Node = Node->Parent;
  while ((Node) && (!IsFrame(Node->Data)));
  return Node;
}//---------------------------------------------------------
void __fastcall TDesignForm::CheckSave() {
  if (!Modified) return;
  char buf[512];
  sprintf(buf,"Save changes to \"%s\"",CurrFileName.c_str());
  int ok = Application->MessageBox(buf, "Modified",
                                            MB_YESNOCANCEL);
  if (ok == ID_YES) cmdSaveSceneClick(this);
  if (ok == ID_CANCEL) Abort();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdFileNewClick(TObject*) {
  CheckSave();
  RELEASE(ISelFace);
  RELEASE(ISelBuilder);
  RELEASE(ISelFrame);
  ClearFrame(IScene);
  IScene->SetName("The_Scene");
  //  ,  
  //  :
  MaterialForm->Manage(NULL);
  WrapForm->Manage(NULL);
  TextureForm->Manage(NULL);

  RebuildTree(this);
  D3dView->Render();
  EditorState("Untitled", false);
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdSaveSceneClick(TObject*) {
  if (CurrFileName == "Untitled")
  cmdSaveSceneAsClick(this);
  else Save(CurrFileName);
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdSaveSceneAsClick(TObject*) {
  SaveDlg->Title = "Save Scene As";
  if (SaveDlg->Execute()) Save(SaveDlg->FileName);
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdFileExitClick(TObject*) {
  Close();
}//---------------------------------------------------------
//      TreePopup:
void __fastcall TDesignForm::Level1Click(TObject* Sender) {
  TMenuItem* MenuItem = dynamic_cast<TMenuItem*>(Sender);
  if (!MenuItem) return;
  AnsiString st = MenuItem->Caption;
  st.Unique(); //    MenuItem->Caption
  st.Delete(1, st.Pos(" "));
  int level = st.ToInt();
  TTreeNode* Node = Tree->TopItem;
  if (!Node) return;
  do {
     if (Node->Level < level) Node->Expanded = true;
     else Node->Expanded = false;
     Node = Node->GetNext();
  } while (Node);
}//---------------------------------------------------------
void __fastcall TDesignForm::CollapseClick(TObject*) {
  Tree->FullCollapse();
}//---------------------------------------------------------
void __fastcall TDesignForm::ExpandClick(TObject*) {
  Tree->FullExpand();
}//---------------------------------------------------------
void __fastcall TDesignForm::RebuildTree(TObject*) {
  Tree->Items->BeginUpdate();
  Tree->OnChange = NULL;
  Tree->Items->Clear();
  Tree->Items->EndUpdate();
  FrameToTree(IScene);
  Tree->OnChange = TreeChange;
  Tree->FullExpand();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdDirect3DClick(TObject*) {
  SetupForm->D3dView = D3dView;
  SetupForm->ShowModal();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdMaterialClick(TObject*) {
  MaterialForm->Show();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdTextureClick(TObject*) {
  TextureForm->Show();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdWrapClick(TObject*) {
  WrapForm->Show();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdAboutClick(TObject *) {
  SplashForm->ShowModal();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdBackColorClick(TObject *) {
  ColorDlg->Color = D3dView->Color;
  if (ColorDlg->Execute()) D3dView->Color = ColorDlg->Color;
}//---------------------------------------------------------
void __fastcall TDesignForm::FormCloseQuery(TObject *Sender,
   bool &CanClose)
{
  try {CheckSave();}
  catch (...) {CanClose = false;}
}//---------------------------------------------------------
void __fastcall TDesignForm::Contents1Click(TObject*) {
  Application->HelpContext(10);
}//---------------------------------------------------------
