void __fastcall TDesignForm::cmdSaveMeshClick(TObject*) {
  SaveDlg->Title = "Save Mesh";
  SaveDlg->FileName = Tree->Selected->Text;
  if (!SaveDlg->Execute()) return;
  if (SaveForm->ShowModal() != mrOk) return;
  StatBar->SimpleText  = "Saving Mesh...";
  StatBar->SimplePanel = true; StatBar->Update();

  TTreeNode* Node = Tree->Selected;
  LPDIRECT3DRMMESHBUILDER IBuilder = NULL;
  if (IsBuilder(Node->Data)) {
     IBuilder = ASBUILDER(Node->Data);
     IBuilder->AddRef();
  }
  else {
     Node = CurrentFrameNode();
     LPDIRECT3DRMFRAME Iframe = ASFRAME(Node->Data);
     IRM->CreateMeshBuilder(&IBuilder);
     IBuilder->AddFrame(Iframe);
  }
  hr = IBuilder->Save(SaveDlg->FileName.c_str(),
                       SaveForm->Format, SaveForm->Options);
  if (HR_FAILED(hr)) {
     AnsiString er = "Could't save mesh\nHRESULT = ";
     er += HRString(hr);
     Application->MessageBox(er.c_str(), "Save error",
                                        MB_ICONEXCLAMATION);
  }
  RELEASE(IBuilder);
  StatBar->SimpleText  = ""; StatBar->Update();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdSaveFrameClick(TObject*) {
  TTreeNode* Node = CurrentFrameNode();
  if (!Node) return;

  SaveDlg->Title = "Save Frame";
  SaveDlg->FileName = Tree->Selected->Text;
  if (!SaveDlg->Execute()) return;
  if (SaveForm->ShowModal() != mrOk) return;
  StatBar->SimpleText  = "Saving Frame...";
  StatBar->SimplePanel = true; StatBar->Update();

  LPDIRECT3DRMFRAME Iframe = ASFRAME(Node->Data);
  hr = SaveFrame(Iframe, SaveDlg->FileName.c_str(),
                       SaveForm->Format, SaveForm->Options);
  if (HR_FAILED(hr)) {
     AnsiString er = "Could't save frame\nHRESULT = ";
     er += HRString(hr);
     Application->MessageBox(er.c_str(), "Save error",
                                        MB_ICONEXCLAMATION);
  }
  StatBar->SimpleText  = ""; StatBar->Update();
}//---------------------------------------------------------
void __fastcall TDesignForm::Save(AnsiString& FileName) {
  if (SaveForm->ShowModal() != mrOk) return;
  StatBar->SimpleText  = "Saving Scene...";
  StatBar->SimplePanel = true; StatBar->Update();

  hr = SaveScene(IScene, FileName.c_str(),
                       SaveForm->Format, SaveForm->Options);
  if (HR_FAILED(hr)) {
     AnsiString er = "Could't save scene\nHRESULT = ";
     er += HRString(hr);
     Application->MessageBox(er.c_str(), "Save error",
                                        MB_ICONEXCLAMATION);
  }
  EditorState(FileName, false);
  StatBar->SimpleText  = ""; StatBar->Update();
}//---------------------------------------------------------
