class TD3dView : public TCustomControl {
  TList*  CtrLst;
  bool    InGDISurface;
  bool    FFastLoop;
  bool    FCullNone;
  int     FRMTickValue;
  void __fastcall ChangeColor();
  void __fastcall ReleaseAll();
  bool __fastcall NeedsMove(LPDIRECT3DRMFRAME IFrame);
  TNotifyEvent  FOnRedraw;
protected:
  void __fastcall WndProc(TMessage &Message);
  bool __fastcall CtrlMessage(TMessage &Message);
  void __fastcall HandleActivate(WORD wparam);
  void __fastcall Paint();
  void __fastcall AlignControls(TControl* AControl,
                                               TRect &Rect);
public:
  LPDIRECTDRAW        IDD;
  LPDIRECT3DRM        IRM;
  LPDIRECTDRAWCLIPPER IClipper;
  LPDIRECT3DRMDEVICE  IRMDevice;
  LPDIRECT3DRMFRAME   ICamera;
  LPDIRECT3DRMFRAME   IScene;
  LPDIRECT3DRMLIGHT   IAmbient;
  LPDIRECT3DRMFRAME   IcsFrame;
  __fastcall TD3dView(TComponent* Owner);
  __fastcall ~TD3dView();
  void __fastcall Init(LPGUID DevGUID = NULL);
  void __fastcall Refresh();
  void __fastcall Render();
  void __fastcall Update();
  void __fastcall FlipToGDISurface();
  void __fastcall AddCtrl(PCtrl ctrl){CtrLst->Add(ctrl);}
  void __fastcall RemoveCtrl(PCtrl ctrl){
                                      CtrLst->Remove(ctrl);}
  void __fastcall ClearCtrls(){CtrLst->Clear();}
  void __fastcall SetCSFrame(LPDIRECT3DRMFRAME Iframe);
  void __fastcall RenderLoop(TObject*, bool &Done);
  void __fastcall SetBounds(int ALeft, int ATop,
                                   int AWidth, int AHeight);
__published:
  __property Align;
  __property DragCursor;
  __property DragMode;
  __property Enabled;
  __property Ctl3D;
  __property Font;
  __property ParentFont;
  __property ParentShowHint;
  __property PopupMenu;
  __property ShowHint;
  __property TabOrder;
  __property TabStop;
  __property Visible;
//   ,   TControl:
  __property OnClick;
  __property OnDblClick;
  __property OnDragDrop;
  __property OnDragOver;
  __property OnEndDrag;
  __property OnMouseDown;
  __property OnMouseMove;
  __property OnMouseUp;
  __property OnStartDrag;
//  ,   TWinControl:
  __property OnEnter;
  __property OnExit;
  __property OnKeyDown;
  __property OnKeyPress;
  __property OnKeyUp;
//  
  __property TNotifyEvent OnRedraw = {
                       read = FOnRedraw, write = FOnRedraw};
  __property bool FastLoop = {
      read = FFastLoop, write = FFastLoop, default = false};
  __property bool CullNone = {
      read = FCullNone, write = FCullNone, default = false};
  __property int RMTickValue={
    read = FRMTickValue, write = FRMTickValue, default = 1};
  __property Color;
};//--------------------------------------------------------
