/*
 * Decompiled with CFR 0.152.
 */
package CardioFILE;

import CardioFILE.CardioFileRecord;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import palm.conduit.AbstractRecord;

public class CfProNotRecord
extends CardioFileRecord {
    private String vClaveReg = null;
    private String vHistoria = null;
    private Date vFecha = null;
    private String vObservacion = null;
    private Date vProximaCita = null;
    private Date vProximaHora = null;

    public String getClaveReg() {
        return this.vClaveReg;
    }

    public Date getFecha() {
        return this.vFecha;
    }

    public String getHistoria() {
        return this.vHistoria;
    }

    public String getObservacion() {
        return this.vObservacion;
    }

    public Date getProximaCita() {
        return this.vProximaCita;
    }

    public Date getProximaHora() {
        return this.vProximaHora;
    }

    public void readData(DataInputStream dataInputStream) throws IOException {
        this.vClaveReg = AbstractRecord.readCString(dataInputStream);
        this.vHistoria = AbstractRecord.readCString(dataInputStream);
        this.vFecha = CardioFileRecord.readFecha(dataInputStream);
        this.vObservacion = AbstractRecord.readCString(dataInputStream);
        this.vProximaCita = CardioFileRecord.readFecha(dataInputStream);
        this.vProximaHora = this.readTiempo(dataInputStream);
    }

    public void setClaveReg(String string) {
        this.vClaveReg = this.nullIfEmpty(string);
    }

    public void setFecha(Date date) {
        this.vFecha = date;
    }

    public void setHistoria(String string) {
        this.vHistoria = this.nullIfEmpty(string);
    }

    public void setObservacion(String string) {
        this.vObservacion = this.nullIfEmpty(string);
    }

    public void setProximaCita(Date date) {
        this.vProximaCita = date;
    }

    public void setProximaHora(Date date) {
        this.vProximaHora = date;
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        double d;
        if (this.vClaveReg != null) {
            dataOutputStream.write(this.vClaveReg.getBytes());
            dataOutputStream.write(0);
        }
        if (this.vHistoria != null) {
            dataOutputStream.write(this.vHistoria.getBytes());
            dataOutputStream.write(0);
        }
        if (this.vFecha != null) {
            d = 0.0;
            d = CardioFileRecord.cvFechaToLong(this.vFecha);
            dataOutputStream.writeDouble(d);
        }
        if (this.vObservacion != null) {
            dataOutputStream.write(this.vObservacion.getBytes());
            dataOutputStream.write(0);
        }
        if (this.vProximaCita != null) {
            d = 0.0;
            d = CardioFileRecord.cvFechaToLong(this.vProximaCita);
            dataOutputStream.writeDouble(d);
        }
        if (this.vProximaHora != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.vProximaHora);
            double d2 = 0.0;
            d2 = (double)(calendar.get(10) * 10000) + (double)(calendar.get(12) * 100) + (double)calendar.get(13);
            dataOutputStream.writeDouble(d2);
        }
    }
}

