/*
 * Decompiled with CFR 0.152.
 */
package CardioFILEConduit;

import java.io.IOException;
import java.util.Vector;
import palm.conduit.Category;
import palm.conduit.Log;
import palm.conduit.Record;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;

public class CategoryManager {
    private int db;
    SyncProperties props;
    byte[] bytes;

    public CategoryManager(SyncProperties syncProperties, int n) {
        this.props = syncProperties;
        this.db = n;
    }

    public Vector getHHCategories() throws IOException {
        this.bytes = SyncManager.readDBAppInfoBlock(this.db, this.props.remoteNames[0]);
        return Category.parseCategories(this.bytes);
    }

    private int getNextIndex(Vector vector) {
        int n = -1;
        int n2 = 0;
        while (n2 < vector.size()) {
            Category category = (Category)vector.elementAt(n2);
            if (category.getName().equals("")) {
                n = category.getIndex();
                return n;
            }
            ++n2;
        }
        return n;
    }

    private Category matchId(int n, Vector vector) {
        int n2 = 0;
        while (n2 < vector.size()) {
            Category category = (Category)vector.elementAt(n2);
            if (n == category.getId() && n != 0) {
                return category;
            }
            ++n2;
        }
        return null;
    }

    private Category matchName(String string, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Category category = (Category)vector.elementAt(n);
            String string2 = category.getName();
            if (string2 != "" && string.equals(string2)) {
                return category;
            }
            ++n;
        }
        return null;
    }

    private void setDirtyCategoryFlags(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Category category = (Category)vector.elementAt(n);
            category.setIsModified(true);
            ++n;
        }
    }

    public Vector synchronize(Vector vector, Vector vector2) throws IOException {
        Vector vector3 = this.getHHCategories();
        if (this.props.syncType == 6) {
            return vector;
        }
        if (this.props.syncType == 2) {
            return vector3;
        }
        if (vector.size() == 0) {
            int n = 0;
            while (n < vector3.size()) {
                Category category = (Category)vector3.elementAt(n);
                category.setIsModified(false);
                ++n;
            }
            this.writeHHCategories(vector3);
            return vector3;
        }
        if (this.props.syncType != 3) {
            Category category;
            if (this.props.firstDevice == 1) {
                this.setDirtyCategoryFlags(vector3);
            } else if (this.props.firstDevice == 2) {
                this.setDirtyCategoryFlags(vector);
            } else if (this.props.syncType == 1) {
                this.setDirtyCategoryFlags(vector3);
            }
            int n = 0;
            while (n < vector3.size()) {
                category = (Category)vector3.elementAt(n);
                boolean bl = true;
                if (!category.getName().equals("") && !category.isModified() && this.matchName(category.getName(), vector) == null && this.matchId(category.getId(), vector) == null) {
                    try {
                        SyncManager.changeCategory(this.db, category.getIndex(), 0);
                    }
                    catch (SyncException syncException) {
                        Log.err("AddrCond Error: cannot change categories");
                        syncException.printStackTrace();
                        bl = false;
                    }
                    if (bl) {
                        Log.out("Handheld Category Deleted: " + category.getName());
                        category.delete();
                    }
                } else {
                    category.setIsModified(false);
                }
                ++n;
            }
            n = 0;
            while (n < vector.size()) {
                Category category2 = (Category)vector.elementAt(n);
                if (!category2.getName().equals("")) {
                    category = this.matchName(category2.getName(), vector3);
                    if (category != null) {
                        if (category2.getIndex() != category.getIndex()) {
                            int n2 = category2.getIndex();
                            category2.setIndex(category.getIndex());
                            this.updateRecordsCategory(vector2, n2, category2.getIndex());
                        }
                    } else {
                        category = this.matchId(category2.getId(), vector3);
                        if (category != null) {
                            if (category2.isModified()) {
                                category.setName(category2.getName());
                            } else if (category2.getIndex() != category.getIndex()) {
                                int n3 = category2.getIndex();
                                category2.setIndex(category.getIndex());
                                this.updateRecordsCategory(vector2, n3, category2.getIndex());
                            }
                        } else if (!category2.isModified()) {
                            Log.out("Desktop Category Deleted: " + category2.getName());
                            category2.delete();
                        } else {
                            category = (Category)vector3.elementAt(category2.getIndex());
                            if (category.getName().equals("")) {
                                category.setName(category2.getName());
                                category.setId(category2.getId());
                            } else {
                                int n4 = this.getNextIndex(vector3);
                                if (n4 == -1) {
                                    Log.err("AddrCond Error: Too Many Categories. Category not added to handheld device: " + category2.getName());
                                } else {
                                    int n5 = category2.getIndex();
                                    category2.setIndex(n4);
                                    category = (Category)vector3.elementAt(n4);
                                    category.setName(category2.getName());
                                    category.setId(category2.getId());
                                    this.updateRecordsCategory(vector2, n5, category2.getIndex());
                                }
                            }
                        }
                    }
                }
                ++n;
            }
        }
        vector = vector3;
        this.writeHHCategories(vector3);
        return vector3;
    }

    private void updateRecordsCategory(Vector vector, int n, int n2) {
        if (vector != null) {
            vector.trimToSize();
            int n3 = 0;
            while (n3 < vector.size()) {
                Record record = (Record)vector.elementAt(n3);
                if (record.getCategoryIndex() == n) {
                    record.setCategoryIndex(n2);
                }
                ++n3;
            }
        }
    }

    public void writeHHCategories(Vector vector) throws IOException {
        byte[] byArray = Category.toBytes(vector);
        System.arraycopy(byArray, 0, this.bytes, 0, byArray.length);
        SyncManager.writeDBAppInfoBlock(this.db, this.props.remoteNames[0], this.bytes);
    }
}

