/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.DriverManager;
import java.util.Hashtable;
import java.util.Properties;
import org.hsql.Database;
import org.hsql.WebServerConnection;

public class WebServer {
    static final String mServerName = "HypersonicSQL/1.0";
    String mRoot;
    String mDefaultFile;
    char mPathSeparatorChar;
    boolean mSilent;
    Database mDatabase;
    Properties mProperties;

    public static void main(String[] stringArray) {
        WebServer webServer = new WebServer();
        webServer.run(stringArray);
    }

    void printHelp() {
        System.out.println("Usage: java WebServer [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -root <path>          root path for sending files\n    -default <file>       default file when filename is missing\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display print JDBC trace messages\nThe command line arguments override the values in the properties file.");
        System.exit(0);
    }

    private void run(String[] stringArray) {
        Object object;
        Object object2;
        ServerSocket serverSocket = null;
        try {
            String string;
            object2 = new Properties();
            this.mProperties = object2;
            object = new File("WebServer.properties");
            if (((File)object).exists()) {
                FileInputStream fileInputStream = new FileInputStream((File)object);
                ((Properties)object2).load(fileInputStream);
                fileInputStream.close();
            }
            int n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                if (string.equals("-?")) {
                    this.printHelp();
                }
                if (string.charAt(0) == '-') {
                    ((Hashtable)object2).put(string.substring(1), stringArray[n + 1]);
                    ++n;
                }
                ++n;
            }
            n = Integer.parseInt(((Properties)object2).getProperty("port", "80"));
            string = ((Properties)object2).getProperty("database", "test");
            this.mRoot = ((Properties)object2).getProperty("root", "./");
            this.mDefaultFile = ((Properties)object2).getProperty("default", "index.html");
            this.mSilent = ((Properties)object2).getProperty("silent", "true").equalsIgnoreCase("true");
            if (((Properties)object2).getProperty("trace", "false").equalsIgnoreCase("true")) {
                DriverManager.setLogStream(System.out);
            }
            serverSocket = new ServerSocket(n);
            this.mPathSeparatorChar = File.separatorChar;
            this.trace("port    =" + n);
            this.trace("database=" + string);
            this.trace("root    =" + this.mRoot);
            this.trace("default =" + this.mDefaultFile);
            this.trace("silent  =" + this.mSilent);
            this.mDatabase = new Database(string);
            System.out.println("WebServer 1.4 is running");
            System.out.println("Press [Ctrl]+[C] to abort");
        }
        catch (Exception exception) {
            this.traceError("WebServer.run/init: " + exception);
            return;
        }
        try {
            while (true) {
                object2 = serverSocket.accept();
                object = new WebServerConnection((Socket)object2, this);
                ((Thread)object).start();
            }
        }
        catch (IOException iOException) {
            this.traceError("WebServer.run/loop: " + iOException.getMessage());
            return;
        }
    }

    void trace(String string) {
        if (!this.mSilent) {
            System.out.println(string);
        }
    }

    void traceError(String string) {
        System.out.println(string);
    }
}

