/*
 * Decompiled with CFR 0.152.
 */
package org.hsql.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.util.Vector;

public class Grid
extends Panel {
    private Dimension dMinimum;
    private Font hfFont = new Font("Dialog", 1, 12);
    private Font bfFont = new Font("Dialog", 0, 12);
    private FontMetrics fMetrics;
    private Graphics gImage;
    private Image iImage;
    private int iWidth;
    private int iHeight;
    private int iRowHeight;
    private int iFirstRow;
    private int iGridWidth;
    private int iGridHeight;
    private int iX;
    private int iY;
    private String[] sColHead;
    private Vector vData;
    private int[] iColWidth;
    private int iColCount;
    private int iRowCount;
    private Scrollbar sbHoriz;
    private Scrollbar sbVert;
    private int iSbWidth;
    private int iSbHeight;
    private boolean bDrag;
    private int iXDrag;
    private int iColDrag;
    private int lvrRowActual;
    private int lvrColActual;

    public Grid() {
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
    }

    public void addRow(String[] stringArray) {
        if (stringArray.length != this.iColCount) {
            return;
        }
        String[] stringArray2 = new String[this.iColCount];
        int n = 0;
        while (n < this.iColCount) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        this.vData.addElement(stringArray2);
        ++this.iRowCount;
    }

    void adjustScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.iColCount) {
            n += this.iColWidth[n2];
            ++n2;
        }
        this.iGridWidth = n;
        this.iGridHeight = this.iRowHeight * (this.iRowCount + 1);
        this.sbHoriz.setValues(this.iX, this.iWidth, 0, this.iGridWidth);
        n2 = this.iY / this.iRowHeight;
        int n3 = this.iHeight / this.iRowHeight;
        this.sbVert.setValues(n2, n3, 0, this.iRowCount + 1);
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
    }

    private void calcAutoWidth(int n) {
        int n2 = 10;
        n2 = Math.max(n2, this.fMetrics.stringWidth(this.sColHead[n]));
        int n3 = 0;
        while (n3 < this.iRowCount) {
            String[] stringArray = (String[])this.vData.elementAt(n3);
            n2 = Math.max(n2, this.fMetrics.stringWidth(stringArray[n]));
            ++n3;
        }
        this.iColWidth[n] = n2 + 6;
    }

    public void clearRows() {
        this.vData = new Vector();
        this.iRowCount = 0;
        this.iRowHeight = 0;
    }

    private String get(int n, int n2) {
        return ((String[])this.vData.elementAt(n2))[n];
    }

    public String getCellValue() {
        return ((String[])this.vData.elementAt(this.lvrRowActual))[this.lvrColActual];
    }

    public String getCellValue(int n, int n2) {
        return ((String[])this.vData.elementAt(n2))[n];
    }

    Vector getData() {
        return this.vData;
    }

    private String getDisplay(int n, int n2) {
        return ((String[])this.vData.elementAt(n2))[n];
    }

    String[] getHead() {
        return this.sColHead;
    }

    public int getLvrRowActual() {
        return this.lvrRowActual;
    }

    private static int getMaxHeight(FontMetrics fontMetrics) {
        return fontMetrics.getHeight() + 4;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.minimumSize();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.iX = this.sbHoriz.getValue();
                this.iY = this.iRowHeight * this.sbVert.getValue();
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public boolean lvrMouseDown(int n, int n2) {
        if (this.iRowHeight == 0 || n > this.iWidth || n2 > this.iHeight) {
            return true;
        }
        if (this.iWidth <= 0 || this.iHeight <= 0) {
            return true;
        }
        int n3 = this.iRowHeight + 1 - this.iY;
        this.lvrRowActual = 0;
        while (n3 < this.iRowHeight + 1) {
            ++this.lvrRowActual;
            n3 += this.iRowHeight;
        }
        this.iFirstRow = this.lvrRowActual;
        int n4 = n3 + 1;
        while (n4 <= n2 + this.iRowHeight + 1 - this.iY) {
            n4 += this.iRowHeight;
            ++this.lvrRowActual;
        }
        this.lvrRowActual -= 2;
        this.update();
        return true;
    }

    public boolean lvrMouseDrag(int n, int n2) {
        if (this.bDrag && n < this.iWidth) {
            int n3 = n - this.iXDrag;
            if (n3 < 0) {
                n3 = 0;
            }
            this.iColWidth[this.iColDrag] = n3;
            this.adjustScroll();
            this.repaint();
        }
        return true;
    }

    public boolean lvrMouseExit(int n, int n2) {
        if (this.bDrag) {
            this.setCursor(new Cursor(0));
            this.bDrag = false;
        }
        return true;
    }

    public boolean lvrMouseMove(int n, int n2) {
        if (n2 <= this.iRowHeight) {
            int n3 = n;
            n += this.iX - this.iGridWidth;
            int n4 = this.iColCount - 1;
            while (n4 >= 0) {
                if (n > -7 && n < 7) break;
                n += this.iColWidth[n4];
                --n4;
            }
            if (n4 >= 0) {
                if (!this.bDrag) {
                    this.setCursor(new Cursor(11));
                    this.bDrag = true;
                    this.iXDrag = n3 - this.iColWidth[n4];
                    this.iColDrag = n4;
                }
                return true;
            }
        }
        return this.lvrMouseExit(n, n2);
    }

    public Dimension minimumSize() {
        return this.dMinimum;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Color color = Color.white;
        Color color2 = Color.black;
        if (graphics == null) {
            return;
        }
        if (this.iWidth <= 0 || this.iHeight <= 0) {
            return;
        }
        graphics.setColor(Color.gray);
        graphics.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            this.gImage.setFont(this.hfFont);
            if (this.fMetrics == null) {
                this.fMetrics = this.gImage.getFontMetrics();
            }
        }
        if (this.iRowHeight == 0) {
            this.iRowHeight = Grid.getMaxHeight(this.fMetrics);
            n2 = 0;
            while (n2 < this.iColCount) {
                this.calcAutoWidth(n2);
                ++n2;
            }
            this.adjustScroll();
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
        this.gImage.setColor(Color.lightGray);
        this.gImage.drawLine(0, this.iRowHeight, this.iWidth, this.iRowHeight);
        n2 = -this.iX;
        this.gImage.setFont(this.hfFont);
        int n3 = 0;
        while (n3 < this.iColCount) {
            n = this.iColWidth[n3];
            this.gImage.setColor(Color.gray);
            this.gImage.fillRect(n2 + 1, 0, n - 2, this.iRowHeight);
            this.gImage.setColor(Color.black);
            this.gImage.drawString(this.sColHead[n3], n2 + 2, this.iRowHeight - 5);
            this.gImage.setColor(Color.lightGray);
            this.gImage.drawLine(n2 + n - 1, 0, n2 + n - 1, this.iRowHeight - 1);
            this.gImage.setColor(Color.white);
            this.gImage.drawLine(n2 + n, 0, n2 + n, this.iRowHeight - 1);
            n2 += n;
            ++n3;
        }
        this.gImage.setColor(Color.gray);
        this.gImage.fillRect(0, 0, 1, this.iRowHeight);
        this.gImage.fillRect(n2 + 1, 0, this.iWidth - n2, this.iRowHeight);
        this.gImage.drawLine(0, 0, 0, this.iRowHeight - 1);
        n3 = this.iRowHeight + 1 - this.iY;
        n = 0;
        while (n3 < this.iRowHeight + 1) {
            ++n;
            n3 += this.iRowHeight;
        }
        this.iFirstRow = n;
        n3 = this.iRowHeight + 1;
        this.gImage.setFont(this.bfFont);
        while (n3 < this.iHeight && n < this.iRowCount) {
            n2 = -this.iX;
            if (this.lvrRowActual != n) {
                color = Color.white;
                color2 = Color.black;
            } else {
                color = Color.blue;
                color2 = Color.white;
            }
            int n4 = 0;
            while (n4 < this.iColCount) {
                int n5 = this.iColWidth[n4];
                this.gImage.setColor(color);
                this.gImage.fillRect(n2, n3, n5 - 1, this.iRowHeight - 1);
                this.gImage.setColor(color2);
                this.gImage.drawString(this.getDisplay(n4, n), n2 + 2, n3 + this.iRowHeight - 5);
                this.gImage.setColor(Color.lightGray);
                this.gImage.drawLine(n2 + n5 - 1, n3, n2 + n5 - 1, n3 + this.iRowHeight - 1);
                this.gImage.drawLine(n2, n3 + this.iRowHeight - 1, n2 + n5 - 1, n3 + this.iRowHeight - 1);
                n2 += n5;
                ++n4;
            }
            this.gImage.setColor(Color.white);
            this.gImage.fillRect(n2, n3, this.iWidth - n2, this.iRowHeight - 1);
            ++n;
            n3 += this.iRowHeight;
        }
        graphics.drawImage(this.iImage, 0, 0, this);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        this.iHeight = n4 - this.iSbHeight;
        this.iWidth = n3 - this.iSbWidth;
        this.sbHoriz.setBounds(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.setBounds(this.iWidth, 0, this.iSbWidth, this.iHeight);
        this.adjustScroll();
        this.iImage = null;
        this.repaint();
    }

    public void setHead(String[] stringArray) {
        this.vData = new Vector();
        this.iColCount = stringArray.length;
        this.sColHead = new String[this.iColCount];
        this.iColWidth = new int[this.iColCount];
        int n = 0;
        while (n < this.iColCount) {
            this.sColHead[n] = stringArray[n];
            this.iColWidth[n] = 100;
            ++n;
        }
        this.iRowCount = 0;
        this.iRowHeight = 0;
    }

    public void setMinimumSize(Dimension dimension) {
        this.dMinimum = dimension;
    }

    public void update() {
        this.adjustScroll();
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

