/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import GenCns.GenJava.GenericException;
import GenCns.GenJava.PalmStorage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import palm.conduit.Log;

public class GenericHeader
extends PalmStorage {
    public static boolean m_bDebug = false;
    static final int CM_STORAGE_HEADER_SIZE = 80;
    static final int CM_STORAGE_HEADER_VERSION_1 = 1;
    static final int DB_NAMELEN = 32;
    static final int GENERIC_HDR_PAD_SIZE = 4;
    int m_iStructSize;
    int m_iVersion = 1;
    String m_szName;
    int m_iDBVersion = 0;
    int m_iDBCreator;
    int m_iDBType;
    int m_iDBFlags = 0;
    int m_iDBModDate = 0;
    int m_iDBModNumber = 0;
    int m_iDBCreateDate = 0;
    int m_iDBBackupDate = 0;
    int m_iDBRecCount = 0;
    int m_iAppInfo = 0;
    int m_iSortInfo = 0;

    GenericHeader(String string, int n, int n2) {
        if (m_bDebug) {
            Log.AddEntry("* GenericHeader's constructor", -1, false);
        }
        this.m_iStructSize = 84;
        this.m_szName = string;
        this.m_iDBCreator = n;
        this.m_iDBType = n2;
    }

    public void writeGenericData(FileOutputStream fileOutputStream) throws IOException {
        this.logData();
        this.m_iStructSize = 84;
        this.m_iVersion = 1;
        if (m_bDebug) {
            Log.AddEntry("* GenericHeader's writeGenericData", -1, false);
        }
        PalmStorage.writeDword(fileOutputStream, this.m_iStructSize);
        PalmStorage.writeWord(fileOutputStream, this.m_iVersion);
        int n = this.m_szName.length();
        if (n > 32) {
            n = 32;
            this.m_szName = this.m_szName.substring(0, n - 1);
        }
        byte[] byArray = new byte[32];
        try {
            this.m_szName.getBytes(0, this.m_szName.length(), byArray, 0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        fileOutputStream.write(byArray, 0, 32);
        int n2 = 0;
        PalmStorage.writeWord(fileOutputStream, n2);
        PalmStorage.writeDword(fileOutputStream, this.m_iDBVersion);
        PalmStorage.writeDword(fileOutputStream, this.m_iDBCreator);
        PalmStorage.writeDword(fileOutputStream, this.m_iDBType);
        PalmStorage.writeWord(fileOutputStream, this.m_iDBFlags);
        PalmStorage.writeWord(fileOutputStream, n2);
        PalmStorage.writeDword(fileOutputStream, this.m_iDBModDate);
        PalmStorage.writeDword(fileOutputStream, this.m_iDBModNumber);
        PalmStorage.writeDword(fileOutputStream, this.m_iDBCreateDate);
        PalmStorage.writeDword(fileOutputStream, this.m_iDBBackupDate);
        PalmStorage.writeDword(fileOutputStream, this.m_iDBRecCount);
        PalmStorage.writeDword(fileOutputStream, this.m_iAppInfo);
        PalmStorage.writeDword(fileOutputStream, this.m_iSortInfo);
    }

    public void logData() {
        if (m_bDebug) {
            Log.AddEntry("* GenericHeader's Info:", -1, false);
            Log.AddEntry("      StructSize      = " + this.m_iStructSize, -1, false);
            Log.AddEntry("      StructVersion   = " + this.m_iVersion, -1, false);
            Log.AddEntry("      DBName          = " + this.m_szName, -1, false);
            Log.AddEntry("      DBVersion       = " + this.m_iDBVersion, -1, false);
            Log.AddEntry("      Creator ID      = " + this.m_iDBCreator, -1, false);
            Log.AddEntry("      DB Type         = " + this.m_iDBType, -1, false);
            Log.AddEntry("      DB Flags        = " + this.m_iDBFlags, -1, false);
            Log.AddEntry("      DB ModDate      = " + this.m_iDBModDate, -1, false);
            Log.AddEntry("      DB ModNumber    = " + this.m_iDBModNumber, -1, false);
            Log.AddEntry("      DB CreateDate   = " + this.m_iDBCreateDate, -1, false);
            Log.AddEntry("      DB BackupDate   = " + this.m_iDBBackupDate, -1, false);
            Log.AddEntry("      DB Rec Count    = " + this.m_iDBRecCount, -1, false);
            Log.AddEntry("      AppInfo Size    = " + this.m_iAppInfo, -1, false);
            Log.AddEntry("      SortInfo Size   = " + this.m_iSortInfo, -1, false);
        }
    }

    public void readGenericData(FileInputStream fileInputStream) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenericHeader's readGenericData", -1, false);
        }
        try {
            this.m_iStructSize = PalmStorage.readDword(fileInputStream) - 4;
            this.m_iVersion = PalmStorage.readWord(fileInputStream);
            if (this.m_iVersion != 1) {
                throw new GenericException(4393);
            }
            boolean bl = false;
            this.m_szName = "";
            int n = 0;
            while (n < 32) {
                byte by = (byte)PalmStorage.readByte(fileInputStream);
                if (by == 0) {
                    bl = true;
                } else if (!bl) {
                    this.m_szName = this.m_szName + (char)by;
                }
                ++n;
            }
            int n2 = 0;
            n2 = PalmStorage.readWord(fileInputStream);
            this.m_iDBVersion = PalmStorage.readDword(fileInputStream);
            this.m_iDBCreator = PalmStorage.readDword(fileInputStream);
            this.m_iDBType = PalmStorage.readDword(fileInputStream);
            this.m_iDBFlags = PalmStorage.readWord(fileInputStream);
            n2 = PalmStorage.readWord(fileInputStream);
            this.m_iDBModDate = PalmStorage.readDword(fileInputStream);
            this.m_iDBModNumber = PalmStorage.readDword(fileInputStream);
            this.m_iDBCreateDate = PalmStorage.readDword(fileInputStream);
            this.m_iDBBackupDate = PalmStorage.readDword(fileInputStream);
            this.m_iDBRecCount = PalmStorage.readDword(fileInputStream);
            this.m_iAppInfo = PalmStorage.readDword(fileInputStream);
            this.m_iSortInfo = PalmStorage.readDword(fileInputStream);
            this.logData();
        }
        catch (IOException iOException) {
            throw new GenericException(iOException.getMessage());
        }
    }

    public int getModDate() {
        return this.m_iDBModDate;
    }

    public void setDBModDate(int n) {
        this.m_iDBModDate = n;
    }

    public int getDBModNumber() {
        return this.m_iDBModNumber;
    }

    public void setDBModNumber(int n) {
        this.m_iDBModNumber = n;
    }

    public int getDBCreateDate() {
        return this.m_iDBCreateDate;
    }

    public void setDBCreateDate(int n) {
        this.m_iDBCreateDate = n;
    }

    public int getDBBackupDate() {
        return this.m_iDBBackupDate;
    }

    public void setDBBackupDate(int n) {
        this.m_iDBBackupDate = n;
    }

    public int getDBRecCount() {
        return this.m_iDBRecCount;
    }

    public void setDBRecCount(int n) {
        this.m_iDBRecCount = n;
    }

    public int getAppInfoSize() {
        return this.m_iAppInfo;
    }

    public void setAppInfoSize(int n) {
        this.m_iAppInfo = n;
    }

    public int getSortInfoSize() {
        return this.m_iSortInfo;
    }

    public void setSortInfoSize(int n) {
        this.m_iSortInfo = n;
    }
}

