/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import GenCns.GenJava.GenCategoryManager;
import GenCns.GenJava.GenDbInfo;
import GenCns.GenJava.GenericCategory;
import GenCns.GenJava.GenericException;
import GenCns.GenJava.PalmRecord;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import palm.conduit.Log;
import palm.conduit.SyncException;
import palm.conduit.SyncProperties;

public class PalmBaseManager {
    public static boolean m_bDebug = false;
    public static final int GENERIC_FLAG_CATEGORY_SUPPORTED = 1;
    public static final int GENERIC_FLAG_APPINFO_SUPPORTED = 2;
    public static final int GENERIC_FLAG_SORTINFO_SUPPORTED = 4;
    public static final int GENERIC_FLAG_DISCOVER_APPINFO_SUPPORTED = 4096;
    public static final int GENERIC_FLAG_DISCOVER_SORTINFO_SUPPORTED = 8192;
    public static final int CARD_NO = 0;
    public static final int CATEGORY_UNFILED = 0;
    public static final int NEW_RECORD_ID = 0;
    public static final int MAX_CATEGORIES = 16;
    public static final int eIndex = 0;
    public static final int eID = 1;
    public static final int eAttributes = 2;
    public static final int ePending = 3;
    public static final int eGroupCategories = 4;
    public static final int eGroupCategoriesAndAttributes = 5;
    public static final int eRead = 0;
    public static final int eWrite = 1;
    public static final int eReadWrite = 2;
    public static final int eCreate = 3;
    public static final int eByIndex = 0;
    public static final int eByMod = 1;
    public static final int eByCat = 2;
    public static final int eByModInCat = 3;
    public static final int eByAttrArchive = 4;
    public static final int eByAttrNew = 5;
    public static final int eByAttrDelete = 6;
    public static final int eByAttrPending = 7;
    public static final int eByAttrModified = 8;
    public static final int eByAttrNone = 9;
    public String m_szLocalFile = null;
    public PalmRecord[] m_databaseRecords = null;
    public int m_iArraySize = 0;
    public SyncProperties props;
    public String m_DbName = null;
    public int m_findNextMethod = 0;
    public int m_iCurrentFindIndex = 0;
    public int m_iCurrentFindCat = 0;
    public int m_iCurrentFindAttr = 0;
    public Class recordClass;
    public long m_lDatabaseFlags = 0L;
    public int m_iSyncType = 0;
    public GenCategoryManager m_catMgr = null;
    public GenDbInfo m_appInfo = null;
    public GenDbInfo m_sortInfo = null;
    public boolean m_bNeedToSaveAppInfo = false;
    protected int m_recordCount = 0;
    public int m_iArrayIncrement = 500;

    public PalmBaseManager() {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's Constructor()", -1, false);
        }
        try {
            this.recordClass = Class.forName("GenCns.GenJava.PalmRecord");
        }
        catch (Throwable throwable) {
            System.out.println("Uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
    }

    public PalmBaseManager(SyncProperties syncProperties, String string, long l) {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's Constructor(...)", -1, false);
        }
        this.m_DbName = string;
        this.props = syncProperties;
        this.m_iSyncType = this.props.syncType;
        this.m_lDatabaseFlags = l;
        try {
            this.recordClass = Class.forName("GenCns.GenJava.PalmRecord");
        }
        catch (Throwable throwable) {
            System.out.println("Uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
        this.m_szLocalFile = this.props.pathName;
        if (!this.m_szLocalFile.endsWith("\\")) {
            this.m_szLocalFile.concat("\\");
        }
        this.m_szLocalFile = this.props.localName.length() == 0 || this.props.localName.equals("NA") ? this.m_szLocalFile + "GenericDb.dat" : this.m_szLocalFile + this.props.localName;
        if (m_bDebug) {
            Log.AddEntry("*    Local File name = " + this.m_szLocalFile, -1, false);
        }
    }

    protected void AllocateRecordList(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's AllocateRecordList " + n, -1, false);
        }
        try {
            this.m_databaseRecords = new PalmRecord[n];
        }
        catch (Throwable throwable) {
            throw new GenericException(4354);
        }
        this.m_iArraySize = n;
    }

    protected void ReAllocateRecordList(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's ReAllocateRecordList " + n, -1, false);
        }
        PalmRecord[] palmRecordArray = null;
        try {
            palmRecordArray = new PalmRecord[n];
        }
        catch (Throwable throwable) {
            throw new GenericException(4354);
        }
        if (this.m_databaseRecords != null) {
            int n2 = 0;
            while (n2 < this.m_databaseRecords.length) {
                palmRecordArray[n2] = this.m_databaseRecords[n2];
                ++n2;
            }
        }
        this.m_iArraySize = n;
        this.m_databaseRecords = palmRecordArray;
    }

    public PalmRecord findRecById(int n, boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findRecById " + n, -1, false);
        }
        PalmRecord palmRecord = null;
        if (this.m_databaseRecords == null) {
            throw new GenericException(4374);
        }
        int n2 = 0;
        while (n2 < this.m_databaseRecords.length) {
            try {
                if (this.m_databaseRecords[n2] != null && (palmRecord = this.m_databaseRecords[n2]).getId() == n) {
                    palmRecord.setIndex(n2);
                    if (m_bDebug) {
                        Log.AddEntry("      found", -1, false);
                    }
                    return palmRecord;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (Throwable throwable) {
                Log.AddEntry("      Index = " + n2, -1, false);
                throwable.printStackTrace();
                throw new GenericException(4374);
            }
            ++n2;
        }
        if (m_bDebug) {
            Log.AddEntry("      not found", -1, false);
        }
        throw new GenericException(4374);
    }

    public void Open() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's Open", -1, false);
        }
        throw new GenericException(4364);
    }

    public void CloseDB(boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's CloseDB", -1, false);
        }
        throw new GenericException(4364);
    }

    public void Close(boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's Close", -1, false);
        }
        throw new GenericException(4364);
    }

    public boolean areCategoriesSupported() {
        return (this.m_lDatabaseFlags & 1L) > 0L;
    }

    public void setCategoriesSupported(boolean bl) {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's setCategoriesSupported", -1, false);
        }
        if (bl) {
            this.m_lDatabaseFlags |= 1L;
            this.m_lDatabaseFlags |= 2L;
        } else {
            this.m_lDatabaseFlags ^= 1L;
        }
    }

    public PalmRecord FindRecByIndex(int n) throws GenericException {
        PalmRecord palmRecord;
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's FindRecByIndex", -1, false);
        }
        if (this.m_databaseRecords == null) {
            throw new GenericException(4374);
        }
        try {
            palmRecord = this.m_databaseRecords[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new GenericException("Record not found", 4374);
        }
        if (palmRecord == null) {
            throw new GenericException("Record not found", 4374);
        }
        return palmRecord;
    }

    public int getRecordCount() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's getRecordCount", -1, false);
        }
        return this.m_recordCount;
    }

    public void SetRecordCount(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SetRecordCount", -1, false);
        }
        throw new GenericException(4364);
    }

    protected PalmRecord getNewRecord() {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's getNewRecord", -1, false);
        }
        PalmRecord palmRecord = null;
        try {
            palmRecord = (PalmRecord)this.recordClass.newInstance();
        }
        catch (Throwable throwable) {
            System.out.println("Uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
        return palmRecord;
    }

    public PalmRecord findFirstRecByIndex() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findFirstRecByIndex", -1, false);
        }
        this.m_findNextMethod = 0;
        this.m_iCurrentFindIndex = 0;
        return this.findNext();
    }

    public PalmRecord findNext() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findNext", -1, false);
        }
        PalmRecord palmRecord = null;
        switch (this.m_findNextMethod) {
            case 0: {
                palmRecord = this.findNextRecByIndex();
                break;
            }
            case 1: {
                palmRecord = this.findNextModifiedRec();
                break;
            }
            case 2: {
                palmRecord = this.findNextRecInCat();
                break;
            }
            case 3: {
                palmRecord = this.findNextModRecInCat();
                break;
            }
            case 7: {
                palmRecord = this.findNextPendingRec();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
        }
        return palmRecord;
    }

    public PalmRecord findFirstPendingRec() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findFirstPendingRec", -1, false);
        }
        this.m_findNextMethod = 7;
        this.m_iCurrentFindIndex = 0;
        return this.findNext();
    }

    public PalmRecord findFirstModifiedRec() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findFirstModifiedRec", -1, false);
        }
        this.Sort(2);
        this.m_findNextMethod = 1;
        this.m_iCurrentFindIndex = 0;
        return this.findNext();
    }

    public PalmRecord findFirstRecOfAttr(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findFirstRecOfAttr", -1, false);
        }
        this.Sort(2);
        this.m_findNextMethod = 0;
        this.m_iCurrentFindIndex = 0;
        this.m_iCurrentFindAttr = n;
        return this.findNext();
    }

    public PalmRecord findFirstRecInCat(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findFirstRecInCat", -1, false);
        }
        this.Sort(4);
        this.m_findNextMethod = 2;
        this.m_iCurrentFindIndex = 0;
        this.m_iCurrentFindCat = n;
        return this.findNext();
    }

    public PalmRecord findFirstModRecInCat(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findFirstModRecInCat", -1, false);
        }
        this.Sort(5);
        this.m_findNextMethod = 3;
        this.m_iCurrentFindIndex = 0;
        this.m_iCurrentFindCat = n;
        return this.findNext();
    }

    public void deleteCategory(int n, boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's deleteCategory", -1, false);
        }
        throw new GenericException(4364);
    }

    public void changeCategory(int n, int n2) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's changeCategory", -1, false);
        }
        throw new GenericException(4364);
    }

    public void addNewRecord(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's addNewRecord", -1, false);
        }
        try {
            PalmRecord palmRecord2 = (PalmRecord)palmRecord.clone();
            palmRecord2.resetAttribs();
            this.addRec(palmRecord2);
            if (palmRecord2.getId() != palmRecord.getId()) {
                palmRecord.setId(palmRecord2.getId());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Log.err("Unable to clone record");
        }
    }

    public void addRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's AddRec", -1, false);
        }
        int n = this.m_iArraySize;
        if (this.m_recordCount < this.m_iArraySize) {
            n = 0;
            while (n < this.m_iArraySize) {
                if (this.m_databaseRecords[n] == null) {
                    try {
                        this.m_databaseRecords[n] = (PalmRecord)palmRecord.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new GenericException(4354);
                    }
                    this.m_databaseRecords[n].setIndex(n);
                    ++this.m_recordCount;
                    return;
                }
                ++n;
            }
        }
        this.ReAllocateRecordList(this.m_iArraySize + this.m_iArrayIncrement);
        try {
            this.m_databaseRecords[n] = (PalmRecord)palmRecord.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GenericException(4354);
        }
        this.m_databaseRecords[n].setIndex(n);
        ++this.m_recordCount;
    }

    public void ModifyRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's ModifyRec", -1, false);
        }
        PalmRecord palmRecord2 = null;
        try {
            palmRecord2 = this.findRecById(palmRecord.getId(), false);
            int n = palmRecord2.getIndex();
            try {
                this.m_databaseRecords[n] = (PalmRecord)palmRecord.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new GenericException(4354);
            }
            this.m_databaseRecords[n].setIndex(n);
        }
        catch (IOException iOException) {
            throw new GenericException(4374);
        }
    }

    public void DeleteRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's DeleteRec", -1, false);
        }
        PalmRecord palmRecord2 = null;
        try {
            palmRecord2 = this.findRecById(palmRecord.getId(), false);
            this.m_databaseRecords[palmRecord2.getIndex()] = null;
            --this.m_recordCount;
        }
        catch (IOException iOException) {
            throw new GenericException(4357);
        }
    }

    public void ModifyRecByIndex(int n, PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's ModifyRecByIndex", -1, false);
        }
        if (this.m_databaseRecords == null) {
            throw new GenericException(4374);
        }
        try {
            this.m_databaseRecords[n] = (PalmRecord)palmRecord.clone();
            this.m_databaseRecords[n].setIndex(n);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GenericException(4354);
        }
    }

    protected void findFirstRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findFirstRec", -1, false);
        }
        throw new GenericException(4364);
    }

    protected void findNextRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findNextRec", -1, false);
        }
        throw new GenericException(4364);
    }

    public void PurgeDeletedRecs() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's PurgeDeletedRecs", -1, false);
        }
        if (this.m_databaseRecords != null) {
            int n = 0;
            while (n < this.m_databaseRecords.length) {
                try {
                    if (this.m_databaseRecords[n] != null && this.m_databaseRecords[n].isDeleted()) {
                        if (m_bDebug) {
                            Log.AddEntry("      Deleting rec : id = " + this.m_databaseRecords[n].getId(), -1, false);
                        }
                        this.m_databaseRecords[n] = null;
                        --this.m_recordCount;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public void Sort(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's Sort", -1, false);
        }
    }

    public void PreSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's PreSync", -1, false);
        }
        throw new GenericException(4364);
    }

    public void PostSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's PostSync", -1, false);
        }
        throw new GenericException(4364);
    }

    public void PreAppInfoSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's PreAppInfoSync", -1, false);
        }
        throw new GenericException(4364);
    }

    public void PostAppInfoSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's PostAppInfoSync", -1, false);
        }
        throw new GenericException(4364);
    }

    public void MoveRecordCategories(GenericCategory[] genericCategoryArray) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's MoveRecordCategories", -1, false);
        }
        int n = 0;
        while (n < 16) {
            try {
                GenericCategory genericCategory = null;
                genericCategory = genericCategoryArray[n];
                if (genericCategory != null) {
                    this.changeCategory(n, genericCategory.getIndex());
                }
            }
            catch (GenericException genericException) {
                // empty catch block
            }
            ++n;
        }
    }

    public byte[] GetSortInfo() throws SyncException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's GetSortInfo", -1, false);
        }
        return null;
    }

    public void SetSortInfo(byte[] byArray) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SetSortInfo", -1, false);
        }
        throw new GenericException(4364);
    }

    public byte[] getAppInfo() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's getAppInfo", -1, false);
        }
        if (this.m_appInfo == null || this.m_appInfo.getDataSize() == 0) {
            throw new GenericException(4385);
        }
        return this.m_appInfo.getData();
    }

    public void setAppInfo(byte[] byArray) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's setAppInfo", -1, false);
        }
        if (this.m_appInfo == null) {
            this.m_appInfo = new GenDbInfo();
        }
        this.m_appInfo.setData(byArray);
        this.m_bNeedToSaveAppInfo = true;
    }

    public boolean isExtraAppInfo() {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's isExtraAppInfo", -1, false);
        }
        if (this.areCategoriesSupported()) {
            if (this.m_appInfo != null) {
                if (m_bDebug) {
                    Log.AddEntry("      size = " + this.m_appInfo.getDataSize(), -1, false);
                }
                if (this.m_appInfo.getDataSize() > 278) {
                    return true;
                }
            }
        } else if (this.m_appInfo != null) {
            if (m_bDebug) {
                Log.AddEntry("      size = " + this.m_appInfo.getDataSize(), -1, false);
            }
            if (this.m_appInfo.getDataSize() > 0) {
                return true;
            }
        }
        return false;
    }

    public void SetExtraAppInfo(DataOutputStream dataOutputStream) throws IOException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SetExtraAppInfo", -1, false);
        }
        throw new GenericException(4364);
    }

    public void SetExtraAppInfo(byte[] byArray) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SetExtraAppInfo", -1, false);
        }
        if (this.areCategoriesSupported()) {
            if (this.m_appInfo != null) {
                this.m_appInfo.setData(byArray, 278);
                this.m_bNeedToSaveAppInfo = true;
                return;
            }
        } else {
            if (this.m_appInfo == null) {
                this.m_appInfo = new GenDbInfo();
            }
            this.m_appInfo.setData(byArray);
            this.m_bNeedToSaveAppInfo = true;
            return;
        }
        throw new GenericException(4385);
    }

    public byte[] GetExtraAppInfo() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's GetExtraAppInfo", -1, false);
        }
        if (this.areCategoriesSupported()) {
            if (this.m_appInfo != null) {
                return this.m_appInfo.getData(278);
            }
        } else if (this.m_appInfo != null) {
            return this.m_appInfo.getData();
        }
        throw new GenericException(4385);
    }

    public int GetExtraAppInfoSize() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's GetExtraAppInfoSize", -1, false);
        }
        if (this.areCategoriesSupported()) {
            if (this.m_appInfo != null) {
                return this.m_appInfo.getDataSize() - 278;
            }
        } else if (this.m_appInfo != null) {
            return this.m_appInfo.getDataSize();
        }
        throw new GenericException(4385);
    }

    public void GetExtraAppInfo(DataInputStream dataInputStream) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's GetExtraAppInfo", -1, false);
        }
        throw new GenericException(4364);
    }

    public void SetDBInfo(char[] cArray, int n, int n2, int n3, int n4, int n5, long l, long l2, long l3) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SetDBInfo", -1, false);
        }
        throw new GenericException(4364);
    }

    /*
     * Unable to fully structure code
     */
    public int[] getRecIdMap() throws GenericException {
        if (PalmBaseManager.m_bDebug) {
            Log.AddEntry("* PalmBaseManager's getRecIdMap", -1, false);
        }
        var1_1 = this.getRecordCount();
        var2_2 = new int[var1_1];
        var3_3 = 0;
        var4_4 = null;
        try {
            var4_4 = this.findFirstRecByIndex();
            while (var3_3 < var1_1) {
                var2_2[var3_3] = var4_4.getId();
                ++var3_3;
                var4_4 = this.findNext();
            }
        }
        catch (GenericException var5_5) {
            ** while (var3_3 < var1_1)
        }
lbl-1000:
        // 1 sources

        {
            var2_2[var3_3] = -1;
            ++var3_3;
            continue;
        }
lbl21:
        // 2 sources

        return var2_2;
    }

    public void SetRecIdMap(int[] nArray) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SetRecIdMap", -1, false);
        }
        throw new GenericException(4364);
    }

    public void setDiscoverAppInfoSupport(boolean bl) {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's setDiscoverAppInfoSupport", -1, false);
        }
        this.m_lDatabaseFlags = bl ? (this.m_lDatabaseFlags |= 0x1000L) : (this.m_lDatabaseFlags ^= 0x1000L);
    }

    public boolean discoverIsAppInfoSupported() {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's flags - " + this.m_lDatabaseFlags, -1, false);
        }
        if ((this.m_lDatabaseFlags & 0x1000L) > 0L) {
            if (m_bDebug) {
                Log.AddEntry("* PalmBaseManager's discoverIsAppInfoSupported - true", -1, false);
            }
            return true;
        }
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's discoverIsAppInfoSupported - false", -1, false);
        }
        return false;
    }

    public boolean isAppInfoSupported() {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's isAppInfoSupported flags: " + Integer.toString((int)this.m_lDatabaseFlags), -1, false);
        }
        return (this.m_lDatabaseFlags & 2L) > 0L;
    }

    public void setIsAppInfoSupported(boolean bl) {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's setIsAppInfoSupported", -1, false);
        }
        if (bl) {
            this.m_lDatabaseFlags |= 2L;
        } else {
            this.m_lDatabaseFlags ^= 1L;
            this.m_lDatabaseFlags ^= 2L;
        }
    }

    public boolean IsSortInfoSupported() {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's IsSortInfoSupported", -1, false);
        }
        return (this.m_lDatabaseFlags & 4L) > 0L;
    }

    public void setIsSortInfoSupported(boolean bl) {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SetSortInfoSupported", -1, false);
        }
        this.m_lDatabaseFlags = bl ? (this.m_lDatabaseFlags |= 4L) : (this.m_lDatabaseFlags ^= 4L);
    }

    protected void Open(int n) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's Open", -1, false);
        }
        throw new GenericException(4364);
    }

    public void ExtractCategories() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's ExtractCategories", -1, false);
        }
        throw new GenericException(4364);
    }

    public void CompactCategories() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's CompactCategories", -1, false);
        }
        throw new GenericException(4364);
    }

    protected PalmRecord findNextRecByIndex() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findNextRecByIndex", -1, false);
        }
        if (this.m_databaseRecords == null) {
            throw new GenericException(4374);
        }
        PalmRecord palmRecord = null;
        int n = this.m_iCurrentFindIndex;
        while (n < this.m_databaseRecords.length) {
            block6: {
                try {
                    palmRecord = this.m_databaseRecords[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block6;
                }
                if (palmRecord != null) {
                    this.m_iCurrentFindIndex = n + 1;
                    palmRecord.setIndex(n);
                    return palmRecord;
                }
            }
            ++n;
        }
        throw new GenericException(4374);
    }

    protected PalmRecord findNextModifiedRec() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findNextModifiedRec", -1, false);
            Log.AddEntry("      Current Index = " + this.m_iCurrentFindIndex + ", Capacity = " + this.m_iArraySize, -1, false);
        }
        if (this.m_databaseRecords == null) {
            throw new GenericException(4374);
        }
        PalmRecord palmRecord = null;
        int n = this.m_iCurrentFindIndex;
        while (n < this.m_databaseRecords.length) {
            block6: {
                try {
                    palmRecord = this.m_databaseRecords[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block6;
                }
                if (palmRecord != null && (palmRecord.isArchived() || palmRecord.isDeleted() || palmRecord.isModified() || palmRecord.isNew())) {
                    this.m_iCurrentFindIndex = n + 1;
                    palmRecord.setIndex(n);
                    return palmRecord;
                }
            }
            ++n;
        }
        throw new GenericException(4374);
    }

    protected PalmRecord findNextPendingRec() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findNextPendingRec", -1, false);
        }
        if (this.m_databaseRecords == null) {
            throw new GenericException(4374);
        }
        int n = this.m_iCurrentFindIndex;
        while (n < this.m_databaseRecords.length) {
            block6: {
                PalmRecord palmRecord;
                try {
                    palmRecord = this.m_databaseRecords[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block6;
                }
                if (palmRecord != null && palmRecord.isPending()) {
                    this.m_iCurrentFindIndex = n + 1;
                    palmRecord.setIndex(n);
                    return palmRecord;
                }
            }
            ++n;
        }
        throw new GenericException(4374);
    }

    protected PalmRecord findNextRecInCat() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findNextRecInCat", -1, false);
        }
        if (this.m_databaseRecords == null) {
            throw new GenericException(4374);
        }
        int n = this.m_iCurrentFindIndex;
        while (n < this.m_databaseRecords.length) {
            block6: {
                PalmRecord palmRecord;
                try {
                    palmRecord = this.m_databaseRecords[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block6;
                }
                if (palmRecord != null && palmRecord.getCategoryIndex() == this.m_iCurrentFindCat) {
                    this.m_iCurrentFindIndex = n + 1;
                    palmRecord.setIndex(n);
                    return palmRecord;
                }
            }
            ++n;
        }
        throw new GenericException(4374);
    }

    protected PalmRecord findNextModRecInCat() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's findNextModRecInCat", -1, false);
        }
        if (this.m_databaseRecords == null) {
            throw new GenericException(4374);
        }
        int n = this.m_iCurrentFindIndex;
        while (n < this.m_databaseRecords.length) {
            block6: {
                PalmRecord palmRecord;
                try {
                    palmRecord = this.m_databaseRecords[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block6;
                }
                if (palmRecord != null && palmRecord.getCategoryIndex() == this.m_iCurrentFindCat && (palmRecord.isArchived() || palmRecord.isDeleted() || palmRecord.isModified() || palmRecord.isNew())) {
                    this.m_iCurrentFindIndex = n + 1;
                    palmRecord.setIndex(n);
                    return palmRecord;
                }
            }
            ++n;
        }
        throw new GenericException(4374);
    }

    public void SortByID() {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SortByID", -1, false);
        }
    }

    public void SortByAttributes() {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SortByAttributes", -1, false);
        }
    }

    public void SortByPending() {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SortByPending", -1, false);
        }
    }

    public void SortByCategory() {
        if (m_bDebug) {
            Log.AddEntry("* PalmBaseManager's SortByCategory", -1, false);
        }
    }

    public void LogSyncMode() {
        if (m_bDebug) {
            switch (this.m_iSyncType) {
                case 1: {
                    Log.AddEntry("    Sync Mode: Slow", -1, false);
                    break;
                }
                case 0: {
                    Log.AddEntry("    Sync Mode: fast", -1, false);
                    break;
                }
                case 4: {
                    Log.AddEntry("    Sync Mode: install", -1, false);
                    break;
                }
                case 7: {
                    Log.AddEntry("    Sync Mode: profile install", -1, false);
                    break;
                }
                case 6: {
                    Log.AddEntry("    Sync Mode: do nothing", -1, false);
                    break;
                }
                case 3: {
                    Log.AddEntry("    Sync Mode: Pc to HH", -1, false);
                    break;
                }
                case 2: {
                    Log.AddEntry("    Sync Mode: HH to PC", -1, false);
                    break;
                }
                case 5: {
                    Log.AddEntry("    Sync Mode: backup", -1, false);
                    break;
                }
                default: {
                    Log.AddEntry("    Sync Mode: unknown", -1, false);
                }
            }
        }
    }

    public void setLocalFileName(String string) {
        this.m_szLocalFile = this.props.pathName;
        if (!this.m_szLocalFile.endsWith("\\")) {
            this.m_szLocalFile.concat("\\");
        }
        this.m_szLocalFile = this.m_szLocalFile + string;
        int n = string.lastIndexOf(".");
        if (n == -1) {
            this.m_szLocalFile = this.m_szLocalFile + ".DAT";
        }
    }
}

